/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverContext;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

public class ContextDataResolver
implements TemplateResolver {
    private static final ContextDataResolver INSTANCE = new ContextDataResolver();

    private ContextDataResolver() {
    }

    public static ContextDataResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "mdc";
    }

    @Override
    public JsonNode resolve(final TemplateResolverContext context, LogEvent logEvent, String key) {
        ReadOnlyStringMap contextData = logEvent.getContextData();
        if (contextData == null || contextData.isEmpty()) {
            return NullNode.getInstance();
        }
        if (key != null) {
            Object value = contextData.getValue(key);
            if (value == null) {
                return NullNode.getInstance();
            }
            boolean valueExcluded = ContextDataResolver.isValueExcluded(context, value);
            return valueExcluded ? NullNode.getInstance() : (JsonNode)context.getObjectMapper().convertValue(value, JsonNode.class);
        }
        final Pattern keyPattern = context.getMdcKeyPattern();
        final ObjectNode[] contextDataNode = new ObjectNode[]{null};
        contextData.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String key, Object value) {
                boolean valueExcluded;
                boolean keyMatches;
                boolean bl = keyMatches = keyPattern == null || keyPattern.matcher(key).matches();
                if (keyMatches && !(valueExcluded = ContextDataResolver.isValueExcluded(context, value))) {
                    if (contextDataNode[0] == null) {
                        contextDataNode[0] = context.getObjectMapper().createObjectNode();
                    }
                    JsonNode valueNode = (JsonNode)context.getObjectMapper().convertValue(value, JsonNode.class);
                    contextDataNode[0].set(key, valueNode);
                }
            }
        });
        return (JsonNode)ObjectUtils.firstNonNull((Object[])new BaseJsonNode[]{contextDataNode[0], NullNode.getInstance()});
    }

    private static boolean isValueExcluded(TemplateResolverContext context, Object value) {
        return (value == null || value instanceof String && ((String)value).isEmpty()) && context.isEmptyPropertyExclusionEnabled();
    }
}

