/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverContext;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;

public class MessageResolver
implements TemplateResolver {
    private static final MessageResolver INSTANCE = new MessageResolver();
    private static final String NAME = "message";
    private static final String[] FORMATS = new String[]{"JSON"};

    private MessageResolver() {
    }

    public static MessageResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public JsonNode resolve(TemplateResolverContext context, LogEvent logEvent, String key) {
        Message message = logEvent.getMessage();
        return FORMATS[0].equalsIgnoreCase(key) ? MessageResolver.resolveJson(context, message) : MessageResolver.resolveText(context, message);
    }

    private static JsonNode resolveText(TemplateResolverContext context, Message message) {
        String formattedMessage = message.getFormattedMessage();
        boolean messageExcluded = StringUtils.isEmpty((CharSequence)formattedMessage) && context.isEmptyPropertyExclusionEnabled();
        return messageExcluded ? NullNode.getInstance() : new TextNode(formattedMessage);
    }

    private static JsonNode resolveJson(TemplateResolverContext context, Message message) {
        String[] formats;
        if (!(message instanceof MultiformatMessage)) {
            return MessageResolver.createMessageObject(context, message);
        }
        MultiformatMessage multiformatMessage = (MultiformatMessage)message;
        boolean jsonSupported = false;
        for (String format : formats = multiformatMessage.getFormats()) {
            if (!FORMATS[0].equalsIgnoreCase(format)) continue;
            jsonSupported = true;
            break;
        }
        if (!jsonSupported) {
            return MessageResolver.createMessageObject(context, message);
        }
        String messageJson = multiformatMessage.getFormattedMessage(FORMATS);
        JsonNode jsonNode = MessageResolver.readMessageJson(context, messageJson);
        boolean nodeExcluded = MessageResolver.isNodeExcluded(context, jsonNode);
        return nodeExcluded ? NullNode.getInstance() : jsonNode;
    }

    private static JsonNode readMessageJson(TemplateResolverContext context, String messageJson) {
        try {
            return context.getObjectMapper().readTree(messageJson);
        }
        catch (IOException error) {
            throw new RuntimeException("JSON message read failure", error);
        }
    }

    private static JsonNode createMessageObject(TemplateResolverContext context, Message message) {
        JsonNode textNode = MessageResolver.resolveText(context, message);
        if (textNode.isNull()) {
            return NullNode.getInstance();
        }
        ObjectNode node = context.getObjectMapper().createObjectNode();
        node.set(NAME, textNode);
        return node;
    }

    private static boolean isNodeExcluded(TemplateResolverContext context, JsonNode jsonNode) {
        if (!context.isEmptyPropertyExclusionEnabled()) {
            return false;
        }
        if (jsonNode.isNull()) {
            return true;
        }
        if (jsonNode.isTextual() && StringUtils.isEmpty((CharSequence)jsonNode.asText())) {
            return true;
        }
        return jsonNode.isContainerNode() && jsonNode.size() == 0;
    }
}

