/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.vlkan.log4j2.logstash.layout.resolver.ContextDataResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.ContextStackResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.EndOfBatchResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.ExceptionResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.ExceptionRootCauseResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.LevelResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.LoggerResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.MainMapResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.MessageResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.SourceResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.ThreadResolverFactory;
import com.vlkan.log4j2.logstash.layout.resolver.TimestampResolverFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;

enum EventResolverFactories {

    private static final Map<String, TemplateResolverFactory<LogEvent, EventResolverContext, ? extends TemplateResolver<LogEvent>>> RESOLVER_FACTORY_BY_NAME = EventResolverFactories.createResolverFactoryByName();

    private static Map<String, TemplateResolverFactory<LogEvent, EventResolverContext, ? extends TemplateResolver<LogEvent>>> createResolverFactoryByName() {
        List<EventResolverFactory> resolverFactories = Arrays.asList(ContextDataResolverFactory.getInstance(), ContextStackResolverFactory.getInstance(), EndOfBatchResolverFactory.getInstance(), ExceptionResolverFactory.getInstance(), ExceptionRootCauseResolverFactory.getInstance(), LevelResolverFactory.getInstance(), LoggerResolverFactory.getInstance(), MainMapResolverFactory.getInstance(), MessageResolverFactory.getInstance(), SourceResolverFactory.getInstance(), ThreadResolverFactory.getInstance(), TimestampResolverFactory.getInstance());
        LinkedHashMap<String, EventResolverFactory> resolverFactoryByName = new LinkedHashMap<String, EventResolverFactory>();
        for (EventResolverFactory resolverFactory : resolverFactories) {
            resolverFactoryByName.put(resolverFactory.getName(), resolverFactory);
        }
        return Collections.unmodifiableMap(resolverFactoryByName);
    }

    static Map<String, TemplateResolverFactory<LogEvent, EventResolverContext, ? extends TemplateResolver<LogEvent>>> getResolverFactoryByName() {
        return RESOLVER_FACTORY_BY_NAME;
    }
}

