/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public enum JsonGenerators {

    private static final List<RescueAction> RESCUE_ACTIONS = Arrays.asList(new RescueAction(){

        @Override
        public void attempt(JsonGenerator jsonGenerator) throws Throwable {
            jsonGenerator.writeEndObject();
        }
    }, new RescueAction(){

        @Override
        public void attempt(JsonGenerator jsonGenerator) throws Throwable {
            jsonGenerator.writeEndArray();
        }
    }, new RescueAction(){

        @Override
        public void attempt(JsonGenerator jsonGenerator) throws Throwable {
            jsonGenerator.writeNumber(0);
        }
    });

    public static void rescueJsonGeneratorState(ByteBuffer byteBuffer, JsonGenerator jsonGenerator) {
        int rescueActionId = 0;
        while (true) {
            byteBuffer.clear();
            try {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeEndObject();
                jsonGenerator.flush();
                return;
            }
            catch (IOException error) {
                if (error instanceof JsonGenerationException) {
                    try {
                        RescueAction rescueAction = RESCUE_ACTIONS.get(rescueActionId);
                        rescueAction.attempt(jsonGenerator);
                    }
                    catch (Throwable ignored) {}
                } else {
                    throw new RuntimeException(error);
                }
                ++rescueActionId;
                rescueActionId %= RESCUE_ACTIONS.size();
                continue;
            }
            break;
        }
    }

    public static void writeObject(JsonGenerator jsonGenerator, Object object) throws IOException {
        if (object == null) {
            jsonGenerator.writeNull();
            return;
        }
        if (object instanceof String) {
            jsonGenerator.writeString((String)object);
            return;
        }
        if (object instanceof Short) {
            jsonGenerator.writeNumber(((Short)object).shortValue());
            return;
        }
        if (object instanceof Integer) {
            jsonGenerator.writeNumber(((Integer)object).intValue());
            return;
        }
        if (object instanceof Long) {
            jsonGenerator.writeNumber(((Long)object).longValue());
            return;
        }
        if (object instanceof BigDecimal) {
            jsonGenerator.writeNumber((BigDecimal)object);
            return;
        }
        if (object instanceof Float) {
            jsonGenerator.writeNumber(((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            jsonGenerator.writeNumber(((Double)object).doubleValue());
            return;
        }
        if (object instanceof byte[]) {
            jsonGenerator.writeBinary((byte[])object);
            return;
        }
        jsonGenerator.writeObject(object);
    }

    private static interface RescueAction {
        public void attempt(JsonGenerator var1) throws Throwable;
    }
}

