/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vlkan.log4j2.logstash.layout.LogstashLayoutSerializationContext;
import com.vlkan.log4j2.logstash.layout.LogstashLayoutSerializationContexts;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import com.vlkan.log4j2.logstash.layout.resolver.StackTraceElementObjectResolverContext;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolvers;
import com.vlkan.log4j2.logstash.layout.util.ByteBufferOutputStream;
import com.vlkan.log4j2.logstash.layout.util.JsonGenerators;
import com.vlkan.log4j2.logstash.layout.util.Uris;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.ByteBufferDestinationHelper;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.util.Supplier;

@Plugin(name="LogstashLayout", category="Core", elementType="layout", printObject=true)
public class LogstashLayout
implements Layout<String> {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String CONTENT_TYPE = "application/json; charset=" + CHARSET;
    private static final byte[] EMPTY_OBJECT_JSON_BYTES = "{}".getBytes(CHARSET);
    private final TemplateResolver<LogEvent> eventResolver;
    private final byte[] lineSeparatorBytes;
    private final Supplier<LogstashLayoutSerializationContext> serializationContextSupplier;

    private LogstashLayout(Builder builder) {
        ObjectMapper objectMapper = new ObjectMapper();
        StrSubstitutor substitutor = builder.config.getStrSubstitutor();
        TemplateResolver<StackTraceElement> stackTraceElementObjectResolver = null;
        if (builder.stackTraceEnabled) {
            StackTraceElementObjectResolverContext stackTraceElementObjectResolverContext = StackTraceElementObjectResolverContext.newBuilder().setObjectMapper(objectMapper).setSubstitutor(substitutor).setEmptyPropertyExclusionEnabled(builder.emptyPropertyExclusionEnabled).build();
            String stackTraceElementTemplate = LogstashLayout.readStackTraceElementTemplate(builder);
            stackTraceElementObjectResolver = TemplateResolvers.ofTemplate(stackTraceElementObjectResolverContext, stackTraceElementTemplate);
        }
        String eventTemplate = LogstashLayout.readEventTemplate(builder);
        FastDateFormat timestampFormat = LogstashLayout.readDateFormat(builder);
        EventResolverContext resolverContext = EventResolverContext.newBuilder().setObjectMapper(objectMapper).setSubstitutor(substitutor).setTimestampFormat(timestampFormat).setLocationInfoEnabled(builder.locationInfoEnabled).setStackTraceEnabled(builder.stackTraceEnabled).setStackTraceElementObjectResolver(stackTraceElementObjectResolver).setEmptyPropertyExclusionEnabled(builder.emptyPropertyExclusionEnabled).setMdcKeyPattern(builder.mdcKeyPattern).setNdcPattern(builder.ndcPattern).build();
        this.eventResolver = TemplateResolvers.ofTemplate(resolverContext, eventTemplate);
        this.lineSeparatorBytes = builder.lineSeparator.getBytes(CHARSET);
        this.serializationContextSupplier = LogstashLayoutSerializationContexts.createSupplier(objectMapper, builder.maxByteCount, builder.prettyPrintEnabled, builder.emptyPropertyExclusionEnabled);
    }

    private static String readEventTemplate(Builder builder) {
        return LogstashLayout.readTemplate(builder.eventTemplate, builder.eventTemplateUri);
    }

    private static String readStackTraceElementTemplate(Builder builder) {
        return LogstashLayout.readTemplate(builder.stackTraceElementTemplate, builder.stackTraceElementTemplateUri);
    }

    private static String readTemplate(String template, String templateUri) {
        return StringUtils.isBlank((CharSequence)template) ? Uris.readUri(templateUri) : template;
    }

    private static FastDateFormat readDateFormat(Builder builder) {
        TimeZone timeZone = TimeZone.getTimeZone(builder.timeZoneId);
        return FastDateFormat.getInstance((String)builder.dateTimeFormatPattern, (TimeZone)timeZone);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toSerializable(LogEvent event) {
        try (LogstashLayoutSerializationContext context = (LogstashLayoutSerializationContext)this.serializationContextSupplier.get();){
            this.encode(event, context);
            String string = context.getOutputStream().toString(CHARSET);
            return string;
        }
        catch (Exception error) {
            throw new RuntimeException("failed serializing JSON", error);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toByteArray(LogEvent event) {
        try (LogstashLayoutSerializationContext context = (LogstashLayoutSerializationContext)this.serializationContextSupplier.get();){
            this.encode(event, context);
            byte[] byArray = context.getOutputStream().toByteArray();
            return byArray;
        }
        catch (Exception error) {
            throw new RuntimeException("failed serializing JSON", error);
        }
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        try (LogstashLayoutSerializationContext context = (LogstashLayoutSerializationContext)this.serializationContextSupplier.get();){
            this.encode(event, context);
            ByteBuffer byteBuffer = context.getOutputStream().getByteBuffer();
            byteBuffer.flip();
            ByteBufferDestinationHelper.writeToUnsynchronized((ByteBuffer)byteBuffer, (ByteBufferDestination)destination);
        }
        catch (Exception error) {
            throw new RuntimeException("failed serializing JSON", error);
        }
    }

    private void encode(LogEvent event, LogstashLayoutSerializationContext context) throws IOException {
        try {
            this.unsafeEncode(event, context);
        }
        catch (JsonGenerationException ignored) {
            JsonGenerators.rescueJsonGeneratorState(context.getOutputStream().getByteBuffer(), context.getJsonGenerator());
            this.unsafeEncode(event, context);
        }
    }

    private void unsafeEncode(LogEvent event, LogstashLayoutSerializationContext context) throws IOException {
        JsonGenerator jsonGenerator = context.getJsonGenerator();
        this.eventResolver.resolve(event, jsonGenerator);
        jsonGenerator.flush();
        ByteBufferOutputStream outputStream = context.getOutputStream();
        if (outputStream.getByteBuffer().position() == 0) {
            outputStream.write(EMPTY_OBJECT_JSON_BYTES);
        }
        outputStream.write(this.lineSeparatorBytes);
    }

    public byte[] getFooter() {
        return null;
    }

    public byte[] getHeader() {
        return null;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Map<String, String> getContentFormat() {
        return Collections.emptyMap();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<LogstashLayout> {
        @PluginConfiguration
        private Configuration config;
        @PluginBuilderAttribute
        private boolean prettyPrintEnabled = false;
        @PluginBuilderAttribute
        private boolean locationInfoEnabled = false;
        @PluginBuilderAttribute
        private boolean stackTraceEnabled = false;
        @PluginBuilderAttribute
        private boolean emptyPropertyExclusionEnabled = true;
        @PluginBuilderAttribute
        private String dateTimeFormatPattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZ";
        @PluginBuilderAttribute
        private String timeZoneId = TimeZone.getDefault().getID();
        @PluginBuilderAttribute
        private String eventTemplate = null;
        @PluginBuilderAttribute
        private String eventTemplateUri = "classpath:LogstashJsonEventLayoutV1.json";
        @PluginBuilderAttribute
        private String stackTraceElementTemplate = null;
        @PluginBuilderAttribute
        private String stackTraceElementTemplateUri = "classpath:Log4j2StackTraceElementLayout.json";
        @PluginBuilderAttribute
        private String mdcKeyPattern;
        @PluginBuilderAttribute
        private String ndcPattern;
        @PluginBuilderAttribute
        private String lineSeparator = System.lineSeparator();
        @PluginBuilderAttribute
        private int maxByteCount = 524288;

        private Builder() {
        }

        public Configuration getConfiguration() {
            return this.config;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.config = configuration;
            return this;
        }

        public boolean isPrettyPrintEnabled() {
            return this.prettyPrintEnabled;
        }

        public Builder setPrettyPrintEnabled(boolean prettyPrintEnabled) {
            this.prettyPrintEnabled = prettyPrintEnabled;
            return this;
        }

        public boolean isLocationInfoEnabled() {
            return this.locationInfoEnabled;
        }

        public Builder setLocationInfoEnabled(boolean locationInfoEnabled) {
            this.locationInfoEnabled = locationInfoEnabled;
            return this;
        }

        public boolean isStackTraceEnabled() {
            return this.stackTraceEnabled;
        }

        public Builder setStackTraceEnabled(boolean stackTraceEnabled) {
            this.stackTraceEnabled = stackTraceEnabled;
            return this;
        }

        public boolean isEmptyPropertyExclusionEnabled() {
            return this.emptyPropertyExclusionEnabled;
        }

        public Builder setEmptyPropertyExclusionEnabled(boolean emptyPropertyExclusionEnabled) {
            this.emptyPropertyExclusionEnabled = emptyPropertyExclusionEnabled;
            return this;
        }

        public String getDateTimeFormatPattern() {
            return this.dateTimeFormatPattern;
        }

        public Builder setDateTimeFormatPattern(String dateTimeFormatPattern) {
            this.dateTimeFormatPattern = dateTimeFormatPattern;
            return this;
        }

        public String getTimeZoneId() {
            return this.timeZoneId;
        }

        public Builder setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public String getEventTemplate() {
            return this.eventTemplate;
        }

        public Builder setEventTemplate(String eventTemplate) {
            this.eventTemplate = eventTemplate;
            return this;
        }

        public String getEventTemplateUri() {
            return this.eventTemplateUri;
        }

        public Builder setEventTemplateUri(String eventTemplateUri) {
            this.eventTemplateUri = eventTemplateUri;
            return this;
        }

        public String getStackTraceElementTemplate() {
            return this.stackTraceElementTemplate;
        }

        public Builder setStackTraceElementTemplate(String stackTraceElementTemplate) {
            this.stackTraceElementTemplate = stackTraceElementTemplate;
            return this;
        }

        public String getStackTraceElementTemplateUri() {
            return this.stackTraceElementTemplateUri;
        }

        public Builder setStackTraceElementTemplateUri(String stackTraceElementTemplateUri) {
            this.stackTraceElementTemplateUri = stackTraceElementTemplateUri;
            return this;
        }

        public String getMdcKeyPattern() {
            return this.mdcKeyPattern;
        }

        public Builder setMdcKeyPattern(String mdcKeyPattern) {
            this.mdcKeyPattern = mdcKeyPattern;
            return this;
        }

        public String getNdcPattern() {
            return this.ndcPattern;
        }

        public Builder setNdcPattern(String ndcPattern) {
            this.ndcPattern = ndcPattern;
            return this;
        }

        public String getLineSeparator() {
            return this.lineSeparator;
        }

        public Builder setLineSeparator(String lineSeparator) {
            this.lineSeparator = lineSeparator;
            return this;
        }

        public int getMaxByteCount() {
            return this.maxByteCount;
        }

        public Builder setMaxByteCount(int maxByteCount) {
            this.maxByteCount = maxByteCount;
            return this;
        }

        public LogstashLayout build() {
            this.validate();
            return new LogstashLayout(this);
        }

        private void validate() {
            Validate.notNull((Object)this.config, (String)"config", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.dateTimeFormatPattern, (String)"dateTimeFormatPattern", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.timeZoneId, (String)"timeZoneId", (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.isBlank((CharSequence)this.eventTemplate) || !StringUtils.isBlank((CharSequence)this.eventTemplateUri) ? 1 : 0) != 0, (String)"both eventTemplate and eventTemplateUri are blank", (Object[])new Object[0]);
            if (this.stackTraceEnabled) {
                Validate.isTrue((!StringUtils.isBlank((CharSequence)this.stackTraceElementTemplate) || !StringUtils.isBlank((CharSequence)this.stackTraceElementTemplateUri) ? 1 : 0) != 0, (String)"both stackTraceElementTemplate and stackTraceElementTemplateUri are blank", (Object[])new Object[0]);
            }
            Validate.isTrue((this.maxByteCount > 0 ? 1 : 0) != 0, (String)"maxByteCount requires a non-zero positive integer", (Object[])new Object[0]);
        }

        public String toString() {
            String escapedLineSeparator = this.lineSeparator.replace("\\", "\\\\");
            return "Builder{prettyPrintEnabled=" + this.prettyPrintEnabled + ", locationInfoEnabled=" + this.locationInfoEnabled + ", stackTraceEnabled=" + this.stackTraceEnabled + ", emptyPropertyExclusionEnabled=" + this.emptyPropertyExclusionEnabled + ", dateTimeFormatPattern='" + this.dateTimeFormatPattern + '\'' + ", timeZoneId='" + this.timeZoneId + '\'' + ", eventTemplate='" + this.eventTemplate + '\'' + ", eventTemplateUri='" + this.eventTemplateUri + '\'' + ", mdcKeyPattern='" + this.mdcKeyPattern + '\'' + ", lineSeparator='" + escapedLineSeparator + '\'' + ", maxByteCount='" + this.maxByteCount + '\'' + '}';
        }
    }
}

