/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;

class SourceResolver
implements EventResolver {
    private static final EventResolver NULL_RESOLVER = new EventResolver(){

        @Override
        public void resolve(LogEvent value, JsonGenerator jsonGenerator) throws IOException {
            jsonGenerator.writeNull();
        }
    };
    private final EventResolver internalResolver;

    SourceResolver(EventResolverContext context, String key) {
        this.internalResolver = this.createInternalResolver(context, key);
    }

    private EventResolver createInternalResolver(EventResolverContext context, String key) {
        if (!context.isLocationInfoEnabled()) {
            return NULL_RESOLVER;
        }
        switch (key) {
            case "className": {
                return SourceResolver.createClassNameResolver(context);
            }
            case "fileName": {
                return SourceResolver.createFileNameResolver(context);
            }
            case "lineNumber": {
                return SourceResolver.createLineNumberResolver();
            }
            case "methodName": {
                return SourceResolver.createMethodNameResolver(context);
            }
        }
        throw new IllegalArgumentException("unknown key: " + key);
    }

    private static EventResolver createClassNameResolver(final EventResolverContext context) {
        return new EventResolver(){

            @Override
            public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
                StackTraceElement logEventSource = logEvent.getSource();
                if (logEventSource != null) {
                    boolean sourceClassNameExcluded;
                    String sourceClassName = logEventSource.getClassName();
                    boolean bl = sourceClassNameExcluded = context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)sourceClassName);
                    if (!sourceClassNameExcluded) {
                        jsonGenerator.writeString(sourceClassName);
                        return;
                    }
                }
                jsonGenerator.writeNull();
            }
        };
    }

    private static EventResolver createFileNameResolver(final EventResolverContext context) {
        return new EventResolver(){

            @Override
            public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
                StackTraceElement logEventSource = logEvent.getSource();
                if (logEventSource != null) {
                    boolean sourceFileNameExcluded;
                    String sourceFileName = logEventSource.getFileName();
                    boolean bl = sourceFileNameExcluded = context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)sourceFileName);
                    if (!sourceFileNameExcluded) {
                        jsonGenerator.writeString(sourceFileName);
                        return;
                    }
                }
                jsonGenerator.writeNull();
            }
        };
    }

    private static EventResolver createLineNumberResolver() {
        return new EventResolver(){

            @Override
            public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
                StackTraceElement logEventSource = logEvent.getSource();
                if (logEventSource == null) {
                    jsonGenerator.writeNull();
                } else {
                    int sourceLineNumber = logEventSource.getLineNumber();
                    jsonGenerator.writeNumber(sourceLineNumber);
                }
            }
        };
    }

    private static EventResolver createMethodNameResolver(final EventResolverContext context) {
        return new EventResolver(){

            @Override
            public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
                StackTraceElement logEventSource = logEvent.getSource();
                if (logEventSource != null) {
                    boolean sourceMethodNameExcluded;
                    String sourceMethodName = logEventSource.getMethodName();
                    boolean bl = sourceMethodNameExcluded = context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)sourceMethodName);
                    if (!sourceMethodNameExcluded) {
                        jsonGenerator.writeString(sourceMethodName);
                        return;
                    }
                }
                jsonGenerator.writeNull();
            }
        };
    }

    static String getName() {
        return "source";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        this.internalResolver.resolve(logEvent, jsonGenerator);
    }
}

