/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;

class ThreadResolver
implements EventResolver {
    private final EventResolver internalResolver;

    ThreadResolver(EventResolverContext context, String key) {
        this.internalResolver = ThreadResolver.createInternalResolver(context, key);
    }

    private static EventResolver createInternalResolver(EventResolverContext context, String key) {
        switch (key) {
            case "name": {
                return ThreadResolver.createNameResolver(context);
            }
            case "id": {
                return ThreadResolver.createIdResolver();
            }
            case "priority": {
                return ThreadResolver.createPriorityResolver();
            }
        }
        throw new IllegalArgumentException("unknown key: " + key);
    }

    private static EventResolver createNameResolver(final EventResolverContext context) {
        return new EventResolver(){

            @Override
            public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
                boolean threadNameExcluded;
                String threadName = logEvent.getThreadName();
                boolean bl = threadNameExcluded = context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)threadName);
                if (threadNameExcluded) {
                    jsonGenerator.writeNull();
                } else {
                    jsonGenerator.writeString(threadName);
                }
            }
        };
    }

    private static EventResolver createIdResolver() {
        return new EventResolver(){

            @Override
            public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
                long threadId = logEvent.getThreadId();
                jsonGenerator.writeNumber(threadId);
            }
        };
    }

    private static EventResolver createPriorityResolver() {
        return new EventResolver(){

            @Override
            public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
                int threadPriority = logEvent.getThreadPriority();
                jsonGenerator.writeNumber(threadPriority);
            }
        };
    }

    static String getName() {
        return "thread";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        this.internalResolver.resolve(logEvent, jsonGenerator);
    }
}

