/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.filter.FilteringGeneratorDelegate;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vlkan.log4j2.logstash.layout.LogstashLayoutSerializationContext;
import com.vlkan.log4j2.logstash.layout.util.ByteBufferOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.Supplier;

enum LogstashLayoutSerializationContexts {

    static boolean THREAD_LOCALS_ENABLED = Constants.ENABLE_THREADLOCALS;
    private static final SerializedString EMPTY_SERIALIZED_STRING = new SerializedString("");
    private static final PrettyPrinter PRETTY_PRINTER = new DefaultPrettyPrinter("");

    static Supplier<LogstashLayoutSerializationContext> createSupplier(ObjectMapper objectMapper, int maxByteCount, boolean prettyPrintEnabled, boolean emptyPropertyExclusionEnabled) {
        JsonFactory jsonFactory = new JsonFactory((ObjectCodec)objectMapper);
        boolean threadLocalEnabled = THREAD_LOCALS_ENABLED;
        return threadLocalEnabled ? LogstashLayoutSerializationContexts.createThreadLocalSupplier(jsonFactory, maxByteCount, prettyPrintEnabled, emptyPropertyExclusionEnabled) : LogstashLayoutSerializationContexts.createNewInstanceSupplier(jsonFactory, maxByteCount, prettyPrintEnabled, emptyPropertyExclusionEnabled);
    }

    private static Supplier<LogstashLayoutSerializationContext> createThreadLocalSupplier(JsonFactory jsonFactory, int maxByteCount, boolean prettyPrintEnabled, boolean emptyPropertyExclusionEnabled) {
        final Supplier<LogstashLayoutSerializationContext> jacksonResourceReleasingContextSupplier = LogstashLayoutSerializationContexts.createNewInstanceSupplier(jsonFactory, maxByteCount, prettyPrintEnabled, emptyPropertyExclusionEnabled);
        Supplier<LogstashLayoutSerializationContext> byteBufferClearingContextSupplier = new Supplier<LogstashLayoutSerializationContext>(){

            public LogstashLayoutSerializationContext get() {
                LogstashLayoutSerializationContext internalContext = (LogstashLayoutSerializationContext)jacksonResourceReleasingContextSupplier.get();
                final ByteBufferOutputStream outputStream = internalContext.getOutputStream();
                final ByteBuffer internalByteBuffer = outputStream.getByteBuffer();
                final JsonGenerator jsonGenerator = internalContext.getJsonGenerator();
                return new LogstashLayoutSerializationContext(){

                    @Override
                    public void close() {
                        internalByteBuffer.clear();
                    }

                    @Override
                    public ByteBufferOutputStream getOutputStream() {
                        return outputStream;
                    }

                    @Override
                    public JsonGenerator getJsonGenerator() {
                        return jsonGenerator;
                    }
                };
            }
        };
        final ThreadLocal<LogstashLayoutSerializationContext> contextRef = new ThreadLocal<LogstashLayoutSerializationContext>((Supplier)byteBufferClearingContextSupplier){
            final /* synthetic */ Supplier val$byteBufferClearingContextSupplier;
            {
                this.val$byteBufferClearingContextSupplier = supplier;
            }

            @Override
            protected LogstashLayoutSerializationContext initialValue() {
                return (LogstashLayoutSerializationContext)this.val$byteBufferClearingContextSupplier.get();
            }
        };
        return new Supplier<LogstashLayoutSerializationContext>(){

            public LogstashLayoutSerializationContext get() {
                return (LogstashLayoutSerializationContext)contextRef.get();
            }
        };
    }

    private static Supplier<LogstashLayoutSerializationContext> createNewInstanceSupplier(final JsonFactory jsonFactory, final int maxByteCount, final boolean prettyPrintEnabled, boolean emptyPropertyExclusionEnabled) {
        if (emptyPropertyExclusionEnabled) {
            return new Supplier<LogstashLayoutSerializationContext>(){

                public LogstashLayoutSerializationContext get() {
                    final ByteBufferOutputStream outputStream = new ByteBufferOutputStream(maxByteCount);
                    final JsonGenerator jsonGenerator = LogstashLayoutSerializationContexts.createJsonGenerator(jsonFactory, outputStream, prettyPrintEnabled);
                    final FilteringGeneratorDelegate jsonGeneratorDelegate = new FilteringGeneratorDelegate(jsonGenerator, (TokenFilter)NullExcludingTokenFilter.INSTANCE, true, true);
                    return new LogstashLayoutSerializationContext(){

                        @Override
                        public ByteBufferOutputStream getOutputStream() {
                            return outputStream;
                        }

                        @Override
                        public JsonGenerator getJsonGenerator() {
                            return jsonGeneratorDelegate;
                        }

                        @Override
                        public void close() throws Exception {
                            jsonGeneratorDelegate.close();
                            jsonGenerator.close();
                        }
                    };
                }
            };
        }
        return new Supplier<LogstashLayoutSerializationContext>(){

            public LogstashLayoutSerializationContext get() {
                final ByteBufferOutputStream outputStream = new ByteBufferOutputStream(maxByteCount);
                final JsonGenerator jsonGenerator = LogstashLayoutSerializationContexts.createJsonGenerator(jsonFactory, outputStream, prettyPrintEnabled);
                return new LogstashLayoutSerializationContext(){

                    @Override
                    public ByteBufferOutputStream getOutputStream() {
                        return outputStream;
                    }

                    @Override
                    public JsonGenerator getJsonGenerator() {
                        return jsonGenerator;
                    }

                    @Override
                    public void close() throws Exception {
                        jsonGenerator.close();
                    }
                };
            }
        };
    }

    private static JsonGenerator createJsonGenerator(JsonFactory jsonFactory, OutputStream outputStream, boolean prettyPrintEnabled) {
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator(outputStream);
            jsonGenerator.setRootValueSeparator((SerializableString)EMPTY_SERIALIZED_STRING);
            if (prettyPrintEnabled) {
                jsonGenerator.setPrettyPrinter(PRETTY_PRINTER);
            }
            return jsonGenerator;
        }
        catch (IOException error) {
            throw new RuntimeException("failed creating JsonGenerator", error);
        }
    }

    private static class NullExcludingTokenFilter
    extends TokenFilter {
        private static final NullExcludingTokenFilter INSTANCE = new NullExcludingTokenFilter();

        private NullExcludingTokenFilter() {
        }

        public boolean includeNull() {
            return false;
        }
    }
}

