/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;

class MessageResolver
implements EventResolver {
    private static final String NAME = "message";
    private static final String[] FORMATS = new String[]{"JSON"};
    private final EventResolverContext context;
    private final String key;

    MessageResolver(EventResolverContext context, String key) {
        this.context = context;
        this.key = key;
    }

    static String getName() {
        return NAME;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        Message message = logEvent.getMessage();
        if (FORMATS[0].equalsIgnoreCase(this.key)) {
            this.resolveJson(message, jsonGenerator);
        } else {
            this.resolveText(message, jsonGenerator);
        }
    }

    private void resolveText(Message message, JsonGenerator jsonGenerator) throws IOException {
        String formattedMessage = this.resolveText(message);
        if (formattedMessage == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(formattedMessage);
        }
    }

    private String resolveText(Message message) {
        String formattedMessage = message.getFormattedMessage();
        boolean messageExcluded = this.context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)formattedMessage);
        return messageExcluded ? null : formattedMessage;
    }

    private void resolveJson(Message message, JsonGenerator jsonGenerator) throws IOException {
        String[] formats;
        if (!(message instanceof MultiformatMessage)) {
            this.writeMessageObject(message, jsonGenerator);
            return;
        }
        MultiformatMessage multiformatMessage = (MultiformatMessage)message;
        boolean jsonSupported = false;
        for (String format : formats = multiformatMessage.getFormats()) {
            if (!FORMATS[0].equalsIgnoreCase(format)) continue;
            jsonSupported = true;
            break;
        }
        if (!jsonSupported) {
            this.writeMessageObject(message, jsonGenerator);
            return;
        }
        String messageJson = multiformatMessage.getFormattedMessage(FORMATS);
        JsonNode jsonNode = MessageResolver.readMessageJson(this.context, messageJson);
        boolean nodeExcluded = this.isNodeExcluded(jsonNode);
        if (nodeExcluded) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeTree((TreeNode)jsonNode);
        }
    }

    private static JsonNode readMessageJson(EventResolverContext context, String messageJson) {
        try {
            return context.getObjectMapper().readTree(messageJson);
        }
        catch (IOException error) {
            throw new RuntimeException("JSON message read failure", error);
        }
    }

    private void writeMessageObject(Message message, JsonGenerator jsonGenerator) throws IOException {
        String formattedMessage = this.resolveText(message);
        if (formattedMessage == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField(NAME, (Object)formattedMessage);
        jsonGenerator.writeEndObject();
    }

    private boolean isNodeExcluded(JsonNode jsonNode) {
        if (!this.context.isEmptyPropertyExclusionEnabled()) {
            return false;
        }
        if (jsonNode.isNull()) {
            return true;
        }
        if (jsonNode.isTextual() && StringUtils.isEmpty((CharSequence)jsonNode.asText())) {
            return true;
        }
        return jsonNode.isContainerNode() && jsonNode.size() == 0;
    }
}

