/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverContext;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;

public enum TemplateResolvers {

    private static final TemplateResolver<?> EMPTY_ARRAY_RESOLVER = (ignored, jsonGenerator) -> {
        jsonGenerator.writeStartArray();
        jsonGenerator.writeEndArray();
    };
    private static final TemplateResolver<?> EMPTY_OBJECT_RESOLVER = (ignored, jsonGenerator) -> {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeEndObject();
    };
    private static final TemplateResolver<?> NULL_NODE_RESOLVER = (ignored, jsonGenerator) -> jsonGenerator.writeNull();

    public static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofTemplate(C context, String template) {
        ObjectNode node;
        try {
            node = (ObjectNode)context.getObjectMapper().readValue(template, ObjectNode.class);
        }
        catch (IOException error) {
            String message = String.format("failed parsing template (template=%s)", template);
            throw new RuntimeException(message, error);
        }
        return TemplateResolvers.ofNode(context, (JsonNode)node);
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofNode(C context, JsonNode node) {
        JsonNodeType nodeType = node.getNodeType();
        switch (nodeType) {
            case ARRAY: {
                return TemplateResolvers.ofArrayNode(context, node);
            }
            case OBJECT: {
                return TemplateResolvers.ofObjectNode(context, node);
            }
            case STRING: {
                return TemplateResolvers.ofStringNode(context, node);
            }
        }
        return (ignored, jsonGenerator) -> jsonGenerator.writeTree((TreeNode)node);
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofArrayNode(C context, JsonNode arrayNode) {
        ArrayList itemResolvers = new ArrayList();
        for (int itemIndex = 0; itemIndex < arrayNode.size(); ++itemIndex) {
            JsonNode itemNode = arrayNode.get(itemIndex);
            TemplateResolver<V> itemResolver = TemplateResolvers.ofNode(context, itemNode);
            itemResolvers.add(itemResolver);
        }
        if (itemResolvers.isEmpty()) {
            TemplateResolver<?> emptyArrayResolver = EMPTY_ARRAY_RESOLVER;
            return emptyArrayResolver;
        }
        return (value, jsonGenerator) -> {
            jsonGenerator.writeStartArray();
            for (int itemResolverIndex = 0; itemResolverIndex < itemResolvers.size(); ++itemResolverIndex) {
                TemplateResolver itemResolver = (TemplateResolver)itemResolvers.get(itemResolverIndex);
                itemResolver.resolve(value, jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        };
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofObjectNode(C context, JsonNode srcNode) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList fieldResolvers = new ArrayList();
        Iterator srcNodeFieldIterator = srcNode.fields();
        while (srcNodeFieldIterator.hasNext()) {
            Map.Entry srcNodeField = (Map.Entry)srcNodeFieldIterator.next();
            String fieldName = (String)srcNodeField.getKey();
            JsonNode fieldValue = (JsonNode)srcNodeField.getValue();
            TemplateResolver<V> fieldResolver = TemplateResolvers.ofNode(context, fieldValue);
            fieldNames.add(fieldName);
            fieldResolvers.add(fieldResolver);
        }
        int fieldCount = fieldNames.size();
        if (fieldCount == 0) {
            TemplateResolver<?> emptyObjectResolver = EMPTY_OBJECT_RESOLVER;
            return emptyObjectResolver;
        }
        return (value, jsonGenerator) -> {
            jsonGenerator.writeStartObject();
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                String fieldName = (String)fieldNames.get(fieldIndex);
                TemplateResolver fieldResolver = (TemplateResolver)fieldResolvers.get(fieldIndex);
                jsonGenerator.writeFieldName(fieldName);
                fieldResolver.resolve(value, jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        };
    }

    private static <V, C extends TemplateResolverContext<V, C>> TemplateResolver<V> ofStringNode(C context, JsonNode textNode) {
        TemplateResolverFactory<V, C, TemplateResolver<V>> resolverFactory;
        String fieldValue = textNode.asText();
        if (context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)fieldValue)) {
            TemplateResolver<?> nullNodeResolver = NULL_NODE_RESOLVER;
            return nullNodeResolver;
        }
        TemplateResolverRequest resolverRequest = TemplateResolvers.readResolverRequest(fieldValue);
        if (resolverRequest != null && (resolverFactory = context.getResolverFactoryByName().get(resolverRequest.resolverName)) != null) {
            return resolverFactory.create(context, resolverRequest.resolverKey);
        }
        boolean substitutionNeeded = fieldValue.contains("${");
        if (substitutionNeeded) {
            if (EventResolverContext.class.isAssignableFrom(context.getContextClass())) {
                return (value, jsonGenerator) -> {
                    boolean replacedTextExcluded;
                    LogEvent logEvent = (LogEvent)value;
                    String replacedText = context.getSubstitutor().replace(logEvent, fieldValue);
                    boolean bl = replacedTextExcluded = context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)replacedText);
                    if (replacedTextExcluded) {
                        jsonGenerator.writeNull();
                    } else {
                        jsonGenerator.writeString(replacedText);
                    }
                };
            }
            return (value, jsonGenerator) -> {
                boolean replacedTextExcluded;
                String replacedText = context.getSubstitutor().replace(null, fieldValue);
                boolean bl = replacedTextExcluded = context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)replacedText);
                if (replacedTextExcluded) {
                    jsonGenerator.writeNull();
                } else {
                    jsonGenerator.writeString(replacedText);
                }
            };
        }
        return (value, jsonGenerator) -> jsonGenerator.writeString(fieldValue);
    }

    private static TemplateResolverRequest readResolverRequest(String fieldValue) {
        if (!fieldValue.startsWith("${json:") || !fieldValue.endsWith("}")) {
            return null;
        }
        int resolverNameStartIndex = 7;
        int fieldNameSeparatorIndex = fieldValue.indexOf(58, resolverNameStartIndex);
        if (fieldNameSeparatorIndex < 0) {
            int resolverNameEndIndex = fieldValue.length() - 1;
            String resolverName = fieldValue.substring(resolverNameStartIndex, resolverNameEndIndex);
            return new TemplateResolverRequest(resolverName, null);
        }
        int resolverNameEndIndex = fieldNameSeparatorIndex;
        int resolverKeyStartIndex = fieldNameSeparatorIndex + 1;
        int resolverKeyEndIndex = fieldValue.length() - 1;
        String resolverName = fieldValue.substring(resolverNameStartIndex, resolverNameEndIndex);
        String resolverKey = fieldValue.substring(resolverKeyStartIndex, resolverKeyEndIndex);
        return new TemplateResolverRequest(resolverName, resolverKey);
    }

    private static class TemplateResolverRequest {
        private final String resolverName;
        private final String resolverKey;

        private TemplateResolverRequest(String resolverName, String resolverKey) {
            this.resolverName = resolverName;
            this.resolverKey = resolverKey;
        }
    }
}

