/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.Validate;

public enum Uris {


    public static String readUri(String spec) {
        try {
            return Uris.unsafeReadUri(spec);
        }
        catch (Exception error) {
            String message = String.format("failed reading URI (spec=%s)", spec);
            throw new RuntimeException(message, error);
        }
    }

    private static String unsafeReadUri(String spec) throws Exception {
        String uriScheme;
        URI uri = new URI(spec);
        switch (uriScheme = uri.getScheme().toLowerCase()) {
            case "classpath": {
                return Uris.readClassPathUri(uri);
            }
            case "file": {
                return Uris.readFileUri(uri);
            }
        }
        String message = String.format("unknown URI scheme (spec='%s')", spec);
        throw new IllegalArgumentException(message);
    }

    private static String readFileUri(URI uri) throws IOException {
        File file = new File(uri);
        try (FileReader fileReader = new FileReader(file);){
            String string = Uris.consumeReader(fileReader);
            return string;
        }
    }

    private static String readClassPathUri(URI uri) throws IOException {
        String spec = uri.toString();
        String path = spec.substring("classpath:".length());
        URL resource = Uris.class.getClassLoader().getResource(path);
        Validate.notNull((Object)resource, (String)"could not locate classpath resource (path=%s)", (Object[])new Object[]{path});
        try (InputStream inputStream = resource.openStream();){
            String string;
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                string = Uris.consumeReader(reader);
            }
            return string;
        }
    }

    private static String consumeReader(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
        }
        return builder.toString();
    }
}

