/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vlkan.log4j2.logstash.layout.LogstashLayoutSerializationContext;
import com.vlkan.log4j2.logstash.layout.LogstashLayoutSerializationContexts;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Supplier;

class LogstashLayoutSerializationContextPool {
    private final Supplier<LogstashLayoutSerializationContext> contextSupplier;
    private final BlockingQueue<LogstashLayoutSerializationContext> contexts;

    LogstashLayoutSerializationContextPool(ObjectMapper objectMapper, int maxByteCount, boolean prettyPrintEnabled, boolean emptyPropertyExclusionEnabled, int maxStringLength, int maxPoolSize) {
        this.contextSupplier = LogstashLayoutSerializationContexts.createSupplier(objectMapper, maxByteCount, prettyPrintEnabled, emptyPropertyExclusionEnabled, maxStringLength);
        this.contexts = new ArrayBlockingQueue<LogstashLayoutSerializationContext>(maxPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogstashLayoutSerializationContext acquire() {
        LogstashLayoutSerializationContext context;
        LogstashLayoutSerializationContextPool logstashLayoutSerializationContextPool = this;
        synchronized (logstashLayoutSerializationContextPool) {
            context = (LogstashLayoutSerializationContext)this.contexts.poll();
        }
        if (context == null) {
            return this.contextSupplier.get();
        }
        context.reset();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(LogstashLayoutSerializationContext context) {
        LogstashLayoutSerializationContextPool logstashLayoutSerializationContextPool = this;
        synchronized (logstashLayoutSerializationContextPool) {
            this.contexts.offer(context);
        }
    }
}

