/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vlkan.log4j2.logstash.layout.LogstashLayoutSerializationContext;
import com.vlkan.log4j2.logstash.layout.LogstashLayoutSerializationContextPool;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import com.vlkan.log4j2.logstash.layout.resolver.StackTraceElementObjectResolverContext;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolvers;
import com.vlkan.log4j2.logstash.layout.util.AutoCloseables;
import com.vlkan.log4j2.logstash.layout.util.BufferedPrintWriterPool;
import com.vlkan.log4j2.logstash.layout.util.ByteBufferDestinations;
import com.vlkan.log4j2.logstash.layout.util.ByteBufferOutputStream;
import com.vlkan.log4j2.logstash.layout.util.Uris;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

@Plugin(name="LogstashLayout", category="Core", elementType="layout", printObject=true)
public class LogstashLayout
implements Layout<String> {
    static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String CONTENT_TYPE = "application/json; charset=" + CHARSET;
    private static final byte[] EMPTY_OBJECT_JSON_BYTES = "{}".getBytes(CHARSET);
    private final TemplateResolver<LogEvent> eventResolver;
    private final byte[] lineSeparatorBytes;
    private final LogstashLayoutSerializationContextPool serializationContextPool;

    private LogstashLayout(Builder builder) {
        ObjectMapper objectMapper = LogstashLayout.createObjectMapper(builder.objectMapperFactoryMethod);
        StrSubstitutor substitutor = builder.config.getStrSubstitutor();
        TemplateResolver<StackTraceElement> stackTraceElementObjectResolver = null;
        if (builder.stackTraceEnabled) {
            StackTraceElementObjectResolverContext stackTraceElementObjectResolverContext = StackTraceElementObjectResolverContext.newBuilder().setObjectMapper(objectMapper).setSubstitutor(substitutor).setEmptyPropertyExclusionEnabled(builder.emptyPropertyExclusionEnabled).build();
            String stackTraceElementTemplate = LogstashLayout.readStackTraceElementTemplate(builder);
            stackTraceElementObjectResolver = TemplateResolvers.ofTemplate(stackTraceElementObjectResolverContext, stackTraceElementTemplate);
        }
        String eventTemplate = LogstashLayout.readEventTemplate(builder);
        int writerCapacity = builder.maxStringLength > 0 ? builder.maxStringLength : builder.maxByteCount;
        BufferedPrintWriterPool writerPool = new BufferedPrintWriterPool(builder.maxWriterPoolSize, writerCapacity);
        FastDateFormat timestampFormat = LogstashLayout.readDateFormat(builder);
        EventResolverContext resolverContext = EventResolverContext.newBuilder().setObjectMapper(objectMapper).setSubstitutor(substitutor).setWriterPool(writerPool).setTimestampFormat(timestampFormat).setLocationInfoEnabled(builder.locationInfoEnabled).setStackTraceEnabled(builder.stackTraceEnabled).setStackTraceElementObjectResolver(stackTraceElementObjectResolver).setEmptyPropertyExclusionEnabled(builder.emptyPropertyExclusionEnabled).setMdcKeyPattern(builder.mdcKeyPattern).setNdcPattern(builder.ndcPattern).setAdditionalFields(builder.eventTemplateAdditionalFields.pairs).setMapMessageFormatterIgnored(builder.mapMessageFormatterIgnored).build();
        this.eventResolver = TemplateResolvers.ofTemplate(resolverContext, eventTemplate);
        this.lineSeparatorBytes = builder.lineSeparator.getBytes(CHARSET);
        this.serializationContextPool = new LogstashLayoutSerializationContextPool(objectMapper, builder.maxByteCount, builder.prettyPrintEnabled, builder.emptyPropertyExclusionEnabled, builder.maxStringLength, builder.maxSerializationContextPoolSize);
    }

    private static ObjectMapper createObjectMapper(String objectMapperFactoryMethod) {
        try {
            int splitterIndex = objectMapperFactoryMethod.lastIndexOf(46);
            String className = objectMapperFactoryMethod.substring(0, splitterIndex);
            String methodName = objectMapperFactoryMethod.substring(splitterIndex + 1);
            Class<?> clazz = Class.forName(className);
            if ("new".equals(methodName)) {
                return (ObjectMapper)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Method method = clazz.getMethod(methodName, new Class[0]);
            return (ObjectMapper)method.invoke(null, new Object[0]);
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    private static String readEventTemplate(Builder builder) {
        return LogstashLayout.readTemplate(builder.eventTemplate, builder.eventTemplateUri);
    }

    private static String readStackTraceElementTemplate(Builder builder) {
        return LogstashLayout.readTemplate(builder.stackTraceElementTemplate, builder.stackTraceElementTemplateUri);
    }

    private static String readTemplate(String template, String templateUri) {
        return StringUtils.isBlank((CharSequence)template) ? Uris.readUri(templateUri) : template;
    }

    private static FastDateFormat readDateFormat(Builder builder) {
        TimeZone timeZone = TimeZone.getTimeZone(builder.timeZoneId);
        return FastDateFormat.getInstance((String)builder.dateTimeFormatPattern, (TimeZone)timeZone);
    }

    LogstashLayoutSerializationContextPool getSerializationContextPool() {
        return this.serializationContextPool;
    }

    public String toSerializable(LogEvent event) {
        LogstashLayoutSerializationContext context = this.serializationContextPool.acquire();
        try {
            this.encode(event, context);
            String serializedEvent = context.getOutputStream().toString(CHARSET);
            this.serializationContextPool.release(context);
            return serializedEvent;
        }
        catch (Exception error) {
            AutoCloseables.closeUnchecked(context);
            throw new RuntimeException("failed serializing JSON", error);
        }
    }

    public byte[] toByteArray(LogEvent event) {
        LogstashLayoutSerializationContext context = this.serializationContextPool.acquire();
        try {
            this.encode(event, context);
            byte[] serializedEventBytes = context.getOutputStream().toByteArray();
            this.serializationContextPool.release(context);
            return serializedEventBytes;
        }
        catch (Exception error) {
            AutoCloseables.closeUnchecked(context);
            throw new RuntimeException("failed serializing JSON", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(LogEvent event, ByteBufferDestination destination) {
        LogstashLayoutSerializationContext context = this.serializationContextPool.acquire();
        try {
            this.encode(event, context);
            ByteBuffer byteBuffer = context.getOutputStream().getByteBuffer();
            ((Buffer)byteBuffer).flip();
            ByteBufferDestination byteBufferDestination = destination;
            synchronized (byteBufferDestination) {
                ByteBufferDestinations.writeToUnsynchronized(byteBuffer, destination);
            }
            this.serializationContextPool.release(context);
        }
        catch (Exception error) {
            AutoCloseables.closeUnchecked(context);
            throw new RuntimeException("failed serializing JSON", error);
        }
    }

    private void encode(LogEvent event, LogstashLayoutSerializationContext context) throws IOException {
        JsonGenerator jsonGenerator = context.getJsonGenerator();
        this.eventResolver.resolve(event, jsonGenerator);
        jsonGenerator.flush();
        ByteBufferOutputStream outputStream = context.getOutputStream();
        ByteBuffer byteBuffer = outputStream.getByteBuffer();
        if (byteBuffer.position() == 0) {
            outputStream.write(EMPTY_OBJECT_JSON_BYTES);
        }
        outputStream.write(this.lineSeparatorBytes);
    }

    public byte[] getFooter() {
        return null;
    }

    public byte[] getHeader() {
        return null;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Map<String, String> getContentFormat() {
        return Collections.emptyMap();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Plugin(name="EventTemplateAdditionalFields", category="Core", printObject=true)
    public static final class EventTemplateAdditionalFields {
        private static final EventTemplateAdditionalFields EMPTY = EventTemplateAdditionalFields.newBuilder().build();
        private final KeyValuePair[] pairs;

        private EventTemplateAdditionalFields(Builder builder) {
            this.pairs = builder.pairs;
        }

        public KeyValuePair[] getPairs() {
            return this.pairs;
        }

        @PluginBuilderFactory
        public static Builder newBuilder() {
            return new Builder();
        }

        static /* synthetic */ EventTemplateAdditionalFields access$2300() {
            return EMPTY;
        }

        public static class Builder
        implements org.apache.logging.log4j.core.util.Builder<EventTemplateAdditionalFields> {
            @PluginElement(value="EventTemplateAdditionalField")
            private KeyValuePair[] pairs;

            private Builder() {
            }

            public KeyValuePair[] getPairs() {
                return this.pairs;
            }

            public Builder setPairs(KeyValuePair[] pairs) {
                this.pairs = pairs;
                return this;
            }

            public EventTemplateAdditionalFields build() {
                return new EventTemplateAdditionalFields(this);
            }
        }
    }

    public static final class Builder
    implements org.apache.logging.log4j.core.util.Builder<LogstashLayout> {
        @PluginConfiguration
        private Configuration config;
        @PluginBuilderAttribute
        private boolean prettyPrintEnabled = false;
        @PluginBuilderAttribute
        private boolean locationInfoEnabled = false;
        @PluginBuilderAttribute
        private boolean stackTraceEnabled = false;
        @PluginBuilderAttribute
        private boolean emptyPropertyExclusionEnabled = true;
        @PluginBuilderAttribute
        private String dateTimeFormatPattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZ";
        @PluginBuilderAttribute
        private String timeZoneId = TimeZone.getDefault().getID();
        @PluginBuilderAttribute
        private String eventTemplate = null;
        @PluginBuilderAttribute
        private String eventTemplateUri = "classpath:LogstashJsonEventLayoutV1.json";
        @PluginElement(value="EventTemplateAdditionalFields")
        private EventTemplateAdditionalFields eventTemplateAdditionalFields = EventTemplateAdditionalFields.access$2300();
        @PluginBuilderAttribute
        private String stackTraceElementTemplate = null;
        @PluginBuilderAttribute
        private String stackTraceElementTemplateUri = "classpath:Log4j2StackTraceElementLayout.json";
        @PluginBuilderAttribute
        private String mdcKeyPattern;
        @PluginBuilderAttribute
        private String ndcPattern;
        @PluginBuilderAttribute
        private String lineSeparator = System.lineSeparator();
        @PluginBuilderAttribute
        private int maxByteCount = 524288;
        @PluginBuilderAttribute
        private int maxStringLength = 0;
        @PluginBuilderAttribute
        private int maxSerializationContextPoolSize = 50;
        @PluginBuilderAttribute
        private int maxWriterPoolSize = 50;
        @PluginBuilderAttribute
        private String objectMapperFactoryMethod = "com.fasterxml.jackson.databind.ObjectMapper.new";
        @PluginBuilderAttribute
        private boolean mapMessageFormatterIgnored = true;

        private Builder() {
        }

        public Configuration getConfiguration() {
            return this.config;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.config = configuration;
            return this;
        }

        public boolean isPrettyPrintEnabled() {
            return this.prettyPrintEnabled;
        }

        public Builder setPrettyPrintEnabled(boolean prettyPrintEnabled) {
            this.prettyPrintEnabled = prettyPrintEnabled;
            return this;
        }

        public boolean isLocationInfoEnabled() {
            return this.locationInfoEnabled;
        }

        public Builder setLocationInfoEnabled(boolean locationInfoEnabled) {
            this.locationInfoEnabled = locationInfoEnabled;
            return this;
        }

        public boolean isStackTraceEnabled() {
            return this.stackTraceEnabled;
        }

        public Builder setStackTraceEnabled(boolean stackTraceEnabled) {
            this.stackTraceEnabled = stackTraceEnabled;
            return this;
        }

        public boolean isEmptyPropertyExclusionEnabled() {
            return this.emptyPropertyExclusionEnabled;
        }

        public Builder setEmptyPropertyExclusionEnabled(boolean emptyPropertyExclusionEnabled) {
            this.emptyPropertyExclusionEnabled = emptyPropertyExclusionEnabled;
            return this;
        }

        public String getDateTimeFormatPattern() {
            return this.dateTimeFormatPattern;
        }

        public Builder setDateTimeFormatPattern(String dateTimeFormatPattern) {
            this.dateTimeFormatPattern = dateTimeFormatPattern;
            return this;
        }

        public String getTimeZoneId() {
            return this.timeZoneId;
        }

        public Builder setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public String getEventTemplate() {
            return this.eventTemplate;
        }

        public Builder setEventTemplate(String eventTemplate) {
            this.eventTemplate = eventTemplate;
            return this;
        }

        public String getEventTemplateUri() {
            return this.eventTemplateUri;
        }

        public Builder setEventTemplateUri(String eventTemplateUri) {
            this.eventTemplateUri = eventTemplateUri;
            return this;
        }

        public EventTemplateAdditionalFields getEventTemplateAdditionalFields() {
            return this.eventTemplateAdditionalFields;
        }

        public Builder setEventTemplateAdditionalFields(EventTemplateAdditionalFields eventTemplateAdditionalFields) {
            this.eventTemplateAdditionalFields = eventTemplateAdditionalFields;
            return this;
        }

        public String getStackTraceElementTemplate() {
            return this.stackTraceElementTemplate;
        }

        public Builder setStackTraceElementTemplate(String stackTraceElementTemplate) {
            this.stackTraceElementTemplate = stackTraceElementTemplate;
            return this;
        }

        public String getStackTraceElementTemplateUri() {
            return this.stackTraceElementTemplateUri;
        }

        public Builder setStackTraceElementTemplateUri(String stackTraceElementTemplateUri) {
            this.stackTraceElementTemplateUri = stackTraceElementTemplateUri;
            return this;
        }

        public String getMdcKeyPattern() {
            return this.mdcKeyPattern;
        }

        public Builder setMdcKeyPattern(String mdcKeyPattern) {
            this.mdcKeyPattern = mdcKeyPattern;
            return this;
        }

        public String getNdcPattern() {
            return this.ndcPattern;
        }

        public Builder setNdcPattern(String ndcPattern) {
            this.ndcPattern = ndcPattern;
            return this;
        }

        public String getLineSeparator() {
            return this.lineSeparator;
        }

        public Builder setLineSeparator(String lineSeparator) {
            this.lineSeparator = lineSeparator;
            return this;
        }

        public int getMaxByteCount() {
            return this.maxByteCount;
        }

        public Builder setMaxByteCount(int maxByteCount) {
            this.maxByteCount = maxByteCount;
            return this;
        }

        public int getMaxStringLength() {
            return this.maxStringLength;
        }

        public Builder setMaxStringLength(int maxStringLength) {
            this.maxStringLength = maxStringLength;
            return this;
        }

        public int getMaxSerializationContextPoolSize() {
            return this.maxSerializationContextPoolSize;
        }

        public Builder setMaxSerializationContextPoolSize(int maxSerializationContextPoolSize) {
            this.maxSerializationContextPoolSize = maxSerializationContextPoolSize;
            return this;
        }

        public int getMaxWriterPoolSize() {
            return this.maxWriterPoolSize;
        }

        public Builder setMaxWriterPoolSize(int maxWriterPoolSize) {
            this.maxWriterPoolSize = maxWriterPoolSize;
            return this;
        }

        public String getObjectMapperFactoryMethod() {
            return this.objectMapperFactoryMethod;
        }

        public Builder setObjectMapperFactoryMethod(String objectMapperFactoryMethod) {
            this.objectMapperFactoryMethod = objectMapperFactoryMethod;
            return this;
        }

        public boolean isMapMessageFormatterIgnored() {
            return this.mapMessageFormatterIgnored;
        }

        public Builder setMapMessageFormatterIgnored(boolean mapMessageFormatterIgnored) {
            this.mapMessageFormatterIgnored = mapMessageFormatterIgnored;
            return this;
        }

        public LogstashLayout build() {
            this.validate();
            return new LogstashLayout(this);
        }

        private void validate() {
            Validate.notNull((Object)this.config, (String)"config", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.dateTimeFormatPattern, (String)"dateTimeFormatPattern", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)this.timeZoneId, (String)"timeZoneId", (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.isBlank((CharSequence)this.eventTemplate) || !StringUtils.isBlank((CharSequence)this.eventTemplateUri) ? 1 : 0) != 0, (String)"both eventTemplate and eventTemplateUri are blank", (Object[])new Object[0]);
            Validate.notNull((Object)this.eventTemplateAdditionalFields, (String)"eventTemplateAdditionalFields", (Object[])new Object[0]);
            if (this.stackTraceEnabled) {
                Validate.isTrue((!StringUtils.isBlank((CharSequence)this.stackTraceElementTemplate) || !StringUtils.isBlank((CharSequence)this.stackTraceElementTemplateUri) ? 1 : 0) != 0, (String)"both stackTraceElementTemplate and stackTraceElementTemplateUri are blank", (Object[])new Object[0]);
            }
            Validate.isTrue((this.maxByteCount > 0 ? 1 : 0) != 0, (String)"maxByteCount requires a non-zero positive integer", (Object[])new Object[0]);
            Validate.isTrue((this.maxStringLength >= 0 ? 1 : 0) != 0, (String)"maxStringLength requires a positive integer", (Object[])new Object[0]);
            Validate.isTrue((this.maxSerializationContextPoolSize > 0 ? 1 : 0) != 0, (String)"maxSerializationContextPoolSize requires a non-zero positive integer", (Object[])new Object[0]);
            Validate.isTrue((this.maxWriterPoolSize > 0 ? 1 : 0) != 0, (String)"maxWriterPoolSize requires a non-zero positive integer", (Object[])new Object[0]);
            Validate.notNull((Object)this.objectMapperFactoryMethod, (String)"objectMapperFactoryMethod", (Object[])new Object[0]);
        }
    }
}

