/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.util;

import com.vlkan.log4j2.logstash.layout.util.BufferedPrintWriter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class BufferedPrintWriterPool {
    private final BlockingQueue<BufferedPrintWriter> writers;
    private final int writerCapacity;

    public BufferedPrintWriterPool(int poolSize, int writerCapacity) {
        this.writers = new ArrayBlockingQueue<BufferedPrintWriter>(poolSize);
        this.writerCapacity = writerCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedPrintWriter acquire() {
        BufferedPrintWriter writer;
        BufferedPrintWriterPool bufferedPrintWriterPool = this;
        synchronized (bufferedPrintWriterPool) {
            writer = (BufferedPrintWriter)this.writers.poll();
        }
        if (writer != null) {
            writer.close();
            return writer;
        }
        return BufferedPrintWriter.ofCapacity(this.writerCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(BufferedPrintWriter writer) {
        BufferedPrintWriterPool bufferedPrintWriterPool = this;
        synchronized (bufferedPrintWriterPool) {
            this.writers.offer(writer);
        }
    }
}

