/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.message.MapMessage;

class MapResolver
implements EventResolver {
    private static final MapLookup MAP_LOOKUP = new MapLookup();
    private final EventResolverContext context;
    private final String key;

    static String getName() {
        return "map";
    }

    MapResolver(EventResolverContext context, String key) {
        this.context = context;
        this.key = key;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        if (!(logEvent.getMessage() instanceof MapMessage)) {
            jsonGenerator.writeNull();
        } else {
            boolean valueExcluded;
            String resolvedValue = MAP_LOOKUP.lookup(logEvent, this.key);
            boolean bl = valueExcluded = this.context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)resolvedValue);
            if (valueExcluded) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeObject((Object)resolvedValue);
            }
        }
    }
}

