/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import java.io.IOException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

class TimestampResolver
implements EventResolver {
    private static final EventResolver MILLIS_RESOLVER = (logEvent, jsonGenerator) -> {
        long timeMillis = logEvent.getTimeMillis();
        jsonGenerator.writeNumber(timeMillis);
    };
    private static final EventResolver NANOS_RESOLVER = (logEvent, jsonGenerator) -> {
        long nanoTime = logEvent.getNanoTime();
        jsonGenerator.writeNumber(nanoTime);
    };
    private final EventResolver internalResolver;

    TimestampResolver(EventResolverContext context, String key) {
        this.internalResolver = TimestampResolver.createInternalResolver(context, key);
    }

    private static EventResolver createInternalResolver(EventResolverContext context, String key) {
        if (key == null) {
            return TimestampResolver.createFormatResolver(context);
        }
        switch (key) {
            case "millis": {
                return MILLIS_RESOLVER;
            }
            case "nanos": {
                return NANOS_RESOLVER;
            }
        }
        throw new IllegalArgumentException("unknown key: " + key);
    }

    private static EventResolver createFormatResolver(final EventResolverContext context) {
        return new EventResolver(){
            private volatile long lastTimestampMillis = -1L;
            private volatile String lastTimestamp;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
                String timestamp;
                long timestampMillis = logEvent.getTimeMillis();
                1 var6_4 = this;
                synchronized (var6_4) {
                    if (this.lastTimestampMillis != timestampMillis) {
                        this.lastTimestampMillis = timestampMillis;
                        FastDateFormat timestampFormat = context.getTimestampFormat();
                        timestamp = this.lastTimestamp = timestampFormat.format(timestampMillis);
                    } else {
                        timestamp = this.lastTimestamp;
                    }
                }
                jsonGenerator.writeString(timestamp);
            }
        };
    }

    static String getName() {
        return "timestamp";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        this.internalResolver.resolve(logEvent, jsonGenerator);
    }
}

