/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolver;
import com.vlkan.log4j2.logstash.layout.resolver.TemplateResolverContext;
import java.util.regex.Pattern;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;

public class ContextStackResolver
implements TemplateResolver {
    private static final ContextStackResolver INSTANCE = new ContextStackResolver();

    private ContextStackResolver() {
    }

    public static ContextStackResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "ndc";
    }

    @Override
    public JsonNode resolve(TemplateResolverContext context, LogEvent logEvent) {
        ThreadContext.ContextStack contextStack = logEvent.getContextStack();
        if (contextStack.getDepth() == 0) {
            return null;
        }
        Pattern itemPattern = context.getNdcPattern();
        ArrayNode contextStackNode = context.getObjectMapper().createArrayNode();
        for (String contextStackItem : contextStack.asList()) {
            boolean matches = itemPattern == null || itemPattern.matcher(contextStackItem).matches();
            if (!matches) continue;
            contextStackNode.add(contextStackItem);
        }
        return contextStackNode;
    }
}

