/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.util;

import java.io.Writer;

public final class BufferedWriter
extends Writer {
    private final char[] buffer;
    private int position;
    private boolean overflow;

    BufferedWriter(int capacity) {
        this.buffer = new char[capacity];
        this.position = 0;
        this.overflow = false;
    }

    char[] getBuffer() {
        return this.buffer;
    }

    int getPosition() {
        return this.position;
    }

    int getCapacity() {
        return this.buffer.length;
    }

    boolean isOverflow() {
        return this.overflow;
    }

    @Override
    public void write(char[] source, int offset, int length) {
        if (!this.overflow) {
            int limit = this.buffer.length - this.position;
            if (length > limit) {
                this.overflow = true;
                System.arraycopy(source, offset, this.buffer, this.position, limit);
                this.position = this.buffer.length;
            } else {
                System.arraycopy(source, offset, this.buffer, this.position, length);
                this.position += length;
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.position = 0;
        this.overflow = false;
    }
}

