/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.util;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.logging.log4j.core.util.Constants;

public enum JsonGenerators {

    private static final ThreadLocal<DoubleWriterContext> DOUBLE_WRITER_CONTEXT_REF = Constants.ENABLE_THREADLOCALS ? ThreadLocal.withInitial(() -> new DoubleWriterContext()) : null;

    public static void writeDouble(JsonGenerator jsonGenerator, long integralPart, int fractionalPart) throws IOException {
        if (fractionalPart < 0) {
            throw new IllegalArgumentException("negative fraction");
        }
        if (fractionalPart == 0) {
            jsonGenerator.writeNumber(integralPart);
        } else if (Constants.ENABLE_THREADLOCALS) {
            DoubleWriterContext context = DOUBLE_WRITER_CONTEXT_REF.get();
            context.builder.setLength(0);
            context.builder.append(integralPart);
            context.builder.append('.');
            context.builder.append(fractionalPart);
            int length = context.builder.length();
            context.builder.getChars(0, length, context.buffer, 0);
            jsonGenerator.writeRawValue(context.buffer, 0, length);
        } else {
            String formattedNumber = "" + integralPart + '.' + fractionalPart;
            jsonGenerator.writeNumber(formattedNumber);
        }
    }

    public static void writeObject(JsonGenerator jsonGenerator, Object object) throws IOException {
        if (object == null) {
            jsonGenerator.writeNull();
            return;
        }
        if (object instanceof String) {
            jsonGenerator.writeString((String)object);
            return;
        }
        if (object instanceof Short) {
            jsonGenerator.writeNumber(((Short)object).shortValue());
            return;
        }
        if (object instanceof Integer) {
            jsonGenerator.writeNumber(((Integer)object).intValue());
            return;
        }
        if (object instanceof Long) {
            jsonGenerator.writeNumber(((Long)object).longValue());
            return;
        }
        if (object instanceof BigDecimal) {
            jsonGenerator.writeNumber((BigDecimal)object);
            return;
        }
        if (object instanceof Float) {
            jsonGenerator.writeNumber(((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            jsonGenerator.writeNumber(((Double)object).doubleValue());
            return;
        }
        if (object instanceof byte[]) {
            jsonGenerator.writeBinary((byte[])object);
            return;
        }
        jsonGenerator.writeObject(object);
    }

    private static final class DoubleWriterContext {
        private static final int MAX_BUFFER_LENGTH = String.format("%d.%d", Long.MAX_VALUE, Integer.MAX_VALUE).length() + 1;
        private final StringBuilder builder = new StringBuilder();
        private char[] buffer = new char[MAX_BUFFER_LENGTH];

        private DoubleWriterContext() {
        }
    }
}

