/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolverContext;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;

class LoggerResolver
implements EventResolver {
    private final EventResolver internalResolver;

    LoggerResolver(EventResolverContext context, String key) {
        this.internalResolver = LoggerResolver.createInternalResolver(context, key);
    }

    private static EventResolver createInternalResolver(EventResolverContext context, String key) {
        switch (key) {
            case "name": {
                return LoggerResolver.createNameResolver(context);
            }
            case "fqcn": {
                return LoggerResolver.createFqcnResolver(context);
            }
        }
        throw new IllegalArgumentException("unknown key: " + key);
    }

    private static EventResolver createNameResolver(EventResolverContext context) {
        return (logEvent, jsonGenerator) -> {
            String loggerName = logEvent.getLoggerName();
            LoggerResolver.writeText(jsonGenerator, context, loggerName);
        };
    }

    private static EventResolver createFqcnResolver(EventResolverContext context) {
        return (logEvent, jsonGenerator) -> {
            String loggerFqcn = logEvent.getLoggerFqcn();
            LoggerResolver.writeText(jsonGenerator, context, loggerFqcn);
        };
    }

    private static void writeText(JsonGenerator jsonGenerator, EventResolverContext context, String text) throws IOException {
        boolean textExcluded;
        boolean bl = textExcluded = context.isEmptyPropertyExclusionEnabled() && StringUtils.isEmpty((CharSequence)text);
        if (textExcluded) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(text);
        }
    }

    static String getName() {
        return "logger";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        this.internalResolver.resolve(logEvent, jsonGenerator);
    }
}

