/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.EventResolver;
import java.io.IOException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;

class MapResolver
implements EventResolver {
    private final String key;

    static String getName() {
        return "map";
    }

    MapResolver(String key) {
        this.key = key;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonGenerator jsonGenerator) throws IOException {
        if (!(logEvent.getMessage() instanceof MapMessage)) {
            jsonGenerator.writeNull();
        } else {
            MapMessage message = (MapMessage)logEvent.getMessage();
            IndexedReadOnlyStringMap map = message.getIndexedReadOnlyStringMap();
            Object value = map.getValue(this.key);
            jsonGenerator.writeObject(value);
        }
    }
}

