/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.logstash.layout.resolver;

import com.fasterxml.jackson.core.JsonGenerator;
import com.vlkan.log4j2.logstash.layout.resolver.StackTraceResolver;
import com.vlkan.log4j2.logstash.layout.util.BufferedPrintWriter;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.logging.log4j.util.Constants;

class StackTraceTextResolver
implements StackTraceResolver {
    private final Supplier<BufferedPrintWriter> writerSupplier = () -> BufferedPrintWriter.ofCapacity(writerCapacity);
    private final ThreadLocal<BufferedPrintWriter> writerRef = Constants.ENABLE_THREADLOCALS ? ThreadLocal.withInitial(this.writerSupplier) : null;

    StackTraceTextResolver(int writerCapacity) {
    }

    @Override
    public void resolve(Throwable throwable, JsonGenerator jsonGenerator) throws IOException {
        BufferedPrintWriter writer = this.getResetWriter();
        Throwable lastThrowable = throwable;
        while (true) {
            try {
                lastThrowable.printStackTrace(writer);
            }
            catch (Throwable newThrowable) {
                writer.close();
                lastThrowable = newThrowable;
                continue;
            }
            break;
        }
        jsonGenerator.writeString(writer.getBuffer(), 0, writer.getPosition());
    }

    private BufferedPrintWriter getResetWriter() {
        BufferedPrintWriter writer;
        if (Constants.ENABLE_THREADLOCALS) {
            writer = this.writerRef.get();
            writer.close();
        } else {
            writer = this.writerSupplier.get();
        }
        return writer;
    }
}

