/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.redis.appender;

import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

class DebugLogger {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private final Class<?> parentClass;
    private final String parentClassName;
    private volatile boolean enabled;

    DebugLogger(Class<?> parentClass) {
        this(parentClass, true);
    }

    DebugLogger(Class<?> parentClass, boolean enabled) {
        this.parentClass = parentClass;
        this.parentClassName = parentClass.getSimpleName();
        this.enabled = enabled;
    }

    public void debug(String message, Object ... messageArguments) {
        if (this.enabled) {
            String timestamp = DATE_FORMAT.format(System.currentTimeMillis());
            String threadName = Thread.currentThread().getName();
            String prefix = String.format("%s %s [%s] DEBUG", timestamp, threadName, this.parentClassName);
            String formattedMessage = String.format(prefix + ' ' + message, messageArguments);
            System.err.println(formattedMessage);
        }
    }

    public Class<?> getParentClass() {
        return this.parentClass;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return String.format("DebugLogger{parentClass=%s, enabled=%s}", this.parentClass, this.enabled);
    }
}

