/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.redis.appender;

import com.vlkan.log4j2.redis.appender.DebugLogger;
import com.vlkan.log4j2.redis.appender.Helpers;
import com.vlkan.log4j2.redis.appender.RedisConnectionPoolConfig;
import com.vlkan.log4j2.redis.appender.RedisThrottler;
import com.vlkan.log4j2.redis.appender.RedisThrottlerConfig;
import com.vlkan.log4j2.redis.appender.RedisThrottlerJmxBean;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.DefaultErrorHandler;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.util.Strings;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Plugin(name="RedisAppender", category="Core", elementType="appender", printObject=true)
public class RedisAppender
implements Appender {
    private final Configuration config;
    private final String name;
    private final Layout<? extends Serializable> layout;
    private final String key;
    private final byte[] keyBytes;
    private final String host;
    private final int port;
    private final String password;
    private final int connectionTimeoutSeconds;
    private final int socketTimeoutSeconds;
    private final boolean ignoreExceptions;
    private final boolean debugEnabled;
    private final RedisConnectionPoolConfig poolConfig;
    private final DebugLogger logger;
    private final RedisThrottler throttler;
    private volatile JedisPool jedisPool;
    private volatile LifeCycle.State state;
    private volatile ErrorHandler errorHandler = new DefaultErrorHandler((Appender)this);

    private RedisAppender(Builder builder) {
        this.config = builder.config;
        this.name = builder.name;
        this.layout = builder.layout;
        this.key = builder.key;
        this.keyBytes = builder.key.getBytes(builder.charset);
        this.host = builder.host;
        this.port = builder.port;
        this.password = builder.password;
        this.connectionTimeoutSeconds = builder.connectionTimeoutSeconds;
        this.socketTimeoutSeconds = builder.socketTimeoutSeconds;
        this.ignoreExceptions = builder.ignoreExceptions;
        this.debugEnabled = builder.debugEnabled;
        this.poolConfig = builder.poolConfig;
        this.logger = new DebugLogger(RedisAppender.class, this.debugEnabled);
        this.throttler = new RedisThrottler(builder.getThrottlerConfig(), this, this.ignoreExceptions, this.debugEnabled);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public Layout<? extends Serializable> getLayout() {
        return this.layout;
    }

    public boolean ignoreExceptions() {
        return this.ignoreExceptions;
    }

    public ErrorHandler getHandler() {
        return this.errorHandler;
    }

    public void setHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public LifeCycle.State getState() {
        return this.state;
    }

    void consumeThrottledEvents(byte[] ... events) {
        this.logger.debug("consuming %d events", events.length);
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.rpush(this.keyBytes, events);
        }
    }

    public RedisThrottlerJmxBean getJmxBean() {
        return this.throttler.getJmxBean();
    }

    public void append(LogEvent event) {
        this.logger.debug("appending: %s", event.getMessage().getFormattedMessage());
        if (LifeCycle.State.STARTED.equals((Object)this.state)) {
            byte[] eventBytes = this.layout.toByteArray(event);
            this.throttler.push(eventBytes);
        }
    }

    public void initialize() {
        this.changeState(null, LifeCycle.State.INITIALIZING, LifeCycle.State.INITIALIZED, new Runnable(){

            @Override
            public void run() {
                RedisAppender.this.throttler.start();
            }
        });
    }

    public void start() {
        this.logger.debug("starting", new Object[0]);
        this.ensureInitialized();
        this.changeState(LifeCycle.State.INITIALIZED, LifeCycle.State.STARTING, LifeCycle.State.STARTED, new Runnable(){

            @Override
            public void run() {
                RedisAppender.this.connect();
            }
        });
    }

    private synchronized void ensureInitialized() {
        if (this.state == null) {
            this.initialize();
        }
    }

    private synchronized void changeState(LifeCycle.State initialState, LifeCycle.State transitionState, LifeCycle.State finalState, Runnable body) {
        this.logger.debug("expecting state: %s", initialState);
        if (initialState != this.state) {
            String message = String.format("expecting: %s, found: %s", initialState, this.state);
            this.errorHandler.error(message);
            throw new IllegalStateException(message);
        }
        this.logger.debug("transitioning state: %s", transitionState);
        this.state = transitionState;
        try {
            if (body != null) {
                body.run();
            }
            this.logger.debug("finalizing state: %s", finalState);
            this.state = finalState;
        }
        catch (Exception error) {
            String message = String.format("state change failure (initialState=%s, transitionState=%s, finalState=%s)", initialState, transitionState, finalState);
            if (this.debugEnabled) {
                this.logger.debug("%s: %s", message, error.getMessage());
                error.printStackTrace();
            }
            this.errorHandler.error(message, (Throwable)error);
            throw new RuntimeException(message, error);
        }
    }

    public synchronized void stop() {
        this.logger.debug("stopping", new Object[0]);
        this.state = LifeCycle.State.STOPPING;
        this.throttler.close();
        if (this.jedisPool != null && !this.jedisPool.isClosed()) {
            this.disconnect();
        }
        this.state = LifeCycle.State.STOPPED;
    }

    private void connect() {
        this.logger.debug("connecting", new Object[0]);
        int connectionTimeoutMillis = 1000 * this.connectionTimeoutSeconds;
        int socketTimeoutMillis = 1000 * this.socketTimeoutSeconds;
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)this.poolConfig.getJedisPoolConfig(), this.host, this.port, connectionTimeoutMillis, socketTimeoutMillis, this.password, 0, null, false, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        this.logger.debug("disconnecting", new Object[0]);
        try {
            this.jedisPool.destroy();
        }
        catch (JedisConnectionException error) {
            this.logger.debug("disconnect failure: %s", error.getMessage());
        }
        finally {
            this.jedisPool = null;
        }
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public String toString() {
        return "RedisAppender{state=" + this.state + ", name='" + this.name + '\'' + ", layout='" + this.layout + '\'' + ", key='" + this.key + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", connectionTimeoutSeconds=" + this.connectionTimeoutSeconds + ", socketTimeoutSeconds=" + this.socketTimeoutSeconds + ", ignoreExceptions=" + this.ignoreExceptions + '}';
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<RedisAppender> {
        @PluginConfiguration
        private Configuration config;
        @PluginBuilderAttribute
        @Required(message="missing name")
        private String name;
        @PluginBuilderAttribute
        private Charset charset = Charset.forName("UTF-8");
        @PluginElement(value="Layout")
        private Layout<? extends Serializable> layout = PatternLayout.newBuilder().withCharset(this.charset).build();
        @PluginBuilderAttribute
        @Required(message="missing key")
        private String key;
        @PluginBuilderAttribute
        private String host = "localhost";
        @PluginBuilderAttribute
        private String password = null;
        @PluginBuilderAttribute
        private int port = 6379;
        @PluginBuilderAttribute
        private int connectionTimeoutSeconds = 2000;
        @PluginBuilderAttribute
        private int socketTimeoutSeconds = 2000;
        @PluginBuilderAttribute
        private boolean ignoreExceptions = true;
        @PluginBuilderAttribute
        private boolean debugEnabled = false;
        @PluginElement(value="RedisConnectionPoolConfig")
        private RedisConnectionPoolConfig poolConfig = RedisConnectionPoolConfig.newBuilder().build();
        @PluginElement(value="RedisThrottlerConfig")
        private RedisThrottlerConfig throttlerConfig = RedisThrottlerConfig.newBuilder().build();

        private Builder() {
        }

        public Configuration getConfig() {
            return this.config;
        }

        public Builder setConfig(Configuration config) {
            this.config = config;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Layout<? extends Serializable> getLayout() {
            return this.layout;
        }

        public Builder setLayout(Layout<LogEvent> layout) {
            this.layout = layout;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public int getConnectionTimeoutSeconds() {
            return this.connectionTimeoutSeconds;
        }

        public Builder setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
            this.connectionTimeoutSeconds = connectionTimeoutSeconds;
            return this;
        }

        public int getSocketTimeoutSeconds() {
            return this.socketTimeoutSeconds;
        }

        public Builder setSocketTimeoutSeconds(int socketTimeoutSeconds) {
            this.socketTimeoutSeconds = socketTimeoutSeconds;
            return this;
        }

        public boolean isIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public Builder setIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public RedisConnectionPoolConfig getPoolConfig() {
            return this.poolConfig;
        }

        public Builder setPoolConfig(RedisConnectionPoolConfig poolConfig) {
            this.poolConfig = poolConfig;
            return this;
        }

        public RedisThrottlerConfig getThrottlerConfig() {
            return this.throttlerConfig;
        }

        public Builder setThrottlerConfig(RedisThrottlerConfig throttlerConfig) {
            this.throttlerConfig = throttlerConfig;
            return this;
        }

        public RedisAppender build() {
            this.check();
            return new RedisAppender(this);
        }

        private void check() {
            Objects.requireNonNull(this.config, "config");
            Helpers.requireArgument(Strings.isNotBlank((String)this.name), "blank name", new Object[0]);
            Objects.requireNonNull(this.charset, "charset");
            Objects.requireNonNull(this.layout, "layout");
            Helpers.requireArgument(Strings.isNotBlank((String)this.key), "blank key", new Object[0]);
            Helpers.requireArgument(Strings.isNotBlank((String)this.host), "blank host", new Object[0]);
            Helpers.requireArgument(this.port > 0, "expecting: port > 0, found: %d", this.port);
            Helpers.requireArgument(this.connectionTimeoutSeconds > 0, "expecting: connectionTimeoutSeconds > 0, found: %d", this.connectionTimeoutSeconds);
            Helpers.requireArgument(this.socketTimeoutSeconds > 0, "expecting: socketTimeoutSeconds > 0, found: %d", this.socketTimeoutSeconds);
            Objects.requireNonNull(this.poolConfig, "poolConfig");
            Objects.requireNonNull(this.throttlerConfig, "throttlerConfig");
        }

        public String toString() {
            return "Builder{name='" + this.name + '\'' + ", charset=" + this.charset + ", layout='" + this.layout + '\'' + ", key='" + this.key + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", connectionTimeoutSeconds=" + this.connectionTimeoutSeconds + ", socketTimeoutSeconds=" + this.socketTimeoutSeconds + ", ignoreExceptions=" + this.ignoreExceptions + ", debugEnabled=" + this.debugEnabled + '}';
        }
    }
}

