/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.redis.appender;

import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import redis.clients.jedis.JedisPoolConfig;

@Plugin(name="RedisConnectionPoolConfig", category="Core", printObject=true)
public class RedisConnectionPoolConfig {
    private final int maxTotal;
    private final int maxIdle;
    private final int minIdle;
    private final boolean lifo;
    private final boolean fairness;
    private final long maxWaitMillis;
    private final long minEvictableIdleTimeMillis;
    private final long softMinEvictableIdleTimeMillis;
    private final int numTestsPerEvictionRun;
    private final boolean testOnCreate;
    private final boolean testOnBorrow;
    private final boolean testOnReturn;
    private final boolean testWhileIdle;
    private final long timeBetweenEvictionRunsMillis;
    private final String evictionPolicyClassName;
    private final boolean blockWhenExhausted;
    private final boolean jmxEnabled;
    private final String jmxNameBase;
    private final String jmxNamePrefix;
    private final JedisPoolConfig jedisPoolConfig;

    private RedisConnectionPoolConfig(Builder builder) {
        this.maxTotal = builder.maxTotal;
        this.maxIdle = builder.maxIdle;
        this.minIdle = builder.minIdle;
        this.lifo = builder.lifo;
        this.fairness = builder.fairness;
        this.maxWaitMillis = builder.maxWaitMillis;
        this.minEvictableIdleTimeMillis = builder.minEvictableIdleTimeMillis;
        this.softMinEvictableIdleTimeMillis = builder.softMinEvictableIdleTimeMillis;
        this.numTestsPerEvictionRun = builder.numTestsPerEvictionRun;
        this.testOnCreate = builder.testOnCreate;
        this.testOnBorrow = builder.testOnBorrow;
        this.testOnReturn = builder.testOnReturn;
        this.testWhileIdle = builder.testWhileIdle;
        this.timeBetweenEvictionRunsMillis = builder.timeBetweenEvictionRunsMillis;
        this.evictionPolicyClassName = builder.evictionPolicyClassName;
        this.blockWhenExhausted = builder.blockWhenExhausted;
        this.jmxEnabled = builder.jmxEnabled;
        this.jmxNameBase = builder.jmxNameBase;
        this.jmxNamePrefix = builder.jmxNamePrefix;
        this.jedisPoolConfig = RedisConnectionPoolConfig.createJedisPoolConfig(builder);
    }

    private static JedisPoolConfig createJedisPoolConfig(Builder builder) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(builder.maxTotal);
        config.setMaxIdle(builder.maxIdle);
        config.setMinIdle(builder.minIdle);
        config.setLifo(builder.lifo);
        config.setFairness(builder.fairness);
        config.setMaxWaitMillis(builder.maxWaitMillis);
        config.setMinEvictableIdleTimeMillis(builder.minEvictableIdleTimeMillis);
        config.setSoftMinEvictableIdleTimeMillis(builder.softMinEvictableIdleTimeMillis);
        config.setNumTestsPerEvictionRun(builder.numTestsPerEvictionRun);
        config.setTestOnCreate(builder.testOnCreate);
        config.setTestOnBorrow(builder.testOnBorrow);
        config.setTestOnReturn(builder.testOnReturn);
        config.setTestWhileIdle(builder.testWhileIdle);
        config.setTimeBetweenEvictionRunsMillis(builder.timeBetweenEvictionRunsMillis);
        config.setEvictionPolicyClassName(builder.evictionPolicyClassName);
        config.setBlockWhenExhausted(builder.blockWhenExhausted);
        config.setJmxEnabled(builder.jmxEnabled);
        config.setJmxNameBase(builder.jmxNameBase);
        config.setJmxNamePrefix(builder.jmxNamePrefix);
        return config;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public boolean isLifo() {
        return this.lifo;
    }

    public boolean isFairness() {
        return this.fairness;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public String getEvictionPolicyClassName() {
        return this.evictionPolicyClassName;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public String getJmxNameBase() {
        return this.jmxNameBase;
    }

    public String getJmxNamePrefix() {
        return this.jmxNamePrefix;
    }

    public JedisPoolConfig getJedisPoolConfig() {
        return this.jedisPoolConfig;
    }

    public String toString() {
        return "Builder{maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + ", lifo=" + this.lifo + ", fairness=" + this.fairness + ", maxWaitMillis=" + this.maxWaitMillis + ", minEvictableIdleTimeMillis=" + this.minEvictableIdleTimeMillis + ", softMinEvictableIdleTimeMillis=" + this.softMinEvictableIdleTimeMillis + ", numTestsPerEvictionRun=" + this.numTestsPerEvictionRun + ", testOnCreate=" + this.testOnCreate + ", testOnBorrow=" + this.testOnBorrow + ", testOnReturn=" + this.testOnReturn + ", testWhileIdle=" + this.testWhileIdle + ", timeBetweenEvictionRunsMillis=" + this.timeBetweenEvictionRunsMillis + ", evictionPolicyClassName='" + this.evictionPolicyClassName + '\'' + ", blockWhenExhausted=" + this.blockWhenExhausted + ", jmxEnabled=" + this.jmxEnabled + ", jmxNameBase='" + this.jmxNameBase + '\'' + ", jmxNamePrefix='" + this.jmxNamePrefix + '\'' + '}';
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<RedisConnectionPoolConfig> {
        @PluginBuilderAttribute
        private int maxTotal = 8;
        @PluginBuilderAttribute
        private int maxIdle = 8;
        @PluginBuilderAttribute
        private int minIdle = 0;
        @PluginBuilderAttribute
        private boolean lifo = true;
        @PluginBuilderAttribute
        private boolean fairness = false;
        @PluginBuilderAttribute
        private long maxWaitMillis = -1L;
        @PluginBuilderAttribute
        private long minEvictableIdleTimeMillis = 60000L;
        @PluginBuilderAttribute
        private long softMinEvictableIdleTimeMillis = -1L;
        @PluginBuilderAttribute
        private int numTestsPerEvictionRun = -1;
        @PluginBuilderAttribute
        private boolean testOnCreate = false;
        @PluginBuilderAttribute
        private boolean testOnBorrow = false;
        @PluginBuilderAttribute
        private boolean testOnReturn = false;
        @PluginBuilderAttribute
        private boolean testWhileIdle = true;
        @PluginBuilderAttribute
        private long timeBetweenEvictionRunsMillis = 30000L;
        @PluginBuilderAttribute
        private String evictionPolicyClassName = "org.apache.commons.pool2.impl.DefaultEvictionPolicy";
        @PluginBuilderAttribute
        private boolean blockWhenExhausted = true;
        @PluginBuilderAttribute
        private boolean jmxEnabled = true;
        @PluginBuilderAttribute
        private String jmxNameBase = null;
        @PluginBuilderAttribute
        private String jmxNamePrefix = "com.vlkan.log4j2.redis.appender.JedisConnectionPool";

        public int getMaxTotal() {
            return this.maxTotal;
        }

        public Builder setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public int getMaxIdle() {
            return this.maxIdle;
        }

        public Builder setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        public int getMinIdle() {
            return this.minIdle;
        }

        public Builder setMinIdle(int minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public boolean getLifo() {
            return this.lifo;
        }

        public Builder setLifo(boolean lifo) {
            this.lifo = lifo;
            return this;
        }

        public boolean getFairness() {
            return this.fairness;
        }

        public Builder setFairness(boolean fairness) {
            this.fairness = fairness;
            return this;
        }

        public long getMaxWaitMillis() {
            return this.maxWaitMillis;
        }

        public Builder setMaxWaitMillis(long maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
            return this;
        }

        public long getMinEvictableIdleTimeMillis() {
            return this.minEvictableIdleTimeMillis;
        }

        public Builder setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
            this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
            return this;
        }

        public long getSoftMinEvictableIdleTimeMillis() {
            return this.softMinEvictableIdleTimeMillis;
        }

        public Builder setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
            this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
            return this;
        }

        public int getNumTestsPerEvictionRun() {
            return this.numTestsPerEvictionRun;
        }

        public Builder setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
            this.numTestsPerEvictionRun = numTestsPerEvictionRun;
            return this;
        }

        public boolean getTestOnCreate() {
            return this.testOnCreate;
        }

        public Builder setTestOnCreate(boolean testOnCreate) {
            this.testOnCreate = testOnCreate;
            return this;
        }

        public boolean getTestOnBorrow() {
            return this.testOnBorrow;
        }

        public Builder setTestOnBorrow(boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
            return this;
        }

        public boolean getTestOnReturn() {
            return this.testOnReturn;
        }

        public Builder setTestOnReturn(boolean testOnReturn) {
            this.testOnReturn = testOnReturn;
            return this;
        }

        public boolean getTestWhileIdle() {
            return this.testWhileIdle;
        }

        public Builder setTestWhileIdle(boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
            return this;
        }

        public long getTimeBetweenEvictionRunsMillis() {
            return this.timeBetweenEvictionRunsMillis;
        }

        public Builder setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
            this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
            return this;
        }

        public String getEvictionPolicyClassName() {
            return this.evictionPolicyClassName;
        }

        public Builder setEvictionPolicyClassName(String evictionPolicyClassName) {
            this.evictionPolicyClassName = evictionPolicyClassName;
            return this;
        }

        public boolean getBlockWhenExhausted() {
            return this.blockWhenExhausted;
        }

        public Builder setBlockWhenExhausted(boolean blockWhenExhausted) {
            this.blockWhenExhausted = blockWhenExhausted;
            return this;
        }

        public boolean getJmxEnabled() {
            return this.jmxEnabled;
        }

        public Builder setJmxEnabled(boolean jmxEnabled) {
            this.jmxEnabled = jmxEnabled;
            return this;
        }

        public String getJmxNameBase() {
            return this.jmxNameBase;
        }

        public Builder setJmxNameBase(String jmxNameBase) {
            this.jmxNameBase = jmxNameBase;
            return this;
        }

        public String getJmxNamePrefix() {
            return this.jmxNamePrefix;
        }

        public Builder setJmxNamePrefix(String jmxNamePrefix) {
            this.jmxNamePrefix = jmxNamePrefix;
            return this;
        }

        private Builder() {
        }

        public RedisConnectionPoolConfig build() {
            return new RedisConnectionPoolConfig(this);
        }

        public String toString() {
            return "Builder{maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + ", lifo=" + this.lifo + ", fairness=" + this.fairness + ", maxWaitMillis=" + this.maxWaitMillis + ", minEvictableIdleTimeMillis=" + this.minEvictableIdleTimeMillis + ", softMinEvictableIdleTimeMillis=" + this.softMinEvictableIdleTimeMillis + ", numTestsPerEvictionRun=" + this.numTestsPerEvictionRun + ", testOnCreate=" + this.testOnCreate + ", testOnBorrow=" + this.testOnBorrow + ", testOnReturn=" + this.testOnReturn + ", testWhileIdle=" + this.testWhileIdle + ", timeBetweenEvictionRunsMillis=" + this.timeBetweenEvictionRunsMillis + ", evictionPolicyClassName='" + this.evictionPolicyClassName + '\'' + ", blockWhenExhausted=" + this.blockWhenExhausted + ", jmxEnabled=" + this.jmxEnabled + ", jmxNameBase='" + this.jmxNameBase + '\'' + ", jmxNamePrefix='" + this.jmxNamePrefix + '\'' + '}';
        }
    }
}

