/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.redis.appender;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.RateLimiter;
import com.vlkan.log4j2.redis.appender.DebugLogger;
import com.vlkan.log4j2.redis.appender.RedisAppender;
import com.vlkan.log4j2.redis.appender.RedisThrottlerConfig;
import com.vlkan.log4j2.redis.appender.RedisThrottlerInternalJmxBean;
import com.vlkan.log4j2.redis.appender.RedisThrottlerJmxBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

class RedisThrottler
implements AutoCloseable {
    private static final Map<ObjectName, Integer> jmxBeanReferenceCountByName = new HashMap<ObjectName, Integer>();
    private final RedisThrottlerConfig config;
    private final RedisAppender appender;
    private final boolean ignoreExceptions;
    private final BlockingQueue<byte[]> buffer;
    private final byte[][] batch;
    private final Thread flushTrigger;
    private final RateLimiter eventRateLimiter;
    private final RateLimiter byteRateLimiter;
    private final DebugLogger logger;
    private final ObjectName jmxBeanName;
    private volatile RedisThrottlerJmxBean jmxBean = null;
    private final AtomicReference<Throwable> lastThrown = new AtomicReference<Object>(null);

    RedisThrottler(RedisThrottlerConfig config, RedisAppender appender, boolean ignoreExceptions, boolean debugEnabled) {
        this.config = config;
        this.appender = appender;
        this.ignoreExceptions = ignoreExceptions;
        this.buffer = new ArrayBlockingQueue<byte[]>(config.getBufferSize());
        this.batch = new byte[config.getBatchSize()][];
        this.flushTrigger = this.createFlushTrigger();
        this.eventRateLimiter = config.getMaxEventCountPerSecond() > 0.0 ? RateLimiter.create((double)config.getMaxEventCountPerSecond()) : null;
        this.byteRateLimiter = config.getMaxByteCountPerSecond() > 0.0 ? RateLimiter.create((double)config.getMaxByteCountPerSecond()) : null;
        this.logger = new DebugLogger(RedisThrottler.class, debugEnabled);
        this.jmxBeanName = this.createJmxBeanName();
    }

    private ObjectName createJmxBeanName() {
        String beanName = (String)MoreObjects.firstNonNull((Object)this.config.getJmxBeanName(), (Object)String.format("org.apache.logging.log4j2:type=%s,component=Appenders,name=%s,subtype=RedisThrottler", this.appender.getConfig().getLoggerContext().getName(), this.appender.getName()));
        try {
            return new ObjectName(beanName);
        }
        catch (MalformedObjectNameException error) {
            String message = String.format("malformed JMX bean name (beanName=%s)", beanName);
            throw new RuntimeException(message, error);
        }
    }

    private Thread createFlushTrigger() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                RedisThrottler.this.logger.debug("started", new Object[0]);
                while (true) {
                    RedisThrottler.this.logger.debug("flushing", new Object[0]);
                    try {
                        RedisThrottler.this.flush();
                    }
                    catch (InterruptedException ignored) {
                        RedisThrottler.this.logger.debug("interrupted", new Object[0]);
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        });
    }

    private void flush() throws InterruptedException {
        long pollPeriodMillis;
        int batchIndex = 0;
        this.logger.debug("polling", new Object[0]);
        for (long waitPeriodMillis = this.config.getFlushPeriodMillis(); waitPeriodMillis > 0L; waitPeriodMillis -= pollPeriodMillis) {
            long pollTimeMillis = System.currentTimeMillis();
            byte[] event = this.buffer.poll(waitPeriodMillis, TimeUnit.MILLISECONDS);
            if (event == null) break;
            if (this.logger.isEnabled()) {
                this.logger.debug("polled: %s", new String(event));
            }
            this.batch[batchIndex++] = event;
            if (batchIndex == this.batch.length) {
                this.safeConsumeEvents(this.batch);
                batchIndex = 0;
            }
            pollPeriodMillis = System.currentTimeMillis() - pollTimeMillis;
        }
        if (batchIndex > 0) {
            this.logger.debug("pushing remaining %d events", batchIndex);
            byte[][] subBatch = (byte[][])Arrays.copyOfRange(this.batch, 0, batchIndex);
            this.safeConsumeEvents(subBatch);
        }
    }

    private void safeConsumeEvents(byte[] ... events) {
        int eventCount = events.length;
        try {
            this.logger.debug("pushing %d events", eventCount);
            this.appender.consumeThrottledEvents(events);
            this.jmxBean.incrementRedisPushSuccessCount(eventCount);
        }
        catch (Throwable thrown) {
            if (this.logger.isEnabled()) {
                this.logger.debug("push failure: %s", thrown.getMessage());
                thrown.printStackTrace();
            }
            this.lastThrown.set(thrown);
            this.jmxBean.incrementRedisPushFailureCount(eventCount);
        }
    }

    public RedisThrottlerJmxBean getJmxBean() {
        return this.jmxBean;
    }

    public void push(byte[] event) {
        this.jmxBean.incrementTotalEventCount(1L);
        Throwable thrown = this.lastThrown.getAndSet(null);
        if (thrown != null) {
            this.jmxBean.incrementIgnoredEventCount(1L);
            this.tryThrow(thrown);
            return;
        }
        if (this.eventRateLimiter != null && !this.eventRateLimiter.tryAcquire()) {
            this.jmxBean.incrementByteRateLimitFailureCount(1L);
            this.tryThrow("failed acquiring event rate limiter token");
            return;
        }
        if (this.byteRateLimiter != null && !this.byteRateLimiter.tryAcquire(event.length)) {
            this.jmxBean.incrementByteRateLimitFailureCount(1L);
            this.tryThrow("failed acquiring byte rate limiter token");
            return;
        }
        if (!this.buffer.offer(event)) {
            this.jmxBean.incrementUnavailableBufferSpaceFailureCount(1L);
            this.tryThrow("failed enqueueing");
        }
    }

    private void tryThrow(Throwable error) {
        this.logger.debug(error.getMessage(), error);
        if (!this.ignoreExceptions) {
            throw new RuntimeException(error);
        }
    }

    private void tryThrow(String error) {
        this.logger.debug(error, new Object[0]);
        if (!this.ignoreExceptions) {
            throw new RuntimeException(error);
        }
    }

    public synchronized void start() {
        this.logger.debug("starting", new Object[0]);
        this.jmxBean = this.registerOrGetJmxBean();
        this.flushTrigger.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RedisThrottlerJmxBean registerOrGetJmxBean() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Map<ObjectName, Integer> map = jmxBeanReferenceCountByName;
            synchronized (map) {
                RedisThrottlerJmxBean jmxBean;
                Integer jmxBeanReferenceCount = jmxBeanReferenceCountByName.get(this.jmxBeanName);
                if (jmxBeanReferenceCount == null) {
                    jmxBeanReferenceCount = 0;
                }
                try {
                    jmxBean = new RedisThrottlerInternalJmxBean();
                    StandardMBean jmxBeanWrapper = new StandardMBean(jmxBean, RedisThrottlerJmxBean.class);
                    mbs.registerMBean(jmxBeanWrapper, this.jmxBeanName);
                }
                catch (InstanceAlreadyExistsException ignored) {
                    jmxBean = JMX.newMBeanProxy(mbs, this.jmxBeanName, RedisThrottlerJmxBean.class);
                }
                jmxBeanReferenceCountByName.put(this.jmxBeanName, jmxBeanReferenceCount + 1);
                return jmxBean;
            }
        }
        catch (Throwable error) {
            String message = String.format("failed accessing the JMX bean (jmxBeanName=%s)", this.jmxBeanName);
            throw new RuntimeException(message, error);
        }
    }

    @Override
    public synchronized void close() {
        this.logger.debug("closing", new Object[0]);
        this.flushTrigger.interrupt();
        this.unregisterJmxBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterJmxBean() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Map<ObjectName, Integer> map = jmxBeanReferenceCountByName;
        synchronized (map) {
            Integer jmxBeanReferenceCount = jmxBeanReferenceCountByName.get(this.jmxBeanName);
            if (jmxBeanReferenceCount == null || jmxBeanReferenceCount == 0) {
                this.logger.debug("failed unregistering the JMX bean (jmxBeanName=%s, jmxBeanReferenceCount=%s)", this.jmxBeanName, jmxBeanReferenceCount);
            } else if (jmxBeanReferenceCount == 1) {
                try {
                    mbs.unregisterMBean(this.jmxBeanName);
                    jmxBeanReferenceCountByName.remove(this.jmxBeanName);
                }
                catch (Throwable error) {
                    this.logger.debug("failed unregistering the JMX bean (jmxBeanName=%s)", this.jmxBeanName);
                }
            } else {
                jmxBeanReferenceCountByName.put(this.jmxBeanName, jmxBeanReferenceCount - 1);
            }
        }
    }
}

