/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.log4j2.redis.appender;

import com.vlkan.log4j2.redis.appender.Helpers;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="RedisThrottlerConfig", category="Core", printObject=true)
public class RedisThrottlerConfig {
    private final int bufferSize;
    private final int batchSize;
    private final long flushPeriodMillis;
    private final double maxEventCountPerSecond;
    private final double maxByteCountPerSecond;
    private final String jmxBeanName;

    private RedisThrottlerConfig(Builder builder) {
        this.bufferSize = builder.bufferSize;
        this.batchSize = builder.batchSize;
        this.flushPeriodMillis = builder.flushPeriodMillis;
        this.maxEventCountPerSecond = builder.maxEventCountPerSecond;
        this.maxByteCountPerSecond = builder.maxByteCountPerSecond;
        this.jmxBeanName = Strings.isBlank((String)builder.jmxBeanName) ? null : builder.jmxBeanName;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getFlushPeriodMillis() {
        return this.flushPeriodMillis;
    }

    public double getMaxEventCountPerSecond() {
        return this.maxEventCountPerSecond;
    }

    public double getMaxByteCountPerSecond() {
        return this.maxByteCountPerSecond;
    }

    public String getJmxBeanName() {
        return this.jmxBeanName;
    }

    public String toString() {
        return "RedisThrottlerConfig{bufferSize=" + this.bufferSize + ", batchSize=" + this.batchSize + ", flushPeriodMillis=" + this.flushPeriodMillis + ", maxEventCountPerSecond=" + this.maxEventCountPerSecond + ", maxByteCountPerSecond=" + this.maxByteCountPerSecond + ", jmxBeanName=" + this.jmxBeanName + '}';
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<RedisThrottlerConfig> {
        @PluginBuilderAttribute
        private int bufferSize = 500;
        @PluginBuilderAttribute
        private int batchSize = 100;
        @PluginBuilderAttribute
        private long flushPeriodMillis = 1000L;
        @PluginBuilderAttribute
        private double maxEventCountPerSecond = 0.0;
        @PluginBuilderAttribute
        private double maxByteCountPerSecond = 0.0;
        @PluginBuilderAttribute
        private String jmxBeanName = null;

        private Builder() {
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public long getFlushPeriodMillis() {
            return this.flushPeriodMillis;
        }

        public Builder setFlushPeriodMillis(long flushPeriodMillis) {
            this.flushPeriodMillis = flushPeriodMillis;
            return this;
        }

        public double getMaxEventCountPerSecond() {
            return this.maxEventCountPerSecond;
        }

        public Builder setMaxEventCountPerSecond(double maxEventCountPerSecond) {
            this.maxEventCountPerSecond = maxEventCountPerSecond;
            return this;
        }

        public double getMaxByteCountPerSecond() {
            return this.maxByteCountPerSecond;
        }

        public Builder setMaxByteCountPerSecond(double maxByteCountPerSecond) {
            this.maxByteCountPerSecond = maxByteCountPerSecond;
            return this;
        }

        public String getJmxBeanName() {
            return this.jmxBeanName;
        }

        public Builder setJmxBeanName(String jmxBeanName) {
            this.jmxBeanName = jmxBeanName;
            return this;
        }

        public RedisThrottlerConfig build() {
            this.check();
            return new RedisThrottlerConfig(this);
        }

        private void check() {
            Helpers.requireArgument(this.bufferSize > 0, "expecting: bufferSize > 0, found: %s", this.bufferSize);
            Helpers.requireArgument(this.batchSize > 0 && this.batchSize < this.bufferSize, "expecting: batchSize > 0 && batchSize < bufferSize, found: %s", this.batchSize);
            Helpers.requireArgument(this.flushPeriodMillis > 0L, "expecting: flushPeriodMillis > 0, found: %s", this.flushPeriodMillis);
            Helpers.requireArgument(this.maxEventCountPerSecond >= 0.0, "expecting: maxEventCountPerSecond >= 0, found: %d", this.maxEventCountPerSecond);
            Helpers.requireArgument(this.maxByteCountPerSecond >= 0.0, "expecting: maxByteCountPerSecond >= 0, found: %d", this.maxByteCountPerSecond);
        }

        public String toString() {
            return "Builder{bufferSize=" + this.bufferSize + ", batchSize=" + this.batchSize + ", flushPeriodMillis=" + this.flushPeriodMillis + ", maxEventCountPerSecond=" + this.maxEventCountPerSecond + ", maxByteCountPerSecond=" + this.maxByteCountPerSecond + ", jmxBeanName=" + this.jmxBeanName + '}';
        }
    }
}

