/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos;

import com.vlkan.rfos.RotationCallback;
import com.vlkan.rfos.policy.RotationPolicy;
import java.io.File;
import java.io.OutputStream;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRotationCallback
implements RotationCallback {
    private static final LoggingRotationCallback INSTANCE = new LoggingRotationCallback();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingRotationCallback.class);

    private LoggingRotationCallback() {
    }

    public static LoggingRotationCallback getInstance() {
        return INSTANCE;
    }

    @Override
    public void onTrigger(RotationPolicy policy, Instant instant) {
        LOGGER.debug("rotation trigger {policy={}, instant={}}", (Object)policy, (Object)instant);
    }

    @Override
    public void onOpen(RotationPolicy policy, Instant instant, OutputStream ignored) {
        LOGGER.debug("file open {policy={}, instant={}}", (Object)policy, (Object)instant);
    }

    @Override
    public void onClose(RotationPolicy policy, Instant instant, OutputStream stream) {
        LOGGER.debug("file close {policy={}, instant={}}", (Object)policy, (Object)instant);
    }

    @Override
    public void onSuccess(RotationPolicy policy, Instant instant, File file) {
        LOGGER.debug("rotation success {policy={}, instant={}, file={}}", new Object[]{policy, instant, file});
    }

    @Override
    public void onFailure(RotationPolicy policy, Instant instant, File file, Exception error) {
        String message = String.format("rotation failure {policy=%s, instant=%s, file=%s}", policy, instant, file);
        LOGGER.error(message, (Throwable)error);
    }
}

