/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos.policy;

import com.vlkan.rfos.Rotatable;
import com.vlkan.rfos.policy.RotationPolicy;
import com.vlkan.rfos.policy.SizeBasedRotationPolicy;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteMatchingRotationPolicy
implements RotationPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SizeBasedRotationPolicy.class);
    private final byte targetByte;
    private final int maxOccurrenceCount;
    private long occurrenceCount;
    private Rotatable rotatable;

    public ByteMatchingRotationPolicy(byte targetByte, int maxOccurrenceCount) {
        if (maxOccurrenceCount < 1) {
            String message = String.format("invalid count {maxOccurrenceCount=%d}", maxOccurrenceCount);
            throw new IllegalArgumentException(message);
        }
        this.targetByte = targetByte;
        this.maxOccurrenceCount = maxOccurrenceCount;
    }

    @Override
    public void start(Rotatable rotatable) {
        this.rotatable = rotatable;
        this.occurrenceCount = this.countOccurrences(rotatable.getConfig().getFile());
        if (this.occurrenceCount > 0L) {
            LOGGER.debug("starting with non-zero line count {lineCount={}}", (Object)this.occurrenceCount);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long countOccurrences(File file) {
        Path path = file.toPath();
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            long lineCount = 0L;
            byte[] buffer = new byte[8192];
            block11: while (true) {
                int length;
                if ((length = inputStream.read(buffer)) < 0) {
                    long l = lineCount;
                    return l;
                }
                int i = 0;
                while (true) {
                    if (i >= length) continue block11;
                    if (buffer[i] == this.targetByte) {
                        ++lineCount;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception error) {
            String message = String.format("read failure {file=%s}", file);
            throw new RuntimeException(message, error);
        }
    }

    @Override
    public boolean isWriteSensitive() {
        return true;
    }

    @Override
    public void acceptWrite(int b) {
        if (b == this.targetByte) {
            ++this.occurrenceCount;
            this.rotateIfNecessary();
        }
    }

    @Override
    public void acceptWrite(byte[] buf) {
        int matchCount = 0;
        for (byte b : buf) {
            if (b != this.targetByte) continue;
            ++matchCount;
        }
        this.occurrenceCount += (long)matchCount;
        this.rotateIfNecessary();
    }

    @Override
    public void acceptWrite(byte[] buf, int off, int len) {
        int matchCount = 0;
        int maxIdx = off + len;
        for (int idx = off; idx < maxIdx; ++idx) {
            if (buf[idx] != this.targetByte) continue;
            ++matchCount;
        }
        this.occurrenceCount += (long)matchCount;
        this.rotateIfNecessary();
    }

    private void rotateIfNecessary() {
        if (this.occurrenceCount >= (long)this.maxOccurrenceCount) {
            LOGGER.debug("triggering {occurrenceCount={}}", (Object)this.occurrenceCount);
            Instant instant = this.rotatable.getConfig().getClock().now();
            this.rotatable.rotate(this, instant);
            this.occurrenceCount = 0L;
        }
    }

    public boolean equals(Object instance) {
        if (this == instance) {
            return true;
        }
        if (instance == null || this.getClass() != instance.getClass()) {
            return false;
        }
        ByteMatchingRotationPolicy policy = (ByteMatchingRotationPolicy)instance;
        return this.maxOccurrenceCount == policy.maxOccurrenceCount;
    }

    public int hashCode() {
        return Objects.hash(this.maxOccurrenceCount);
    }

    public String toString() {
        return String.format("ByteMatchingRotationPolicy{targetByte=0x%X, maxOccurrenceCount=%d}", this.targetByte, this.maxOccurrenceCount);
    }
}

