/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos.policy;

import com.vlkan.rfos.Rotatable;
import com.vlkan.rfos.policy.RotationPolicy;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeBasedRotationPolicy
implements RotationPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SizeBasedRotationPolicy.class);
    private final long maxByteCount;
    private Rotatable rotatable;

    public SizeBasedRotationPolicy(long maxByteCount) {
        if (maxByteCount < 1L) {
            String message = String.format("invalid size {maxByteCount=%d}", maxByteCount);
            throw new IllegalArgumentException(message);
        }
        this.maxByteCount = maxByteCount;
    }

    public long getMaxByteCount() {
        return this.maxByteCount;
    }

    @Override
    public boolean isWriteSensitive() {
        return true;
    }

    @Override
    public void acceptWrite(long byteCount) {
        if (byteCount > this.maxByteCount) {
            LOGGER.debug("triggering {byteCount={}}", (Object)byteCount);
            Instant instant = this.rotatable.getConfig().getClock().now();
            this.rotatable.rotate(this, instant);
        }
    }

    @Override
    public void start(Rotatable rotatable) {
        this.rotatable = rotatable;
    }

    public boolean equals(Object instance) {
        if (this == instance) {
            return true;
        }
        if (instance == null || this.getClass() != instance.getClass()) {
            return false;
        }
        SizeBasedRotationPolicy that = (SizeBasedRotationPolicy)instance;
        return this.maxByteCount == that.maxByteCount;
    }

    public int hashCode() {
        return Objects.hash(this.maxByteCount);
    }

    public String toString() {
        return String.format("SizeBasedRotationPolicy{maxByteCount=%d}", this.maxByteCount);
    }
}

