/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos.policy;

import com.vlkan.rfos.Clock;
import com.vlkan.rfos.Rotatable;
import com.vlkan.rfos.RotationConfig;
import com.vlkan.rfos.policy.RotationPolicy;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class TimeBasedRotationPolicy
implements RotationPolicy {
    private volatile ScheduledFuture<?> scheduledFuture;

    @Override
    public boolean isWriteSensitive() {
        return false;
    }

    @Override
    public void acceptWrite(long byteCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void start(Rotatable rotatable) {
        this.start(rotatable, null);
    }

    private void start(Rotatable rotatable, Instant lastTriggerInstant) {
        RotationConfig config = rotatable.getConfig();
        Clock clock = config.getClock();
        Instant currentInstant = clock.now();
        Instant triggerInstant = this.getTriggerInstant(clock);
        long triggerDelayNanos = Duration.between(currentInstant, triggerInstant).toNanos();
        Runnable task = this.createTask(rotatable, lastTriggerInstant, triggerInstant);
        this.scheduledFuture = config.getExecutorService().schedule(task, triggerDelayNanos, TimeUnit.NANOSECONDS);
    }

    private Runnable createTask(Rotatable rotatable, Instant lastTriggerInstant, Instant triggerInstant) {
        return () -> {
            boolean validTriggerInstant;
            boolean bl = validTriggerInstant = lastTriggerInstant == null || triggerInstant.isAfter(lastTriggerInstant);
            if (validTriggerInstant) {
                this.getLogger().debug("triggering {triggerInstant={}}", (Object)triggerInstant);
                rotatable.rotate(this, triggerInstant);
            }
            this.start(rotatable, triggerInstant);
        };
    }

    @Override
    public synchronized void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public abstract Instant getTriggerInstant(Clock var1);

    protected abstract Logger getLogger();
}

