/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos;

import com.vlkan.rfos.RotatingFilePatternException;
import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

public class RotatingFilePattern {
    private static final char ESCAPE_CHAR = '%';
    private static final char DATE_TIME_DIRECTIVE_CHAR = 'd';
    private static final char DATE_TIME_BLOCK_START_CHAR = '{';
    private static final char DATE_TIME_BLOCK_END_CHAR = '}';
    private final String pattern;
    private final Locale locale;
    private final ZoneId timeZoneId;
    private final List<Field> fields;

    private RotatingFilePattern(Builder builder) {
        this.pattern = builder.pattern;
        this.locale = builder.locale;
        this.timeZoneId = builder.timeZoneId;
        this.fields = RotatingFilePattern.readPattern(this.pattern, this.locale, this.timeZoneId);
    }

    private static List<Field> readPattern(String pattern, Locale locale, ZoneId timeZoneId) {
        LinkedList<Field> fields = new LinkedList<Field>();
        StringBuilder textBuilder = new StringBuilder();
        int totalCharCount = pattern.length();
        boolean foundDateTimeDirective = false;
        int charIndex = 0;
        while (charIndex < totalCharCount) {
            char c0 = pattern.charAt(charIndex);
            if (c0 == '%') {
                int blockEndIndex;
                int blockStartIndex;
                char c2;
                char c1;
                boolean hasSufficientDateTimeChars;
                char c12;
                boolean hasOneMoreChar;
                boolean bl = hasOneMoreChar = totalCharCount - charIndex - 1 > 0;
                if (hasOneMoreChar && (c12 = pattern.charAt(charIndex + 1)) == '%') {
                    textBuilder.append(c12);
                    charIndex += 2;
                    continue;
                }
                if (textBuilder.length() > 0) {
                    String text = textBuilder.toString();
                    TextField field = new TextField(text);
                    fields.add(field);
                    textBuilder = new StringBuilder();
                }
                boolean bl2 = hasSufficientDateTimeChars = totalCharCount - charIndex - 3 > 0;
                if (hasSufficientDateTimeChars && (c1 = pattern.charAt(charIndex + 1)) == 'd' && (c2 = pattern.charAt(blockStartIndex = charIndex + 2)) == '{' && (blockEndIndex = pattern.indexOf(125, blockStartIndex + 1)) >= 0) {
                    DateTimeFormatter dateTimeFormatter;
                    String dateTimePattern = pattern.substring(blockStartIndex + 1, blockEndIndex);
                    try {
                        dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimePattern).withLocale(locale).withZone(timeZoneId);
                    }
                    catch (Exception error) {
                        String message = String.format("invalid date time pattern (position=%d, pattern=%s, dateTimePattern=%s)", charIndex, pattern, dateTimePattern);
                        throw new RotatingFilePatternException(message, error);
                    }
                    DateTimeField dateTimeField = new DateTimeField(dateTimeFormatter);
                    fields.add(dateTimeField);
                    foundDateTimeDirective = true;
                    charIndex = blockEndIndex + 1;
                    continue;
                }
                String message = String.format("invalid escape character (position=%d, pattern=%s)", charIndex, pattern);
                throw new RotatingFilePatternException(message);
            }
            textBuilder.append(c0);
            ++charIndex;
        }
        if (textBuilder.length() > 0) {
            String text = textBuilder.toString();
            TextField field = new TextField(text);
            fields.add(field);
        }
        if (!foundDateTimeDirective) {
            String message = String.format("missing date time directive (pattern=%s)", pattern);
            throw new RotatingFilePatternException(message);
        }
        return fields;
    }

    public File create(Instant instant) {
        StringBuilder pathNameBuilder = new StringBuilder();
        for (Field field : this.fields) {
            field.render(pathNameBuilder, instant);
        }
        String pathName = pathNameBuilder.toString();
        return new File(pathName);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ZoneId getTimeZoneId() {
        return this.timeZoneId;
    }

    public boolean equals(Object instance) {
        if (this == instance) {
            return true;
        }
        if (instance == null || this.getClass() != instance.getClass()) {
            return false;
        }
        RotatingFilePattern that = (RotatingFilePattern)instance;
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.locale, that.locale) && Objects.equals(this.timeZoneId, that.timeZoneId);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.locale, this.timeZoneId);
    }

    public String toString() {
        return String.format("RotatingFilePattern{pattern=%s, locale=%s, timeZoneId=%s}", this.pattern, this.locale, this.timeZoneId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String pattern;
        private Locale locale = Locale.getDefault();
        private ZoneId timeZoneId = TimeZone.getDefault().toZoneId();

        private Builder() {
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder timeZoneId(ZoneId timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public RotatingFilePattern build() {
            this.validate();
            return new RotatingFilePattern(this);
        }

        private void validate() {
            Objects.requireNonNull(this.pattern, "file");
            Objects.requireNonNull(this.locale, "locale");
            Objects.requireNonNull(this.timeZoneId, "timeZoneId");
        }
    }

    private static class DateTimeField
    implements Field {
        private final DateTimeFormatter dateTimeFormatter;

        private DateTimeField(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public void render(StringBuilder builder, Instant instant) {
            String formattedDateTime = this.dateTimeFormatter.format(instant);
            builder.append(formattedDateTime);
        }
    }

    private static class TextField
    implements Field {
        private final String text;

        private TextField(String text) {
            this.text = text;
        }

        @Override
        public void render(StringBuilder builder, Instant ignored) {
            builder.append(this.text);
        }
    }

    private static interface Field {
        public void render(StringBuilder var1, Instant var2);
    }
}

