/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos;

import com.vlkan.rfos.Clock;
import com.vlkan.rfos.LoggingRotationCallback;
import com.vlkan.rfos.RotatingFilePattern;
import com.vlkan.rfos.RotationCallback;
import com.vlkan.rfos.SystemClock;
import com.vlkan.rfos.policy.RotationPolicy;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class RotationConfig {
    private final File file;
    private final RotatingFilePattern filePattern;
    private final ScheduledExecutorService executorService;
    private final Set<RotationPolicy> policies;
    private final boolean append;
    private final boolean compress;
    private final Clock clock;
    private final RotationCallback callback;

    private RotationConfig(Builder builder) {
        this.file = builder.file;
        this.filePattern = builder.filePattern;
        this.executorService = builder.executorService;
        this.policies = builder.policies;
        this.append = builder.append;
        this.compress = builder.compress;
        this.clock = builder.clock;
        this.callback = builder.callback;
    }

    public File getFile() {
        return this.file;
    }

    public RotatingFilePattern getFilePattern() {
        return this.filePattern;
    }

    public static ScheduledExecutorService getDefaultExecutorService() {
        return DefaultExecutorServiceHolder.INSTANCE;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public Set<RotationPolicy> getPolicies() {
        return this.policies;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public Clock getClock() {
        return this.clock;
    }

    public RotationCallback getCallback() {
        return this.callback;
    }

    public boolean equals(Object instance) {
        if (this == instance) {
            return true;
        }
        if (instance == null || this.getClass() != instance.getClass()) {
            return false;
        }
        RotationConfig that = (RotationConfig)instance;
        return this.append == that.append && this.compress == that.compress && Objects.equals(this.file, that.file) && Objects.equals(this.filePattern, that.filePattern) && Objects.equals(this.executorService, that.executorService) && Objects.equals(this.policies, that.policies) && Objects.equals(this.clock, that.clock) && Objects.equals(this.callback, that.callback);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.filePattern, this.executorService, this.policies, this.append, this.compress, this.clock, this.callback);
    }

    public String toString() {
        return String.format("RotationConfig{file=%s}", this.file);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File file;
        private RotatingFilePattern filePattern;
        private ScheduledExecutorService executorService;
        private Set<RotationPolicy> policies;
        private boolean append = true;
        private boolean compress = false;
        private Clock clock = SystemClock.getInstance();
        private RotationCallback callback = LoggingRotationCallback.getInstance();

        private Builder() {
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder file(String fileName) {
            this.file = new File(fileName);
            return this;
        }

        public Builder filePattern(RotatingFilePattern filePattern) {
            this.filePattern = filePattern;
            return this;
        }

        public Builder filePattern(String filePattern) {
            this.filePattern = RotatingFilePattern.builder().pattern(filePattern).build();
            return this;
        }

        public Builder executorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder policies(Set<RotationPolicy> policies) {
            this.policies = policies;
            return this;
        }

        public Builder policy(RotationPolicy policy) {
            if (this.policies == null) {
                this.policies = new LinkedHashSet<RotationPolicy>();
            }
            this.policies.add(policy);
            return this;
        }

        public Builder append(boolean append) {
            this.append = append;
            return this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder callback(RotationCallback callback) {
            this.callback = callback;
            return this;
        }

        public RotationConfig build() {
            this.prepare();
            this.validate();
            return new RotationConfig(this);
        }

        private void prepare() {
            if (this.executorService == null) {
                this.executorService = RotationConfig.getDefaultExecutorService();
            }
        }

        private void validate() {
            Objects.requireNonNull(this.file, "file");
            Objects.requireNonNull(this.filePattern, "filePattern");
            if (this.policies == null || this.policies.isEmpty()) {
                throw new IllegalArgumentException("empty policies");
            }
            Objects.requireNonNull(this.clock, "clock");
            Objects.requireNonNull(this.callback, "callback");
        }
    }

    private static enum DefaultExecutorServiceHolder {

        private static final ScheduledExecutorService INSTANCE = DefaultExecutorServiceHolder.createDefaultExecutorService();

        private static ScheduledThreadPoolExecutor createDefaultExecutorService() {
            int threadCount = DefaultExecutorServiceHolder.readDefaultThreadCount();
            return new ScheduledThreadPoolExecutor(threadCount, new ThreadFactory(){
                private int threadCount = 0;

                @Override
                public synchronized Thread newThread(Runnable runnable) {
                    String name = String.format("RotationJanitor-%02d", ++this.threadCount);
                    Thread thread = new Thread(runnable, name);
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }

        private static int readDefaultThreadCount() {
            String threadCountProperty = System.getProperty("RotationJanitorCount");
            return threadCountProperty != null ? Integer.parseInt(threadCountProperty) : Runtime.getRuntime().availableProcessors();
        }
    }
}

