/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos.policy;

import com.vlkan.rfos.Clock;
import com.vlkan.rfos.Rotatable;
import com.vlkan.rfos.RotationConfig;
import com.vlkan.rfos.policy.RotationPolicy;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class TimeBasedRotationPolicy
implements RotationPolicy {
    @Override
    public boolean isWriteSensitive() {
        return false;
    }

    @Override
    public void acceptWrite(long byteCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start(Rotatable rotatable) {
        RotationConfig config = rotatable.getConfig();
        Clock clock = config.getClock();
        Instant currentInstant = clock.now();
        Instant triggerInstant = this.getTriggerInstant(clock);
        long triggerDelayMillis = Duration.between(currentInstant, triggerInstant).toMillis();
        Runnable task = this.createTask(rotatable, triggerInstant);
        config.getExecutorService().schedule(task, triggerDelayMillis, TimeUnit.MILLISECONDS);
    }

    private Runnable createTask(Rotatable rotatable, Instant triggerInstant) {
        return () -> {
            this.getLogger().debug("triggering {triggerInstant={}}", (Object)triggerInstant);
            rotatable.rotate(this, triggerInstant);
            this.start(rotatable);
        };
    }

    public abstract Instant getTriggerInstant(Clock var1);

    protected abstract Logger getLogger();
}

