/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos;

import com.vlkan.rfos.Clock;
import com.vlkan.rfos.LoggingRotationCallback;
import com.vlkan.rfos.RotatingFilePattern;
import com.vlkan.rfos.RotationCallback;
import com.vlkan.rfos.SystemClock;
import com.vlkan.rfos.policy.RotationPolicy;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class RotationConfig {
    private static final boolean DEFAULT_APPEND = true;
    private static final boolean DEFAULT_COMPRESS = false;
    private static final Clock DEFAULT_CLOCK = SystemClock.getInstance();
    private static final Set<RotationCallback> DEFAULT_CALLBACKS = Collections.singleton(LoggingRotationCallback.getInstance());
    private static final int DEFAULT_MAX_BACKUP_COUNT = -1;
    private final File file;
    private final RotatingFilePattern filePattern;
    private final ScheduledExecutorService executorService;
    private final Set<RotationPolicy> policies;
    private final boolean append;
    private final boolean compress;
    private final int maxBackupCount;
    private final Clock clock;
    private final Set<RotationCallback> callbacks;

    private RotationConfig(Builder builder) {
        this.file = builder.file;
        this.filePattern = builder.filePattern;
        this.executorService = builder.executorService;
        this.policies = Collections.unmodifiableSet(builder.policies);
        this.append = builder.append;
        this.compress = builder.compress;
        this.maxBackupCount = builder.maxBackupCount;
        this.clock = builder.clock;
        this.callbacks = Collections.unmodifiableSet(builder.callbacks);
    }

    public File getFile() {
        return this.file;
    }

    public RotatingFilePattern getFilePattern() {
        return this.filePattern;
    }

    public static ScheduledExecutorService getDefaultExecutorService() {
        return DefaultExecutorServiceHolder.INSTANCE;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public Set<RotationPolicy> getPolicies() {
        return this.policies;
    }

    public static boolean getDefaultAppend() {
        return true;
    }

    public boolean isAppend() {
        return this.append;
    }

    public static boolean getDefaultCompress() {
        return false;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public static int getDefaultMaxBackupCount() {
        return -1;
    }

    public int getMaxBackupCount() {
        return this.maxBackupCount;
    }

    public static Clock getDefaultClock() {
        return DEFAULT_CLOCK;
    }

    public Clock getClock() {
        return this.clock;
    }

    public static Set<RotationCallback> getDefaultCallbacks() {
        return DEFAULT_CALLBACKS;
    }

    @Deprecated
    public RotationCallback getCallback() {
        return this.callbacks.iterator().next();
    }

    public Set<RotationCallback> getCallbacks() {
        return this.callbacks;
    }

    public boolean equals(Object instance) {
        if (this == instance) {
            return true;
        }
        if (instance == null || this.getClass() != instance.getClass()) {
            return false;
        }
        RotationConfig that = (RotationConfig)instance;
        return this.append == that.append && this.compress == that.compress && this.maxBackupCount == that.maxBackupCount && Objects.equals(this.file, that.file) && Objects.equals(this.filePattern, that.filePattern) && Objects.equals(this.executorService, that.executorService) && Objects.equals(this.policies, that.policies) && Objects.equals(this.clock, that.clock) && Objects.equals(this.callbacks, that.callbacks);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.filePattern, this.executorService, this.policies, this.append, this.compress, this.maxBackupCount, this.clock, this.callbacks);
    }

    public String toString() {
        return String.format("RotationConfig{file=%s}", this.file);
    }

    public static Builder builder(RotationConfig config) {
        Objects.requireNonNull(config, "config");
        return new Builder(config);
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ Clock access$1200() {
        return DEFAULT_CLOCK;
    }

    static /* synthetic */ Set access$1300() {
        return DEFAULT_CALLBACKS;
    }

    public static class Builder {
        private File file;
        private RotatingFilePattern filePattern;
        private ScheduledExecutorService executorService;
        private Set<RotationPolicy> policies;
        private boolean append = true;
        private boolean compress = false;
        private int maxBackupCount = -1;
        private Clock clock = RotationConfig.access$1200();
        private Set<RotationCallback> callbacks = new LinkedHashSet<RotationCallback>(RotationConfig.access$1300());

        private Builder(RotationConfig config) {
            this.file = config.file;
            this.filePattern = config.filePattern;
            this.executorService = config.executorService;
            this.policies = config.policies;
            this.append = config.append;
            this.compress = config.append;
            this.maxBackupCount = config.maxBackupCount;
            this.clock = config.clock;
            this.callbacks = config.callbacks;
        }

        private Builder() {
        }

        public Builder file(File file) {
            this.file = Objects.requireNonNull(file, "file");
            return this;
        }

        public Builder file(String fileName) {
            Objects.requireNonNull(fileName, "fileName");
            this.file = new File(fileName);
            return this;
        }

        public Builder filePattern(RotatingFilePattern filePattern) {
            this.filePattern = Objects.requireNonNull(filePattern, "filePattern");
            return this;
        }

        public Builder filePattern(String filePattern) {
            Objects.requireNonNull(filePattern, "filePattern");
            this.filePattern = RotatingFilePattern.builder().pattern(filePattern).build();
            return this;
        }

        public Builder executorService(ScheduledExecutorService executorService) {
            this.executorService = Objects.requireNonNull(executorService, "executorService");
            return this;
        }

        public Builder policies(Set<RotationPolicy> policies) {
            Objects.requireNonNull(policies, "policies");
            this.policies = new LinkedHashSet<RotationPolicy>(policies);
            return this;
        }

        public Builder policy(RotationPolicy policy) {
            Objects.requireNonNull(policy, "policy");
            if (this.policies == null) {
                this.policies = new LinkedHashSet<RotationPolicy>();
            }
            this.policies.add(policy);
            return this;
        }

        public Builder append(boolean append) {
            this.append = append;
            return this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder maxBackupCount(int maxBackupCount) {
            this.maxBackupCount = maxBackupCount;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
            return this;
        }

        public Builder callback(RotationCallback callback) {
            Objects.requireNonNull(callback, "callback");
            this.callbacks.add(callback);
            return this;
        }

        public Builder callbacks(Set<RotationCallback> callbacks) {
            Objects.requireNonNull(callbacks, "callbacks");
            this.callbacks = new LinkedHashSet<RotationCallback>(callbacks);
            return this;
        }

        public RotationConfig build() {
            this.prepare();
            this.validate();
            return new RotationConfig(this);
        }

        private void prepare() {
            if (this.executorService == null) {
                this.executorService = RotationConfig.getDefaultExecutorService();
            }
        }

        private void validate() {
            Objects.requireNonNull(this.file, "file");
            if (this.maxBackupCount > 0) {
                String conflictingField = null;
                if (this.filePattern != null) {
                    conflictingField = "filePattern";
                } else if (this.compress) {
                    conflictingField = "compress";
                }
                if (conflictingField != null) {
                    throw new IllegalArgumentException("maxBackupCount and " + conflictingField + " cannot be combined");
                }
            } else if (this.filePattern == null) {
                throw new IllegalArgumentException("one of either maxBackupCount or filePattern must be provided");
            }
            if (this.policies == null || this.policies.isEmpty()) {
                throw new IllegalArgumentException("no rotation policy is provided");
            }
        }
    }

    private static enum DefaultExecutorServiceHolder {

        private static final ScheduledExecutorService INSTANCE = DefaultExecutorServiceHolder.createDefaultExecutorService();

        private static ScheduledThreadPoolExecutor createDefaultExecutorService() {
            int threadCount = DefaultExecutorServiceHolder.readDefaultThreadCount();
            return new ScheduledThreadPoolExecutor(threadCount, new ThreadFactory(){
                private int threadCount = 0;

                @Override
                public synchronized Thread newThread(Runnable runnable) {
                    String name = String.format("RotationJanitor-%02d", ++this.threadCount);
                    Thread thread = new Thread(runnable, name);
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }

        private static int readDefaultThreadCount() {
            String threadCountProperty = System.getProperty("RotationJanitorCount");
            return threadCountProperty != null ? Integer.parseInt(threadCountProperty) : Runtime.getRuntime().availableProcessors();
        }
    }
}

