/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos;

import java.io.IOException;
import java.io.OutputStream;

class ByteCountingOutputStream
extends OutputStream {
    private final OutputStream parent;
    private long size;

    ByteCountingOutputStream(OutputStream parent, long size) {
        this.parent = parent;
        this.size = size;
    }

    long size() {
        return this.size;
    }

    @Override
    public void write(int b) throws IOException {
        this.parent.write(b);
        ++this.size;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.parent.write(b);
        this.size += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.parent.write(b, off, len);
        this.size += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.parent.flush();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }
}

