/*
 * Decompiled with CFR 0.152.
 */
package com.vlkan.rfos;

import com.vlkan.rfos.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class SystemClock
implements Clock {
    private static final SystemClock INSTANCE = new SystemClock();
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");

    SystemClock() {
    }

    public static SystemClock getInstance() {
        return INSTANCE;
    }

    @Override
    public Instant now() {
        return Instant.now();
    }

    @Override
    public Instant midnight() {
        Instant instant = this.now();
        ZonedDateTime utcInstant = instant.atZone(UTC_ZONE_ID);
        return LocalDate.from(utcInstant).atStartOfDay().plusDays(1L).toInstant(ZoneOffset.UTC);
    }

    @Override
    public Instant sundayMidnight() {
        Instant instant = this.now();
        ZonedDateTime utcInstant = instant.atZone(UTC_ZONE_ID);
        LocalDateTime todayStart = LocalDate.from(utcInstant).atStartOfDay();
        int todayIndex = todayStart.getDayOfWeek().getValue() - 1;
        int sundayOffset = 7 - todayIndex;
        return todayStart.plusDays(sundayOffset).toInstant(ZoneOffset.UTC);
    }
}

