/*
 * Decompiled with CFR 0.152.
 */
package com.anarsoft.vmlens.concurrent.junit.internal;

import com.anarsoft.vmlens.concurrent.junit.internal.TestResult;
import com.anarsoft.vmlens.concurrent.junit.internal.TestResultAssumptionViolated;
import com.anarsoft.vmlens.concurrent.junit.internal.TestResultFailure;
import com.anarsoft.vmlens.concurrent.junit.internal.TestResultSuccess;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runners.model.Statement;

public class ConcurrentStatement {
    private final Statement statement;
    private final EachTestNotifier eachTestNotifier;
    private TestResult testResult;

    public static TestResult evaluateStatement(Statement statement) {
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            return new TestResultAssumptionViolated(e);
        }
        catch (Throwable e) {
            return new TestResultFailure(e);
        }
        return new TestResultSuccess();
    }

    public ConcurrentStatement(Statement statement, EachTestNotifier eachTestNotifier) {
        this.statement = statement;
        this.eachTestNotifier = eachTestNotifier;
    }

    public void addFailures() {
        this.testResult.addFailure(this.eachTestNotifier);
    }

    public void evaluate() {
        this.testResult = ConcurrentStatement.evaluateStatement(this.statement);
    }
}

