/*
 * Decompiled with CFR 0.152.
 */
package com.vmlens;

import com.anarsoft.race.detection.main.ProcessEvents;
import com.anarsoft.race.detection.process.run.ProcessRunContextBuilder;
import com.vmlens.report.ResultForVerify;
import com.vmlens.setup.EventDirectoryAndArgLine;
import com.vmlens.setup.Messages;
import com.vmlens.setup.SetupAgent;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.SurefireMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.shared.utils.StringUtils;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class VMLensMojo
extends SurefireMojo {
    private File eventDirectory;
    @Parameter(defaultValue="${project.build.directory}/vmlens-agent")
    protected File agentDirectory;
    @Parameter(defaultValue="${project.build.directory}/vmlens-report")
    protected File reportDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipExecution()) {
            return;
        }
        this.prepareAgent();
        MojoFailureException mojoFailureException = null;
        try {
            super.execute();
        }
        catch (MojoFailureException exp) {
            mojoFailureException = exp;
        }
        this.createReport(mojoFailureException);
    }

    private void prepareAgent() {
        EventDirectoryAndArgLine setup = new SetupAgent(this.agentDirectory, this.getArgLine()).setup();
        this.getLog().info((CharSequence)setup.argLine());
        this.setArgLine(setup.argLine());
        this.eventDirectory = setup.eventDirectory();
    }

    protected void createReport(MojoFailureException mojoFailureException) throws MojoFailureException {
        ResultForVerify result = new ProcessEvents(this.eventDirectory.toPath(), this.reportDirectory.toPath(), new ProcessRunContextBuilder().build()).process();
        if (result.noTestsRun() && this.getEffectiveFailIfNoTests()) {
            throw new MojoFailureException("No VMLens Tests run");
        }
        VMLensMojo.handleResult(result, this.reportDirectory, mojoFailureException, this.getLog());
    }

    static void handleResult(ResultForVerify result, File reportDirectory, MojoFailureException mojoFailureException, Log log) throws MojoFailureException {
        if (mojoFailureException != null) {
            log.error((CharSequence)String.format("See %s for the vmlens report.", reportDirectory.toString()));
            throw mojoFailureException;
        }
        if (result.dataRaceCount() > 0) {
            throw new MojoFailureException(Messages.dataRaces((int)result.dataRaceCount(), (File)reportDirectory));
        }
        log.info((CharSequence)String.format("See %s for the vmlens report.", reportDirectory.toString()));
    }

    private boolean isSpecificTestSpecified() {
        return StringUtils.isNotBlank((String)this.getTest());
    }

    private boolean getEffectiveFailIfNoTests() {
        if (this.isSpecificTestSpecified()) {
            return this.getFailIfNoSpecifiedTests();
        }
        return this.getFailIfNoTests();
    }
}

