/*
 * Decompiled with CFR 0.152.
 */
package com.sandstone.vparse;

import com.sandstone.vparse.SSLexCharacterClass;
import com.sandstone.vparse.SSLexDfaTableHeader;
import com.sandstone.vparse.SSLexFinalState;
import com.sandstone.vparse.SSLexKeyTable;
import com.sandstone.vparse.SSLexLexeme;
import com.sandstone.vparse.SSLexSubtable;
import com.sandstone.vparse.SSLexTableHeader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Stack;

public class SSLexTable {
    public int SSLexTableHeaderSize = 36;
    public int SSLexDfaTableHeaderSize = 40;
    public int SSLexDfaKeywordTableHeaderSize = 40;
    public int SSLexDfaClassTableHeaderSize = 12;
    public int SSLexDfaClassTableEntryHeaderSize = 8;
    public Stack m_stack;
    public int m_classes;
    public int m_classMin;
    public int m_classMax;
    public SSLexFinalState[] m_final;
    public SSLexSubtable[] m_subTables;
    public SSLexKeyTable[] m_keyTables;
    public SSLexCharacterClass[] m_charClassTables;
    public final int SSLexStateInvalid = -1;

    public int convertInt(byte[] byArray, int n) {
        return byArray[n + 3] << 24 & 0xFF000000 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF;
    }

    public SSLexTable() {
        this.m_stack = new Stack();
    }

    public SSLexTable(String string) throws FileNotFoundException, IOException {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int n4;
        int n5;
        this.m_classMin = Integer.MAX_VALUE;
        this.m_classMax = -134217726;
        this.m_stack = new Stack();
        byte[] byArray = new byte[512];
        FileInputStream fileInputStream = new FileInputStream(string);
        int n6 = fileInputStream.read(byArray, 0, this.SSLexTableHeaderSize);
        SSLexTableHeader sSLexTableHeader = new SSLexTableHeader();
        sSLexTableHeader.size = this.convertInt(byArray, 0);
        sSLexTableHeader.type = this.convertInt(byArray, 4);
        int n7 = 0;
        while (n7 < sSLexTableHeader.reserved.length) {
            sSLexTableHeader.reserved[n7] = this.convertInt(byArray, n7 * 4 + 8);
            ++n7;
        }
        this.m_subTables = new SSLexSubtable[sSLexTableHeader.size];
        n7 = 0;
        while (n7 < sSLexTableHeader.size) {
            int n8;
            int n9;
            SSLexDfaTableHeader sSLexDfaTableHeader = new SSLexDfaTableHeader();
            n6 = fileInputStream.read(byArray, 0, this.SSLexDfaTableHeaderSize);
            sSLexDfaTableHeader.type = this.convertInt(byArray, 0);
            sSLexDfaTableHeader.size = this.convertInt(byArray, 4);
            int n10 = 0;
            while (n10 < sSLexDfaTableHeader.reserved.length) {
                sSLexDfaTableHeader.reserved[n10] = this.convertInt(byArray, n10 * 4 + 8);
                ++n10;
            }
            byte[] byArray2 = new byte[sSLexDfaTableHeader.size];
            fileInputStream.read(byArray2, 0, sSLexDfaTableHeader.size - this.SSLexDfaTableHeaderSize);
            n5 = this.convertInt(byArray2, 0);
            this.convertInt(byArray2, 4);
            int n11 = this.convertInt(byArray2, 8);
            n4 = this.convertInt(byArray2, 12);
            n4 -= this.SSLexDfaTableHeaderSize;
            nArray = new int[n5 * 3];
            int n12 = 0;
            n3 = n11 -= this.SSLexDfaTableHeaderSize;
            int n13 = 0;
            while (n13 < n5) {
                n2 = this.convertInt(byArray2, n3);
                n12 += this.convertInt(byArray2, n2 -= this.SSLexDfaTableHeaderSize) * 3 + 1;
                n3 += 4;
                ++n13;
            }
            int[] nArray2 = new int[n12];
            n3 = n11;
            n2 = 0;
            n = 0;
            while (n < n5) {
                n9 = this.convertInt(byArray2, n3);
                n12 = this.convertInt(byArray2, n9 -= this.SSLexDfaTableHeaderSize);
                n9 += 4;
                nArray2[n2++] = n12;
                n8 = 0;
                while (n8 < n12) {
                    nArray2[n2++] = this.convertInt(byArray2, n9);
                    nArray2[n2++] = this.convertInt(byArray2, n9 += 4);
                    nArray2[n2++] = this.convertInt(byArray2, n9 += 4);
                    n9 += 4;
                    ++n8;
                }
                n3 += 4;
                ++n;
            }
            n = n4;
            n9 = 0;
            n8 = 0;
            while (n8 < n5) {
                int n14 = n;
                nArray[n9++] = this.convertInt(byArray2, n14);
                nArray[n9++] = this.convertInt(byArray2, n14 += 4);
                nArray[n9++] = this.convertInt(byArray2, n14 += 4);
                n += 28;
                ++n8;
            }
            this.m_subTables[n7] = new SSLexSubtable(n5, nArray2, nArray);
            ++n7;
        }
        n7 = sSLexTableHeader.reserved[0];
        if (n7 != 0) {
            this.m_keyTables = new SSLexKeyTable[n7];
        }
        int n15 = 0;
        while (n15 < n7) {
            n6 = fileInputStream.read(byArray, 0, this.SSLexDfaKeywordTableHeaderSize);
            int n16 = this.convertInt(byArray, 0);
            n5 = this.convertInt(byArray, 4);
            byte[] byArray3 = new byte[n16];
            n6 = fileInputStream.read(byArray3, 0, n16 - this.SSLexDfaKeywordTableHeaderSize);
            n4 = 0;
            nArray = new int[n5 * 3];
            String[] stringArray = new String[n5];
            n3 = 0;
            while (n3 < n5) {
                String string2;
                int n17 = 3 * n3;
                nArray[n17] = this.convertInt(byArray3, n4);
                nArray[n17 + 1] = byArray3[n4 + 4] == 0 ? 0 : 1;
                nArray[n17 + 2] = this.convertInt(byArray3, n4 + 13);
                n2 = this.convertInt(byArray3, n4 + 5) - this.SSLexDfaKeywordTableHeaderSize;
                n6 = 0;
                n = n2;
                while (byArray3[n] != 0) {
                    ++n6;
                    ++n;
                }
                stringArray[n3] = string2 = new String(byArray3, n2, n6);
                n4 += 41;
                ++n3;
            }
            this.m_keyTables[n15] = new SSLexKeyTable(nArray, stringArray);
            ++n15;
        }
        this.m_classes = sSLexTableHeader.reserved[1];
        if (this.m_classes != 0) {
            this.m_charClassTables = new SSLexCharacterClass[this.m_classes];
        }
        n15 = 0;
        while (n15 < this.m_classes) {
            n6 = fileInputStream.read(byArray, 0, this.SSLexDfaClassTableHeaderSize);
            int n18 = this.convertInt(byArray, 0);
            n5 = this.convertInt(byArray, 4);
            int n19 = this.convertInt(byArray, 8);
            n4 = n19 * this.SSLexDfaClassTableEntryHeaderSize;
            int n20 = n19 * 2;
            byte[] byArray4 = new byte[n4];
            n6 = fileInputStream.read(byArray4, 0, n4);
            int[] nArray3 = new int[n20];
            int n21 = 0;
            while (n21 < n20) {
                nArray3[n21] = this.convertInt(byArray4, n21 * 4);
                ++n21;
            }
            this.m_charClassTables[n15] = new SSLexCharacterClass(n19, n18, n5, nArray3);
            if (n18 < this.m_classMin) {
                this.m_classMin = n18;
            }
            if (n18 > this.m_classMax) {
                this.m_classMax = n18;
            }
            if (n5 < this.m_classMin) {
                this.m_classMax = n5;
            }
            if (n5 > this.m_classMax) {
                this.m_classMax = n5;
            }
            ++n15;
        }
        this.pushSubtable(0);
    }

    boolean translateClass(char[] cArray) {
        char c = cArray[0];
        if (c < this.m_classMin || c > this.m_classMax) {
            return false;
        }
        int n = 0;
        while (n < this.m_classes) {
            if (this.m_charClassTables[n].translate(cArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void pushSubtable(int n) {
        this.m_stack.push(this.m_subTables[n]);
    }

    public void popSubtable() {
        this.m_stack.pop();
    }

    public void findKeyword(SSLexLexeme sSLexLexeme) {
        int n = 0;
        int n2 = 0;
        n = this.m_keyTables[0].m_keys.length;
        while (n > n2) {
            int n3 = n2 + (n - n2) / 2;
            String string = this.m_keyTables[0].m_keys[n3];
            String string2 = new String(sSLexLexeme.lexeme());
            int n4 = this.m_keyTables[0].m_index[n3 * 3 + 1] == 1 ? string2.toLowerCase().compareTo(string) : string2.compareTo(string);
            if (n4 < 0) {
                if (n2 == n3) break;
                n = n3;
                continue;
            }
            if (n4 == 0) {
                sSLexLexeme.setToken(this.m_keyTables[0].m_index[n3 * 3]);
                return;
            }
            if (n == n3 + 1) break;
            n2 = n3;
        }
    }

    public int lookup(int n, int n2) {
        SSLexSubtable sSLexSubtable = (SSLexSubtable)this.m_stack.peek();
        return sSLexSubtable.lookup(n, n2);
    }

    public SSLexFinalState lookupFinal(int n) {
        SSLexSubtable sSLexSubtable = (SSLexSubtable)this.m_stack.peek();
        return sSLexSubtable.lookupFinal(n);
    }

    public void gotoSubtable(int n) {
        this.m_stack.pop();
        this.m_stack.push(this.m_subTables[n]);
    }
}

