/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.license;

import com.tplus.license.LicenseException;

public class LicenseMessage {
    private static final String[] errMesg = new String[]{"Unable to start license check routines", "Not a valid license file", "Unable to open file", "File read error", "File write error", "Error verifying license file", "License check failed", "Key Corruption error", "License decoding error", "License encoding error", "System clock has been set back", "License has expired or it is not valid in this machine", "Error verifying permission file", "Key file already exists", "Library is missing"};
    public static int LICENSE_CHECK_NOT_AVAILABLE = 0;
    public static int NOT_A_VALID_LICENSE_FILE = 1;
    public static int UNABLE_TO_OPEN_FILE = 2;
    public static int FILE_READ_ERROR = 3;
    public static int FILE_WRITE_ERROR = 4;
    public static int LICENSE_VERIFICATION_ERROR = 5;
    public static int LICENSE_ERROR = 6;
    public static int LICENSE_KEY_CORRUPTION = 7;
    public static int LICENSE_DECODING_ERROR = 8;
    public static int LICENSE_ENCODING_ERROR = 9;
    public static int SYSTEM_CLOCK_HAS_BEEN_SET_BACK = 10;
    public static int LICENSE_HAS_EXPIRED_OR_IT_IS_NOT_VALID_IN_THIS_MACHINE = 11;
    public static int ERROR_VERIFYING_PERMISSION_FILE = 12;
    public static int KEY_FILE_ALREADY_EXISTS = 13;
    public static int LIBRARY_IS_MISSING = 14;
    public static int LICENSE_SERVER_CONNECTION_ERROR = 101;
    static String errorMessage = null;
    static int errorCode;

    private LicenseMessage() {
    }

    public static void setError(String error, int errorcd) {
        errorMessage = error;
        errorCode = errorcd;
    }

    public static void throwError(int error) throws LicenseException {
        throw new LicenseException(error, errMesg[error]);
    }

    public static void throwError(int error, Throwable e) throws LicenseException {
        throw new LicenseException(error, errMesg[error], e);
    }

    public static void setError(int error) {
        errorMessage = errMesg[error];
        errorCode = error;
    }

    public static boolean isError() {
        return errorMessage != null;
    }

    public static String getErrorMessage() {
        if (LicenseMessage.isError()) {
            return errorMessage;
        }
        return "";
    }

    public static int getError() {
        return errorCode;
    }

    static void clearError() {
        errorMessage = null;
    }
}

