/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.CommentInfo;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignElementFindHelper;
import com.tplus.transform.design.DesignElementFindProperties;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.DiffHelper;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.DiffType;
import com.tplus.transform.design.DynaProps;
import com.tplus.transform.design.FieldAttributes;
import com.tplus.transform.design.FindMessageListener;
import com.tplus.transform.design.FormatType;
import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.PropertyInfo;
import com.tplus.transform.design.PropertyInfos;
import com.tplus.transform.design.RuntimeLocation;
import com.tplus.transform.design.ValidationHelper;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.design.platform.DatabasePlatformSpecificFieldInfo;
import com.tplus.transform.design.platform.PlatformInfoProvider;
import com.tplus.transform.design.platform.PlatformSpecificInfo;
import com.tplus.transform.design.platform.XMLPlatformSpecificFieldInfo;
import com.tplus.transform.design.xml.XMLFieldType;
import com.tplus.transform.lang.IllegalValueException;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.util.EscapedStringLiteral;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.diff.AbstractElementComparator;
import com.tplus.transform.util.diff.ListMatcher;
import com.tplus.transform.util.diff.ObjectMatch;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataField
implements DynaProps,
Serializable,
Cloneable,
RuntimeLocation,
PlatformInfoProvider {
    public static String lineSeparator = IOUtil.LINE_SEPARATOR;
    protected static Log log = LogFactory.getLog("com.tplus.transform.design");
    public static final String PLATFORM_SPECIFIC_INFO = "Platform Specific Info";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String VALUE_FIELD_NAME = "Value";
    static int mangCount;
    protected String name;
    protected String detailedName;
    private DesignerType designerType;
    private String description;
    protected String aliasName;
    protected boolean hidden;
    protected boolean disabled;
    private boolean nullable;
    private String defaultValue;
    private String format;
    protected boolean synthesized;
    protected transient String mangledName;
    protected CommentInfo comment;
    protected DataFormat parentFormat;
    Map platformSpecificInfos;
    FieldAttributes fieldAttributes = new FieldAttributes();
    private static final long serialVersionUID = -8011139532704668774L;
    public static final String Name = "Name";
    public static final String DESCRIPTION = "Description";
    public static final String ALIAS_NAME = "Alias Name";
    public static final String DETAIl_NAME = "Detail Name";
    public static final String COMMENT = "Comment";
    public static final String TYPE = "Type";
    public static final String DEFAULT_VALUE = "Default Value";
    public static final String HIDDEN = "Hidden";
    public static final String ENABLED = "Enabled";
    public static final String FORMAT = "Format";
    public static final String REQUIRED = "Required";
    public static final String stdFldPrefix = "F";
    public static final String FIELD_NAME_SEPARATOR = ".";
    public static final PropertyInfo NAME_PROPERTY;
    public static final PropertyInfo ALIAS_NAME_PROPERTY;
    public static final PropertyInfo DESCRIPTION_PROPERTY;
    public static final PropertyInfo TYPE_PROPERTY;
    public static final PropertyInfo DEFAULT_VALUE_PROPERTY;
    static PropertyInfos props;

    protected static void logassert(boolean bl, String message) {
        if (!bl) {
            log.error("Assertion failed. " + message);
        }
    }

    public DataField(String name, DesignerType type) {
        this.name = name;
        this.designerType = type;
    }

    public DataField(DataField fld) {
        this.name = fld.name;
        this.designerType = fld.designerType;
        this.description = fld.description;
    }

    public void setParentFormat(DataFormat parentFormat) {
        this.parentFormat = parentFormat;
    }

    public DataFormat getParentFormat() {
        return this.parentFormat;
    }

    public DataFieldSection getParentSection() {
        if (this.parentFormat != null) {
            return this.parentFormat.getParentSection();
        }
        return null;
    }

    public int getDepth() {
        if (this.parentFormat == null) {
            return 1;
        }
        return this.parentFormat.getDepth();
    }

    public String getLocationName() {
        return this.getQualifiedName(false);
    }

    public String getPresence() {
        int maxoccurs;
        int minoccurs = this.getMinOccurs();
        if (minoccurs == (maxoccurs = this.getMaxOccurs())) {
            return minoccurs + "";
        }
        if (maxoccurs == -1) {
            return minoccurs + "...";
        }
        return minoccurs + "..." + maxoccurs;
    }

    public boolean isSection() {
        return false;
    }

    public String getNestedRowIndex() {
        DataFormat parentFormat = this.getParentFormat();
        if (parentFormat != null) {
            int index = parentFormat.getFieldIndex(this) + 1;
            DataFieldSection parentSection = this.getParentSection();
            if (parentSection != null) {
                return parentSection.getNestedRowIndex() + FIELD_NAME_SEPARATOR + index;
            }
            return Integer.toString(index);
        }
        return "";
    }

    public List getAncestors() {
        ArrayList<DataFormat> ancestors = new ArrayList<DataFormat>();
        DataFormat root = this.parentFormat;
        while (root != null) {
            ancestors.add(root);
            DataFieldSection sec = root.getParentSection();
            if (sec == null) break;
            root = sec.getParentFormat();
        }
        return ancestors;
    }

    public DataFormat getRootFormat() {
        if (this.parentFormat != null) {
            return this.parentFormat.getRootFormat();
        }
        return null;
    }

    public boolean isAncestor(DataFormat df) {
        DataFormat root = this.parentFormat;
        while (root != null) {
            if (root == df) {
                return true;
            }
            DataFieldSection sec = root.getParentSection();
            if (sec == null) break;
            root = sec.getParentFormat();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getXPathName() {
        XMLPlatformSpecificFieldInfo info = (XMLPlatformSpecificFieldInfo)this.getOrCreatePlatformSpecificInfo("XML");
        String pName = info.getXMLName();
        return pName;
    }

    public XMLFieldType getXMLNodeType() {
        XMLPlatformSpecificFieldInfo info = (XMLPlatformSpecificFieldInfo)this.getOrCreatePlatformSpecificInfo("XML");
        return info.getXmlFieldType();
    }

    public String getXPathNamespace() {
        XMLPlatformSpecificFieldInfo info = (XMLPlatformSpecificFieldInfo)this.getOrCreatePlatformSpecificInfo("XML");
        return info.getResolvedNamespace(this);
    }

    public String getQualifiedName() {
        if (this.parentFormat != null) {
            StringBuffer toRet = new StringBuffer(64);
            this.getQualifiedName(toRet);
            return toRet.toString();
        }
        return this.name;
    }

    void getQualifiedName(StringBuffer toRet) {
        DataFieldSection sec;
        if (this.parentFormat != null && (sec = this.parentFormat.getParentSection()) != null) {
            sec.getQualifiedName(toRet);
            toRet.append(FIELD_NAME_SEPARATOR).append(this.name);
            return;
        }
        toRet.append(this.name);
    }

    public int getMaximumLength() {
        return -1;
    }

    public void setMaximumLength(int length) {
    }

    public String getQualifiedName(boolean useMangledName) {
        DataFieldSection sec;
        if (this.parentFormat != null && (sec = this.parentFormat.getParentSection()) != null) {
            return sec.getQualifiedName(useMangledName) + FIELD_NAME_SEPARATOR + (useMangledName ? this.getMangledName() : this.name);
        }
        return useMangledName ? this.getMangledName() : this.name;
    }

    public String getQualifiedAliasName() {
        DataFieldSection sec;
        String aliasName = this.getAliasName();
        if (aliasName != null) {
            return aliasName;
        }
        if (this.parentFormat != null && (sec = this.parentFormat.getParentSection()) != null) {
            return sec.getQualifiedAliasName() + FIELD_NAME_SEPARATOR + this.getMangledName();
        }
        return this.getMangledName();
    }

    public String getPreprocessedName(List accessedSections, boolean includeMandatory) {
        return this.getPreprocessedName(null, accessedSections, includeMandatory);
    }

    public String getUniqueId() {
        String toRet = "";
        DataFormat parentFormat = this.getParentFormat();
        if (parentFormat != null) {
            DataFieldSection sec = parentFormat.getParentSection();
            if (sec != null) {
                toRet = sec.getUniqueId();
            }
            int index = parentFormat.getFieldIndex(this);
            toRet = toRet + Integer.toString(index);
        }
        return toRet;
    }

    public String getPreprocessedName(DataFormat parent, List accessedSections, boolean includeMandatory) {
        return this.getPreprocessedName(parent, accessedSections, includeMandatory, false);
    }

    public String getPreprocessedName(DataFormat parent, List accessedSections, boolean includeMandatory, boolean includedNonRepeatingSections) {
        DataFieldSection sec;
        DataFormat df;
        DataField fld = this;
        StringBuffer preprocessedName = new StringBuffer();
        preprocessedName.append(fld.getMangledName());
        while (fld != null && (df = fld.getParentFormat()) != null && (sec = df.getParentSection()) != null) {
            if (sec.isRepeating() || df == parent || parent != null && parent.isAncestor(df)) {
                preprocessedName.insert(0, sec.getQualifiedName(true) + FIELD_NAME_SEPARATOR);
                break;
            }
            if (sec.isNonRepeatingMessage()) {
                fld = sec;
                if (includedNonRepeatingSections && accessedSections != null && sec.isOptional()) {
                    accessedSections.remove(sec);
                    accessedSections.add(sec);
                }
                preprocessedName.insert(0, sec.getQualifiedName(true) + FIELD_NAME_SEPARATOR + " ");
                break;
            }
            fld = sec;
            if (accessedSections != null && (sec.isOptional() || includeMandatory)) {
                accessedSections.remove(sec);
                accessedSections.add(sec);
            }
            preprocessedName.insert(0, sec.getMangledName() + "[0]" + FIELD_NAME_SEPARATOR);
        }
        return preprocessedName.toString();
    }

    public DesignerType getType() {
        return this.designerType;
    }

    public String getDisplayType() {
        return this.designerType.toString();
    }

    public FormatType getPlatformType() {
        return null;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getDetailedName() {
        return this.detailedName;
    }

    public void setDetailedName(String detailedName) {
        this.detailedName = detailedName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CommentInfo getComment() {
        return this.comment;
    }

    public void setComment(CommentInfo comment) {
        this.comment = comment;
    }

    public void setComment(String commentStr) {
        this.comment = CommentInfo.createComment(commentStr);
    }

    public void setType(DesignerType type) {
        this.designerType = type;
    }

    public void setName(String name) {
        this.name = name;
        this.mangledName = null;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public void validate(ValidationMessageListener listener) {
        this.validateFieldName(listener);
        this.validateFormat(listener);
        this.validateDefaultValue(listener);
        this.validatePlatformSpecificInfo(listener);
        this.checkMandatoryFieldInputWithDefaultValue(listener);
    }

    private void checkMandatoryFieldInputWithDefaultValue(ValidationMessageListener listener) {
        if (this.hasDefaultValue() && !this.isOptional() && this.isInputField(listener) && !this.isAutoGenerated() && this.shouldCheckMandatoryFieldDefaultValue()) {
            listener.validationMessage("", "If a field is mandatory then default value specified for it will be ignored. Field '" + this.getName() + "' is mandatory and default value has been specified.", this, DEFAULT_VALUE);
        }
    }

    protected boolean shouldCheckMandatoryFieldDefaultValue() {
        return false;
    }

    protected void validateFormat(ValidationMessageListener listener) {
        String parsingFormat = DataTypeConstants.isDateOrTimeType(this.designerType) ? this.getFormat() : null;
        try {
            if (!DataTypeConstants.isValidFormat(this.designerType, parsingFormat)) {
                listener.validationError("DF1005", "The format specified for the field '" + this.getName() + "' is not valid. Usage : Date Pattern = yy[yy] MM[M] dd;Time=HH:mm:ss.SSS", this, FORMAT);
            }
        }
        catch (IllegalArgumentException e) {
            listener.validationError("DF1005", e.getMessage() + " The format specified for the field '" + this.getName() + "' is not valid. Usage : Date Pattern = yy[yy] MM[M] dd;Time=HH:mm:ss.SSS", this, FORMAT);
        }
    }

    protected void validateDefaultValue(ValidationMessageListener listener) {
        if (this.hasDefaultValue()) {
            DesignerType type = this.getType();
            String defaultValue = this.getDefaultValue();
            try {
                String parsingFormat;
                defaultValue = EscapedStringLiteral.toJavaString(defaultValue);
                String string = parsingFormat = DataTypeConstants.isDateOrTimeType(this.designerType) ? this.getFormat() : null;
                if (parsingFormat != null) {
                    try {
                        parsingFormat = EscapedStringLiteral.toJavaString(parsingFormat);
                    }
                    catch (IllegalValueException e) {
                        listener.validationError("DF1005", "The format for field '" + this.getName() + "' is not valid " + type, this, DEFAULT_VALUE);
                    }
                }
                if (!this.isValidValue(defaultValue, parsingFormat)) {
                    if (parsingFormat == null) {
                        listener.validationError("DF1005", "The default value for field '" + this.getName() + "' cannot be converted to type " + type, this, DEFAULT_VALUE);
                    } else {
                        listener.validationError("DF1006", "The default value for field '" + this.getName() + "' cannot be converted to type " + type + ". The value '" + defaultValue + "' is not in format '" + parsingFormat + "'.", this, DEFAULT_VALUE);
                    }
                }
            }
            catch (IllegalValueException e) {
                listener.validationError("DF1005", "The default value for field '" + this.getName() + "' is not valid. " + e.getMessage(), this, DEFAULT_VALUE);
            }
        }
    }

    public boolean isValidValue(String value, String format) {
        DesignerType type = this.getType();
        return DataTypeConstants.isValidValue(type, value, format);
    }

    boolean isInputField(ValidationMessageListener listener) {
        IDesignElement elm = listener.getCurrentElement();
        if (elm != null && elm.getClass().getName().indexOf("FieldsFormat") != -1) {
            String name1;
            IDesignElement parentElm = listener.getParentElement(elm);
            if (parentElm == null) {
                parentElm = elm.getParent();
            }
            if (parentElm != null && ((name1 = parentElm.getClass().getName()).indexOf("ExternalMessage") != -1 || name1.indexOf("InputFormat") != -1)) {
                return true;
            }
        }
        return false;
    }

    protected void validateFieldName(ValidationMessageListener listener) {
        String name = this.getName();
        if (name.length() == 0) {
            listener.validationError("DF1006", "Field name cannot be empty.", this, Name);
            return;
        }
        if (name.indexOf(46) != -1 || name.indexOf(34) != -1) {
            listener.validationError("DF1006", "Invalid field name '" + this.getQualifiedName() + "'. Field name cannot contain a '.' character.", this, Name);
        }
        char first = name.charAt(0);
        char last = name.charAt(name.length() - 1);
        if (Character.isWhitespace(first) || Character.isWhitespace(last)) {
            listener.validationError("DF1006", "Invalid field name '" + this.getQualifiedName() + "'. Field name cannot start or end with a whitespace character.", this, Name);
        }
    }

    public final String toString() {
        return this.getQualifiedName();
    }

    public boolean isRequired() {
        return !this.isOptional();
    }

    public void setRequired(boolean required) {
        this.setOptional(!required);
    }

    public boolean isOptional() {
        return this.isNullable();
    }

    public boolean isRepeating() {
        return false;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setOptional(boolean optional) {
        this.setNullable(optional);
    }

    public int getMinOccurs() {
        return this.isOptional() ? 0 : 1;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        if (this.defaultValue == null) {
            this.defaultValue = "";
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    public String getFormat() {
        String format = this.format;
        if (format == null && DataTypeConstants.isDateOrTimeType(this.designerType)) {
            format = DataTypeConstants.getDefaultDateFormat(this.designerType);
        }
        return format;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setEnabled(boolean bl) {
        this.disabled = !bl;
    }

    public boolean isSynthesized() {
        return this.synthesized;
    }

    public void setSynthesized(boolean bl) {
        this.synthesized = bl;
    }

    public String getMangledName() {
        if (this.mangledName == null) {
            this.mangledName = DataField.computeMangledName(this.name);
            ++mangCount;
        }
        return this.mangledName;
    }

    public DataField getNextField() {
        DataFormat df = this.getParentFormat();
        int index = df.getFieldIndex(this);
        if (df.getFieldCountAvailable() > index + 1) {
            DataField nextField = df.getField(index + 1);
            return nextField;
        }
        return null;
    }

    public DataField getPreviousField() {
        DataFormat df = this.getParentFormat();
        int index = df.getFieldIndex(this);
        if (index > 0) {
            DataField prevField = df.getField(index - 1);
            return prevField;
        }
        return null;
    }

    public static String computeMangledName(String fldName) {
        if (!ValidationHelper.isJavaIdentifier(fldName)) {
            StringBuffer out = new StringBuffer();
            if (fldName.length() > 0 && !Character.isJavaIdentifierStart(fldName.charAt(0))) {
                out.append(stdFldPrefix);
            }
            for (int i = 0; i < fldName.length(); ++i) {
                char c = fldName.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    c = '_';
                }
                out.append(c);
            }
            return out.toString();
        }
        return fldName;
    }

    public final String getAliasName() {
        return this.aliasName;
    }

    public final void setAliasName(String aliasName) {
        if (aliasName != null && aliasName.trim().length() == 0) {
            aliasName = null;
        }
        this.aliasName = aliasName;
    }

    public Object clone() {
        try {
            DataField fld = (DataField)super.clone();
            DataField.copyFieldAttributes(fld, this);
            return fld;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static void copyFieldAttributes(DataField destFld, DataField srcFld) {
        destFld.fieldAttributes = (FieldAttributes)srcFld.fieldAttributes.clone();
    }

    public boolean isInherited() {
        return false;
    }

    public boolean isPrecedingField2(DataField field) {
        DataFormat df = field.getParentFormat();
        DataFormat thisAncestor = this.getParentFormat();
        DataField childField = this;
        while (thisAncestor != null) {
            if (thisAncestor == df) {
                int fieldIndex = df.getFieldIndex(field);
                int thisFieldIndex = thisAncestor.getFieldIndex(childField);
                if (thisFieldIndex <= fieldIndex) continue;
                return true;
            }
            childField = thisAncestor.getParentSection();
            thisAncestor = childField == null ? null : childField.getParentFormat();
        }
        return false;
    }

    public final boolean isPrecedingField(DataField field) {
        int[] thisLocation = this.getFieldLocation();
        int[] fldLocation = field.getFieldLocation();
        for (int i = 0; i < thisLocation.length; ++i) {
            if (i == fldLocation.length) {
                return true;
            }
            if (thisLocation[i] < fldLocation[i]) {
                return false;
            }
            if (thisLocation[i] <= fldLocation[i]) continue;
            return true;
        }
        return false;
    }

    public int[] getFieldLocation() {
        int[] location = new int[this.getDepth()];
        DataFormat thisAncestor = this.getParentFormat();
        DataField childField = this;
        int dep = location.length;
        while (thisAncestor != null) {
            location[--dep] = thisAncestor.getFieldIndex(childField);
            childField = thisAncestor.getParentSection();
            thisAncestor = childField == null ? null : childField.getParentFormat();
        }
        return location;
    }

    public boolean hasDefaultValue() {
        String defValue = this.getDefaultValue();
        return defValue != null && defValue.length() > 0;
    }

    public void find(DesignElementFindProperties findProperties, FindMessageListener listener) {
        DesignElementFindHelper designElementFindHelper = new DesignElementFindHelper(findProperties);
        if (!designElementFindHelper.shouldIgnore(this)) {
            FieldAttributes fieldAttributes;
            List attribs;
            designElementFindHelper.matchName(this.getName(), this, listener);
            designElementFindHelper.matchDescription(this.getDescription(), this, listener);
            if (designElementFindHelper.isShouldSearchAliasName() && designElementFindHelper.isMatch(this.getAliasName())) {
                listener.matchFound(this.getAliasName(), this, ALIAS_NAME);
            }
            if (designElementFindHelper.isShouldSearchDetailName() && designElementFindHelper.isMatch(this.getDetailedName())) {
                listener.matchFound(this.getDetailedName(), this, DETAIl_NAME);
            }
            if (!(this instanceof DataFieldSection) && designElementFindHelper.isShouldSearchDefaultValue() && designElementFindHelper.isMatch(this.getDefaultValue())) {
                listener.matchFound(this.getDefaultValue(), this, DEFAULT_VALUE);
            }
            if (!(this instanceof DataFieldSection) && designElementFindHelper.isShouldSearchOthers() && designElementFindHelper.isMatch(this.getFormat())) {
                listener.matchFound(this.getFormat(), this, FORMAT);
            }
            if (designElementFindHelper.isShouldSearchOthers() && (attribs = (fieldAttributes = this.getFieldAttributes()).getAttributes()) != null) {
                for (int i = 0; i < attribs.size(); ++i) {
                    FieldAttributes.FieldAttribute fieldAttribute = (FieldAttributes.FieldAttribute)attribs.get(i);
                    if (!designElementFindHelper.isMatch(fieldAttribute.getValue())) continue;
                    listener.matchFound(fieldAttribute.getValue(), this, "Attribute");
                }
            }
        }
    }

    public String getDescriptiveInfo() {
        StringBuffer toRet = new StringBuffer();
        if (!StringUtils.isEmpty(this.getDetailedName())) {
            toRet.append("Detail Name : ").append(this.getDetailedName()).append(lineSeparator);
        }
        if (this.getParentFormat().getParentSection() != null) {
            toRet.append("Parent       : ").append(this.getParentFormat().getParentSection().getQualifiedName()).append(lineSeparator);
        }
        toRet.append("Type         : ").append(this.getDisplayType()).append(lineSeparator);
        toRet.append("Presence : ");
        toRet.append(this.isOptional() ? "Optional" : "Mandatory");
        toRet.append(this.isRepeating() ? ", Repeatable" : "").append(lineSeparator);
        if (this.getAliasName() != null && this.getAliasName().length() > 0) {
            toRet.append("Alias         : ").append(this.getAliasName()).append(lineSeparator);
        }
        if (this.hasDefaultValue()) {
            toRet.append("Default Value : ").append(this.getDefaultValue()).append(lineSeparator);
        }
        return toRet.toString();
    }

    public void diff(DataField other, DiffMessageListener listener) {
        this.diffField(other, listener);
    }

    public void diffField(DataField other, DiffMessageListener listener) {
        if (DiffHelper.diffString(this.getName(), other.getName(), (Object)this, (Object)other, Name, listener, false)) {
            // empty if block
        }
        DiffHelper.diffString(this.getDescription(), other.getDescription(), (Object)this, (Object)other, DESCRIPTION, listener, false);
        DiffHelper.diffString(this.getDetailedName(), other.getDetailedName(), (Object)this, (Object)other, DESCRIPTION, listener, false);
        if (DiffHelper.diffString(this.getAliasName(), other.getAliasName(), (Object)this, (Object)other, ALIAS_NAME, listener, false)) {
            // empty if block
        }
        DiffHelper.diffObject(this.getComment(), other.getComment(), this, other, COMMENT, listener, false);
        DiffHelper.diffObject(this.getType(), other.getType(), this, other, TYPE, listener, false);
        if (!this.isSection()) {
            DiffHelper.diffString(this.getDefaultValue(), other.getDefaultValue(), (Object)this, (Object)other, DEFAULT_VALUE, listener, false);
            if (DataTypeConstants.isDateOrTimeType(this.getType()) && DataTypeConstants.isDateOrTimeType(other.getType())) {
                DiffHelper.diffString(DataTypeConstants.getDesignerDateFormat(this.getFormat()), DataTypeConstants.getDesignerDateFormat(other.getFormat()), (Object)this, (Object)other, FORMAT, listener, false);
            }
            DiffHelper.diffBoolean(this.isRequired(), other.isRequired(), this, other, REQUIRED, listener);
        }
        DiffHelper.diffBoolean(this.isHidden(), other.isHidden(), this, other, HIDDEN, listener);
        DiffHelper.diffBoolean(this.isEnabled(), other.isEnabled(), this, other, ENABLED, listener);
        ArrayList thisPlatformSpecificInfos = new ArrayList();
        Iterator keySetItr = this.getPlatformSpecificInfos().keySet().iterator();
        while (keySetItr.hasNext()) {
            thisPlatformSpecificInfos.add(this.getPlatformSpecificInfos().get(keySetItr.next()));
        }
        ArrayList<PlatformSpecificInfo> otherPlatformSpecificInfos = new ArrayList<PlatformSpecificInfo>();
        keySetItr = other.getPlatformSpecificInfos().keySet().iterator();
        while (keySetItr.hasNext()) {
            otherPlatformSpecificInfos.add(other.getPlatformSpecificInfo((String)keySetItr.next()));
        }
        new ListMatcher(new PlatformInfoComparator(listener, this, other)).match(thisPlatformSpecificInfos, otherPlatformSpecificInfos);
        ArrayList fieldAttrs = this.getAttributes().getAttributes();
        ArrayList othrFieldAttrs = other.getAttributes().getAttributes();
        fieldAttrs = fieldAttrs != null ? new ArrayList(fieldAttrs) : new ArrayList();
        othrFieldAttrs = othrFieldAttrs != null ? new ArrayList(othrFieldAttrs) : new ArrayList();
        new ListMatcher(new FieldAttributesComparator(listener, this, other)).match(fieldAttrs, othrFieldAttrs);
    }

    public String getTag() {
        return null;
    }

    public void set(String name, Object value) {
        if (name.equals(Name)) {
            this.setName((String)value);
        } else if (name.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (name.equals(ALIAS_NAME)) {
            this.setAliasName((String)value);
        } else if (name.equals(COMMENT)) {
            this.setComment((CommentInfo)value);
        } else if (name.equals(TYPE)) {
            this.setType((DesignerType)value);
        } else if (name.equals(DEFAULT_VALUE)) {
            this.setDefaultValue((String)value);
        } else if (name.equals(FORMAT)) {
            this.setFormat((String)value);
        } else if (name.equals(REQUIRED)) {
            this.setRequired((Boolean)value);
        } else if (name.equals(HIDDEN)) {
            this.setHidden((Boolean)value);
        } else if (name.equals(ENABLED)) {
            this.setEnabled((Boolean)value);
        }
        throw new IllegalArgumentException("Property " + name + " not supported");
    }

    public Object get(String name) {
        if (name.equals(Name)) {
            return this.getName();
        }
        if (name.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (name.equals(ALIAS_NAME)) {
            return this.getAliasName();
        }
        if (name.equals(COMMENT)) {
            return this.getComment();
        }
        if (name.equals(TYPE)) {
            return this.getType();
        }
        if (name.equals(DEFAULT_VALUE)) {
            return this.getDefaultValue();
        }
        if (name.equals(FORMAT)) {
            return this.getFormat();
        }
        if (name.equals(REQUIRED)) {
            return Wrapper.box(this.isRequired());
        }
        if (name.equals(HIDDEN)) {
            return Wrapper.box(this.isHidden());
        }
        if (name.equals(ENABLED)) {
            return Wrapper.box(this.isEnabled());
        }
        throw new IllegalArgumentException("Property " + name + " not supported");
    }

    public String getGenericName() {
        return "Field";
    }

    public boolean isIdentical(DataField fld) {
        if (!fld.getName().equals(this.getName())) {
            return false;
        }
        if (fld.getType() != this.getType()) {
            return false;
        }
        if (!StringUtils.valueEquals(fld.getDefaultValue(), this.getDefaultValue())) {
            return false;
        }
        return fld.isOptional() == this.isOptional();
    }

    public PropertyInfos getPropertyInfos() {
        return props;
    }

    private void initPlatformSpecificInfos() {
        if (this.platformSpecificInfos == null) {
            this.platformSpecificInfos = new HashMap();
        }
    }

    public String[] getDefinedPlatforms() {
        if (this.platformSpecificInfos == null || this.platformSpecificInfos.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        this.initPlatformSpecificInfos();
        return this.platformSpecificInfos.keySet().toArray(new String[this.platformSpecificInfos.size()]);
    }

    public Map getPlatformSpecificInfos() {
        this.initPlatformSpecificInfos();
        return this.platformSpecificInfos;
    }

    protected PlatformSpecificInfo getOrCreatePlatformSpecificInfo(DataField fld, String platformType) {
        PlatformSpecificInfo platformSpecificFieldInfo = fld.getPlatformSpecificInfo(platformType);
        if (platformSpecificFieldInfo == null) {
            platformSpecificFieldInfo = fld.createDefaultPlatformSpecificInfo(platformType);
        }
        return platformSpecificFieldInfo;
    }

    public void setPlatformSpecificInfos(Map infos) {
        this.platformSpecificInfos = infos;
    }

    public PlatformSpecificInfo getPlatformSpecificInfo(String platformName) {
        this.initPlatformSpecificInfos();
        return (PlatformSpecificInfo)this.platformSpecificInfos.get(platformName);
    }

    public String[] getAllPlatforms() {
        return new String[]{"Database", "XML"};
    }

    public PlatformSpecificInfo createPlatformSpecificInfo(String platformName) {
        if (platformName.equals("Database")) {
            return new DatabasePlatformSpecificFieldInfo();
        }
        if (platformName.equals("XML")) {
            return new XMLPlatformSpecificFieldInfo();
        }
        return null;
    }

    public FieldAttributes getFieldAttributes() {
        return this.fieldAttributes;
    }

    public PlatformSpecificInfo createDefaultPlatformSpecificInfo(String platformName) {
        PlatformSpecificInfo info = this.createPlatformSpecificInfo(platformName);
        if (info != null) {
            info.createDefault(this);
        }
        return info;
    }

    public void setPlatformSpecificInfo(PlatformSpecificInfo info) {
        this.setPlatformSpecificInfo(info.getPlatformName(), info);
    }

    public void setPlatformSpecificInfo(String platformName, PlatformSpecificInfo info) {
        this.initPlatformSpecificInfos();
        if (info == null) {
            this.platformSpecificInfos.remove(platformName);
        } else {
            this.platformSpecificInfos.put(platformName, info);
        }
    }

    public boolean hasPlatformInfo() {
        return this.platformSpecificInfos != null && this.getDefinedPlatforms().length > 0;
    }

    public PlatformSpecificInfo getOrCreatePlatformSpecificInfo(String platform) {
        PlatformSpecificInfo specificInfo = this.getPlatformSpecificInfo(platform);
        if (specificInfo == null) {
            specificInfo = this.createDefaultPlatformSpecificInfo(platform);
        }
        return specificInfo;
    }

    public void validatePlatformSpecificInfo(ValidationMessageListener listener) {
        if (this.platformSpecificInfos != null) {
            for (Map.Entry entry : this.platformSpecificInfos.entrySet()) {
                String platform = (String)entry.getKey();
                PlatformSpecificInfo platformSpecificInfo = (PlatformSpecificInfo)entry.getValue();
                platformSpecificInfo.validate(this, listener);
            }
        }
    }

    public FieldAttributes getAttributes() {
        return this.fieldAttributes;
    }

    public List getAllowedValues() {
        return Collections.EMPTY_LIST;
    }

    static {
        NAME_PROPERTY = new PropertyInfo("name", Name, "General"){

            public Object getValue(Object obj) {
                return ((DataField)obj).getName();
            }
        }.setDescription("Name of the field");
        ALIAS_NAME_PROPERTY = new PropertyInfo("aliasName", ALIAS_NAME, "General"){

            public Object getValue(Object obj) {
                return ((DataField)obj).getAliasName();
            }
        }.setDescription("Alias name of the field");
        DESCRIPTION_PROPERTY = new PropertyInfo("description", DESCRIPTION, "General"){

            public Object getValue(Object obj) {
                return ((DataField)obj).getDescription();
            }
        }.setDescription("Description of the field");
        TYPE_PROPERTY = new PropertyInfo("type", TYPE, "General"){

            public Object getValue(Object obj) {
                return ((DataField)obj).getType().toString();
            }
        }.setDescription("Type of the field");
        DEFAULT_VALUE_PROPERTY = new PropertyInfo("defaultValue", DEFAULT_VALUE, "General"){

            public Object getValue(Object obj) {
                return ((DataField)obj).getDefaultValue();
            }
        }.setDescription("Default value for the field");
        props = new PropertyInfos(new PropertyInfo[]{NAME_PROPERTY, ALIAS_NAME_PROPERTY, DESCRIPTION_PROPERTY, TYPE_PROPERTY, DEFAULT_VALUE_PROPERTY});
    }

    protected class FieldAttributesComparator
    extends AbstractElementComparator {
        DiffMessageListener listener = null;
        DataField field1 = null;
        DataField field2 = null;

        public FieldAttributesComparator(DiffMessageListener listener, DataField field1, DataField field2) {
            this.listener = listener;
            this.field1 = field1;
            this.field2 = field2;
        }

        public int getSimilarityIndex(Object obj1, Object obj2) {
            FieldAttributes.FieldAttribute fieldAttr1 = (FieldAttributes.FieldAttribute)obj1;
            FieldAttributes.FieldAttribute fieldAttr2 = (FieldAttributes.FieldAttribute)obj2;
            if (fieldAttr1 != null && fieldAttr2 != null && fieldAttr1.getName().equals(fieldAttr2.getName())) {
                return 0;
            }
            return -1;
        }

        public void applyMatch(ObjectMatch match) {
            FieldAttributes.FieldAttribute fieldAttr1 = (FieldAttributes.FieldAttribute)match.getElement1();
            FieldAttributes.FieldAttribute fieldAttr2 = (FieldAttributes.FieldAttribute)match.getElement2();
            this.listener.matchLocations(fieldAttr1, fieldAttr2);
            if (fieldAttr1 == null && fieldAttr2 != null) {
                this.listener.diffFound(DiffType.NEW, null, fieldAttr2.getName() + " - " + fieldAttr2.getValue(), this.field1, this.field2, "Atributes");
            } else if (fieldAttr1 != null && fieldAttr2 == null) {
                this.listener.diffFound(DiffType.DELETED, fieldAttr1.getName() + " - " + fieldAttr1.getValue(), null, this.field1, this.field2, "Atributes");
            } else if (fieldAttr1 != null && fieldAttr2 != null && fieldAttr1.getName().equals(fieldAttr2.getName()) && !StringUtils.equals(fieldAttr1.getValue(), fieldAttr2.getValue())) {
                DiffHelper.diffString(fieldAttr1.getName() + " - " + fieldAttr1.getValue(), fieldAttr2.getName() + " - " + fieldAttr2.getValue(), (Object)this.field1, (Object)this.field2, "Attributes", this.listener, false);
            }
        }
    }

    protected class PlatformInfoComparator
    extends AbstractElementComparator {
        DiffMessageListener listener = null;
        DataField field1 = null;
        DataField field2 = null;

        public PlatformInfoComparator(DiffMessageListener listener, DataField field1, DataField field2) {
            this.listener = listener;
            this.field1 = field1;
            this.field2 = field2;
        }

        public int getSimilarityIndex(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null) {
                PlatformSpecificInfo platformSpecificInfo1 = (PlatformSpecificInfo)obj1;
                PlatformSpecificInfo platformSpecificInfo2 = (PlatformSpecificInfo)obj2;
                if (platformSpecificInfo1.getPlatformName().equals(platformSpecificInfo2.getPlatformName())) {
                    return 0;
                }
            }
            return -1;
        }

        public void applyMatch(ObjectMatch match) {
            PlatformSpecificInfo platformSpecificInfo1 = (PlatformSpecificInfo)match.getElement1();
            PlatformSpecificInfo platformSpecificInfo2 = (PlatformSpecificInfo)match.getElement2();
            this.listener.matchLocations(platformSpecificInfo1, platformSpecificInfo2);
            if (platformSpecificInfo1 == null && platformSpecificInfo2 != null) {
                this.field1.getOrCreatePlatformSpecificInfo(platformSpecificInfo2.getPlatformName()).diff(platformSpecificInfo2, this.field1, this.field2, this.listener);
            } else if (platformSpecificInfo1 != null && platformSpecificInfo2 == null) {
                platformSpecificInfo1.diff(this.field2.getOrCreatePlatformSpecificInfo(platformSpecificInfo1.getPlatformName()), this.field1, this.field2, this.listener);
            } else if (platformSpecificInfo1 != null && platformSpecificInfo2 != null && platformSpecificInfo1.getPlatformName().equals(platformSpecificInfo2.getPlatformName())) {
                platformSpecificInfo1.diff(platformSpecificInfo2, this.field1, this.field2, this.listener);
            }
        }
    }
}

