/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignElementFindProperties;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.DiffHelper;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.FindMessageListener;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.design.platform.DatabasePlatformSpecificTableInfo;
import com.tplus.transform.design.platform.PlatformSpecificInfo;
import com.tplus.transform.design.platform.XMLPlatformSpecificSectionInfo;

public class DataFieldSection
extends DataField {
    public static final String MIN_OCCURS = "Min Occurs";
    public static final String MAX_OCCURS = "Max Occurs";
    public static final int UNBOUNDED = -1;
    int minOccurs = 0;
    int maxOccurs = -1;
    private DataFormat sectionFormat;
    private boolean typeReference;
    private static final long serialVersionUID = -8011139532712668774L;

    public DataFieldSection(String name) {
        super(name, DataTypeConstants.DESIGNER_SECTION_TYPE);
        this.sectionFormat = new DataFormat(name);
        this.sectionFormat.setParentSection(this);
    }

    public DataFieldSection(String name, DataFormat sectionFormat) {
        super(name, DataTypeConstants.DESIGNER_SECTION_TYPE);
        this.sectionFormat = sectionFormat;
        sectionFormat.setParentSection(this);
        sectionFormat.setName(name);
    }

    public boolean isSection() {
        return true;
    }

    public void setSectionFormat(DataFormat sectionFormat) {
        this.sectionFormat = sectionFormat;
        sectionFormat.setParentSection(this);
        sectionFormat.setName(this.name);
    }

    public void setSectionFormatFaked(DataFormat sectionFormat) {
        this.sectionFormat = sectionFormat;
    }

    public int getSectionDepth() {
        if (this.parentFormat == null) {
            return 1;
        }
        return this.parentFormat.getDepth();
    }

    public void setName(String name) {
        super.setName(name);
        this.sectionFormat.setName(name);
    }

    public void setType(DesignerType type) {
    }

    public void validate(ValidationMessageListener listener) {
        if (this.maxOccurs > 0 && this.maxOccurs < this.minOccurs) {
            listener.validationError("DF1108", "Maximum allowed occurrences for the section '" + this.getQualifiedName() + "' is less than minimum required occurences", this, MAX_OCCURS);
        }
        if (this.maxOccurs == 0 && this.maxOccurs < this.minOccurs) {
            listener.validationError("DF1109", "Maximum allowed occurrences for the section '" + this.getQualifiedName() + "' cannot be zero", this, MAX_OCCURS);
        }
        super.validateFieldName(listener);
        super.validatePlatformSpecificInfo(listener);
        this.sectionFormat.validate(listener);
    }

    public boolean isNullable() {
        return this.isOptional();
    }

    public void setNullable(boolean nullable) {
        throw new IllegalArgumentException();
    }

    public void setDefaultValue(String defaultValue) {
    }

    public void setFormat(String format) {
        throw new IllegalArgumentException();
    }

    public String getDefaultValue() {
        return null;
    }

    public String getFormat() {
        return null;
    }

    public DataFormat getSectionFormat() {
        return this.sectionFormat;
    }

    public boolean isRepeating() {
        return this.maxOccurs == -1 || this.maxOccurs > 1;
    }

    public boolean isOptional() {
        return this.minOccurs == 0;
    }

    public boolean isRequired() {
        return !this.isOptional();
    }

    public void setRepeating(boolean bl) {
        this.maxOccurs = bl ? -1 : 1;
    }

    public void setOptional(boolean bl) {
        this.setMinOccurs(bl ? 0 : 1);
    }

    public void setMinOccurs(int minOccurs) {
        if (minOccurs < 0) {
            minOccurs = 0;
        }
        this.minOccurs = minOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public Object clone() {
        DataFormat newSectionFormat;
        DataFieldSection newSec = (DataFieldSection)super.clone();
        newSec.sectionFormat = newSectionFormat = (DataFormat)this.sectionFormat.clone();
        newSec.setParentFormat(null);
        if (this.sectionFormat.getParentSection() == this) {
            newSectionFormat.setParentSection(newSec);
        }
        return newSec;
    }

    public static String getOccursText(int value) {
        if (value < 0) {
            return "Unbounded";
        }
        return Integer.toString(value);
    }

    public static int getOccursInt(String text, int defaultValue) {
        int value = defaultValue;
        if (text == null || text.trim().length() == 0) {
            return value;
        }
        if (text.equals("Unbounded")) {
            return -1;
        }
        try {
            value = Integer.parseInt(text.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public void find(DesignElementFindProperties findProperties, FindMessageListener listener) {
        super.find(findProperties, listener);
        this.sectionFormat.find(findProperties, listener);
    }

    public void diff(DataField that, DiffMessageListener listener) {
        super.diff(that, listener);
        DataFieldSection other = (DataFieldSection)that;
        DiffHelper.diffString(DataFieldSection.getOccursText(this.getMinOccurs()), DataFieldSection.getOccursText(other.getMinOccurs()), (Object)this, (Object)other, MIN_OCCURS, listener, false);
        DiffHelper.diffString(DataFieldSection.getOccursText(this.getMaxOccurs()), DataFieldSection.getOccursText(other.getMaxOccurs()), (Object)this, (Object)other, MAX_OCCURS, listener, false);
        this.sectionFormat.diff(other.sectionFormat, listener);
    }

    public boolean isNonRepeatingMessage() {
        return this.getType().isMessageType() && !this.isRepeating();
    }

    public void setNonRepeatingMessage(boolean nonRepeatingMessage) {
        if (nonRepeatingMessage) {
            super.setType(DataTypeConstants.DESIGNER_DATAOBJECT_TYPE);
        } else {
            super.setType(DataTypeConstants.DESIGNER_SECTION_TYPE);
        }
        this.setRepeating(!nonRepeatingMessage);
    }

    public boolean isTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(boolean typeReference) {
        this.typeReference = typeReference;
    }

    public String getGenericName() {
        return "Section";
    }

    public boolean isIdentical(DataField fld) {
        if (this == fld) {
            return true;
        }
        if (!(fld instanceof DataFieldSection)) {
            return false;
        }
        if (!super.isIdentical(fld)) {
            return false;
        }
        DataFieldSection sec = (DataFieldSection)fld;
        if (sec.getMinOccurs() != this.getMinOccurs()) {
            return false;
        }
        if (sec.getMaxOccurs() != this.getMaxOccurs()) {
            return false;
        }
        return this.sectionFormat.isIdentical(sec.getSectionFormat());
    }

    public PlatformSpecificInfo createPlatformSpecificInfo(String platformName) {
        if (platformName.equals("Database")) {
            return new DatabasePlatformSpecificTableInfo();
        }
        if (platformName.equals("XML")) {
            return new XMLPlatformSpecificSectionInfo();
        }
        return null;
    }

    public boolean isChoice() {
        return false;
    }
}

