/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFieldFilter;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignElement;
import com.tplus.transform.design.DesignElementFindProperties;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.DesignerTypeCategory;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.DiffType;
import com.tplus.transform.design.FieldsFormat;
import com.tplus.transform.design.FindMessageListener;
import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.MessageNormalizedFormat;
import com.tplus.transform.design.ValidationHelper;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.design.platform.XMLPlatformSpecificFieldInfo;
import com.tplus.transform.design.xml.XMLFieldType;
import com.tplus.transform.util.MultiHashMap;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.diff.AbstractElementComparator;
import com.tplus.transform.util.diff.ListMatcher;
import com.tplus.transform.util.diff.ObjectMatch;
import com.tplus.transform.util.xml.QName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DataFormat
extends DesignElement
implements Cloneable,
DesignerType {
    public static final String UNDEFINED_MESSAGE_NAME = "Undefined";
    private DataFieldSection rootSection;
    private static final String XPATH_NAME_SEPARATOR = "/";
    private static int DEPTH_MAX = 10;
    private static final int ADJUSTED_DEPTH_MAX = 6;
    private Vector dataFields = new Vector();
    List synthesizedFields;
    private DataFieldSection parentSection = null;
    private boolean supportsSection = false;
    protected String formatType = "DataFormat";
    public static final String SHOW_DESCRIPTION_DURING_VALIDATION = "SHOW_DESCRIPTION_DURING_VALIDATION";
    public static final String SHOW_DESCRIPTION_DURING_MAPPING = "SHOW_DESCRIPTION_DURING_MAPPING";
    public static final String HEADER_FORMAT_TYPE = "HeaderFormat";
    public static final String TRAILER_FORMAT_TYPE = "TrailerFormat";
    public static final String RECORD_DATA_FORMAT_TYPE = "RecordDataFormat";
    private static final long serialVersionUID = -8087809532704668884L;

    public DataFormat(String name) {
        super(name);
        this.formatType = name.equals("Header") ? HEADER_FORMAT_TYPE : (name.equals("RecordData") || name.equals("Data") ? RECORD_DATA_FORMAT_TYPE : (name.equals("Trailer") ? TRAILER_FORMAT_TYPE : RECORD_DATA_FORMAT_TYPE));
    }

    public static DataFormat getCommonAncestor(DataFormat df1, DataFormat df2) {
        for (DataFormat d1 = df1; d1 != null; d1 = d1.getParentFormat()) {
            for (DataFormat d2 = df2; d2 != null; d2 = d2.getParentFormat()) {
                if (d1 != d2) continue;
                return d1;
            }
        }
        return null;
    }

    public DataFieldSection getRootSection() {
        if (this.getParentSection() == null) {
            if (this.rootSection == null) {
                DataFormat root = new DataFormat("Root");
                this.rootSection = this.createSection(this.getName(), this);
                this.rootSection.setRepeating(false);
                this.rootSection.setOptional(false);
                root.addSection(this.rootSection);
                this.setParentSection(null);
            }
            return this.rootSection;
        }
        return this.getRootFormat().getRootSection();
    }

    public DataFieldSection getParentSectionIncludeRoot() {
        DataFieldSection parentSection = this.getParentSection();
        if (parentSection == null) {
            parentSection = this.getRootSection();
        }
        return parentSection;
    }

    public void setSectionSupported(boolean supportsSection) {
        this.supportsSection = supportsSection;
    }

    public boolean isSectionSupported() {
        return this.supportsSection;
    }

    public int getDepth() {
        if (this.parentSection == null) {
            return 1;
        }
        return this.parentSection.getSectionDepth() + 1;
    }

    public int getFieldCount() {
        return this.dataFields.size();
    }

    public List asList() {
        return Collections.unmodifiableList(this.dataFields);
    }

    public int getFieldCountAvailable() {
        return this.dataFields.size();
    }

    public int getTotalFieldCount() {
        int totalFieldCount = this.dataFields.size();
        if (this.isReference()) {
            return 0;
        }
        for (int i = 0; i < this.getFieldCountAvailable(); ++i) {
            DataField fld = this.getField(i);
            if (!(fld instanceof DataFieldSection)) continue;
            DataFieldSection sec = (DataFieldSection)fld;
            totalFieldCount += sec.getSectionFormat().getTotalFieldCount();
        }
        return totalFieldCount;
    }

    public DesignerType[] getTypes() {
        return DataTypeConstants.getFieldDataTypes();
    }

    public DesignerType getDefaultFieldType() {
        return DataTypeConstants.DESIGNER_STRING_TYPE;
    }

    public String getDefaultFieldName() {
        return "New Field";
    }

    public String getDefaultSectionName() {
        return "New Section";
    }

    public int getFieldCount(boolean ignoreDisabled) {
        return this.dataFields.size() - (ignoreDisabled ? this.getDisabledCount() : 0);
    }

    private int getDisabledCount() {
        int count = 0;
        for (int i = 0; i < this.getFieldCountAvailable(); ++i) {
            DataField fld = (DataField)this.dataFields.get(i);
            if (fld.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    public int getFormatFieldCount() {
        int count = 0;
        for (int i = 0; i < this.getFieldCountAvailable(); ++i) {
            DataField fld = this.getField(i);
            if (fld.isInherited()) continue;
            ++count;
        }
        return count;
    }

    public int getBaseFormatEndIndex() {
        for (int i = 0; i < this.getFieldCountAvailable(); ++i) {
            DataField fld = (DataField)this.dataFields.get(i);
            if (fld.isInherited()) continue;
            return i - 1;
        }
        return this.getFieldCountAvailable() - 1;
    }

    public void removeInheritedFields() {
        int index = this.getBaseFormatEndIndex();
        if (index != -1) {
            ListIterator it = this.dataFields.listIterator(0);
            int n = index;
            for (int i = 0; i < n; ++i) {
                it.next();
                it.remove();
            }
        }
    }

    public DataField getField(int index) {
        return (DataField)this.dataFields.get(index);
    }

    public int getFieldIndex(DataField toFind) {
        int count = this.getFieldCountAvailable();
        for (int i = 0; i < count; ++i) {
            DataField fld = this.getField(i);
            if (fld != toFind) continue;
            return i;
        }
        return -1;
    }

    public DataField getField(String name) {
        return this.getField(name, 0);
    }

    public DataField getField(String name, int searchFrom) {
        int index = this.findField(name, searchFrom);
        if (index != -1) {
            return this.getField(index);
        }
        return null;
    }

    public DataFieldSection getSection(String name, int searchFrom) {
        DataField fld = this.getField(name, searchFrom);
        if (fld instanceof DataFieldSection) {
            return (DataFieldSection)fld;
        }
        return null;
    }

    public DataFieldSection getSection(String name) {
        return this.getSection(name, 0);
    }

    public DataField findFieldWithAliasName(String name, boolean recurse) {
        if (this.isReference()) {
            return null;
        }
        int count = this.getFieldCountAvailable();
        for (int i = 0; i < count; ++i) {
            DataFieldSection sec;
            DataField fld;
            DataField f = this.getField(i);
            String alias = f.getAliasName();
            if (alias != null && alias.equals(name)) {
                return f;
            }
            if (!recurse || !(f instanceof DataFieldSection) || (fld = (sec = (DataFieldSection)f).getSectionFormat().findFieldWithAliasName(name, true)) == null) continue;
            return fld;
        }
        return null;
    }

    public DataField findFieldWithAliasName(String name) {
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            DataField fld = this.getField(i);
            String alias = fld.getAliasName();
            if (alias == null || !alias.equals(name)) continue;
            return fld;
        }
        return null;
    }

    public DataField getQualifiedField(String name) {
        return this.getQualifiedField(name, false);
    }

    public DataField getQualifiedField(String name, boolean includeMangledName) {
        return this.getQualifiedField(name, includeMangledName, this.isRootFormat());
    }

    public DataField getQualifiedField(String name, boolean includeMangledName, boolean useRootAlias) {
        if (name == null) {
            return null;
        }
        String fldName = name;
        String rest = null;
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            fldName = name.substring(0, dotIndex);
            rest = name.substring(dotIndex + 1);
        }
        DataField aliasFld = null;
        DataField fld = this.getField(fldName, includeMangledName);
        if (useRootAlias && fld == null) {
            aliasFld = this.findFieldWithAliasName(fldName, true);
        }
        DataFormat.logassert(fld == null || aliasFld == null, "Matched an alias name as well as a field name " + fldName);
        DataField dataField = fld = aliasFld != null ? aliasFld : fld;
        if (fld != null) {
            if (rest == null) {
                return fld;
            }
            if (fld instanceof DataFieldSection) {
                DataFieldSection section = (DataFieldSection)fld;
                return section.getSectionFormat().getQualifiedField(rest, includeMangledName, false);
            }
        }
        return null;
    }

    public DataField getField(String name, boolean includeMangledName) {
        int index = this.findField(name, includeMangledName);
        if (index != -1) {
            return this.getField(index);
        }
        return null;
    }

    public DataField createField(String name, String type) {
        return this.createField(name, this.getDesignerType(type));
    }

    public DataField createField(String name, DesignerType type) {
        DataField nf = new DataField(name, type);
        return nf;
    }

    public DataFieldSection createSection(String name) {
        DataFieldSection nf = new DataFieldSection(name);
        return nf;
    }

    public DataFieldSection createSection(String name, DataFormat df) {
        DataFieldSection nf = new DataFieldSection(name, df);
        return nf;
    }

    public DataField addField(String name, DesignerType type, int index) {
        DataField nf = this.createField(name, type);
        nf.setParentFormat(this);
        this.dataFields.add(index, nf);
        return nf;
    }

    public DataFieldSection addSection(String name, int index) {
        DataFieldSection sec = this.createSection(name);
        sec.setParentFormat(this);
        if (index < this.dataFields.size()) {
            this.dataFields.add(index, sec);
        } else {
            this.dataFields.add(sec);
        }
        return sec;
    }

    public void addField(DataField fld, int index) {
        fld.setParentFormat(this);
        this.addFieldAt(fld, index);
    }

    private void addFieldAt(DataField fld, int index) {
        if (index < this.dataFields.size() && index >= 0) {
            this.dataFields.add(index, fld);
        } else {
            this.dataFields.add(fld);
        }
    }

    public void addSection(DataFieldSection fld, int index) {
        fld.setParentFormat(this);
        this.addFieldAt(fld, index);
    }

    public void addField(DataField fld) {
        fld.setParentFormat(this);
        this.dataFields.add(fld);
    }

    public DataField addField(String name, DesignerType type) {
        DataField nf = this.createField(name, type);
        nf.setParentFormat(this);
        this.dataFields.add(nf);
        return nf;
    }

    public DataField addField(String name, String type) {
        DataField nf = this.createField(name, type);
        nf.setParentFormat(this);
        this.dataFields.add(nf);
        return nf;
    }

    public void addSection(DataFieldSection fld) {
        fld.setParentFormat(this);
        this.dataFields.add(fld);
    }

    public DataFieldSection addSection(String name) {
        DataFieldSection nf = this.createSection(name);
        nf.setParentFormat(this);
        this.dataFields.add(nf);
        return nf;
    }

    public boolean removeField(String name) {
        int index = this.findField(name);
        if (index != -1) {
            this.dataFields.remove(index);
            return true;
        }
        return false;
    }

    public boolean swapField(int index, int newIndex) {
        if (newIndex < 0 || index < 0) {
            return false;
        }
        if (newIndex >= this.dataFields.size() || index >= this.dataFields.size()) {
            return false;
        }
        Object obj = this.dataFields.get(newIndex);
        this.dataFields.set(newIndex, this.dataFields.get(index));
        this.dataFields.set(index, obj);
        return true;
    }

    public static void moveField(DataField fld, int toAddIndex) {
        DataFormat parentFormat = fld.getParentFormat();
        int foundIndex = parentFormat.getFieldIndex(fld);
        if (foundIndex != toAddIndex && !parentFormat.moveField(foundIndex, toAddIndex)) {
            log.error("Cannot move field", new Exception());
        }
    }

    public boolean moveField(int index, int newIndex) {
        if (newIndex < 0) {
            return false;
        }
        if (newIndex >= this.dataFields.size()) {
            return false;
        }
        Object obj = this.dataFields.remove(index);
        this.dataFields.add(newIndex, obj);
        return true;
    }

    protected void getFieldsWithAliasName(List toAdd) {
        int count = this.getFieldCountAvailable();
        for (int i = 0; i < count; ++i) {
            DataField fld = (DataField)this.dataFields.get(i);
            String aliasName = fld.getAliasName();
            if (aliasName != null) {
                toAdd.add(fld);
            }
            if (!(fld instanceof DataFieldSection)) continue;
            DataFieldSection sec = (DataFieldSection)fld;
            sec.getSectionFormat().getFieldsWithAliasName(toAdd);
        }
    }

    public Set getTopLevelFieldNames() {
        HashSet<String> names = new HashSet<String>();
        int count = this.getFieldCountAvailable();
        for (int i = 0; i < count; ++i) {
            DataField fld = (DataField)this.dataFields.get(i);
            names.add(fld.getName());
        }
        return names;
    }

    protected void validateAliasNames(ValidationMessageListener listener) {
        ArrayList fields = new ArrayList();
        this.getFieldsWithAliasName(fields);
        HashSet<String> allNames = new HashSet<String>();
        Set fieldNames = this.getTopLevelFieldNames();
        for (int i = 0; i < fields.size(); ++i) {
            DataField fld = (DataField)fields.get(i);
            String aliasName = fld.getAliasName();
            if (aliasName == null) continue;
            if (fieldNames.contains(aliasName)) {
                listener.validationError("", "The alias name used for for the field '" + fld.getName() + "'" + (this.isRootFormat() ? "" : " in section '" + this.getQualifiedName() + "'") + " is same as the name of a top-level field.", fld, "Alias Name");
            } else if (allNames.contains(aliasName)) {
                listener.validationError("", "Duplicate alias name for field '" + fld.getName() + "'" + (this.isRootFormat() ? "" : " in section '" + this.getQualifiedName() + "'"), fld, "Alias Name");
            } else {
                ValidationHelper.checkJavaIdentifier(aliasName, listener, "Alias name for field " + fld.getQualifiedName(), fld, "Alias Name");
            }
            allNames.add(aliasName);
        }
    }

    public void validate(ValidationMessageListener listener) {
        if (this.isRootFormat()) {
            this.validateAliasNames(listener);
        }
        this.checkDuplicateFields(listener);
        int count = this.getFieldCountAvailable();
        for (int i = 0; i < count; ++i) {
            DataField fld = (DataField)this.dataFields.get(i);
            fld.validate(listener);
        }
    }

    public void checkDuplicateFields(ValidationMessageListener listener) {
        int count = this.getFieldCount();
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            DataField fld = this.getField(i);
            if (nameSet.contains(fld.getName())) {
                listener.validationError("DF1004", "Duplicate field '" + fld.getName() + "'" + (this.isRootFormat() ? "" : " in section '" + this.getQualifiedName() + "'"), fld, null);
            }
            nameSet.add(fld.getName());
        }
    }

    public String getQualifiedName() {
        if (this.parentSection != null) {
            return this.parentSection.getQualifiedName();
        }
        return "";
    }

    public void removeField(int index) {
        this.dataFields.remove(index);
    }

    public boolean removeField(DataField fld) {
        return this.dataFields.remove(fld);
    }

    public void removeAllFields() {
        this.dataFields.clear();
    }

    public int findField(String name) {
        return this.findField(name, 0);
    }

    public int findField(String name, int searchForm) {
        if (name == null) {
            return -1;
        }
        for (int i = searchForm; i < this.dataFields.size(); ++i) {
            DataField nf = (DataField)this.dataFields.get(i);
            if (!nf.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int findField(String name, boolean includeMangledName) {
        if (name == null) {
            return -1;
        }
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            DataField nf = this.getField(i);
            if (nf.getName().equals(name)) {
                return i;
            }
            if (!includeMangledName || !nf.getMangledName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(DataField fld) {
        return this.dataFields.contains(fld);
    }

    public boolean contains(DataField fld, boolean checkChildren) {
        DataField currentField = fld;
        DataFormat parentFormat = currentField.getParentFormat();
        while (parentFormat != null && parentFormat.contains(currentField)) {
            if (parentFormat == this) {
                return true;
            }
            currentField = parentFormat.getParentSection();
            if (currentField == null) {
                return false;
            }
            parentFormat = currentField.getParentFormat();
        }
        return false;
    }

    public DataFieldSection getParentSection() {
        return this.parentSection;
    }

    public void setParentSection(DataFieldSection parentSection) {
        this.parentSection = parentSection;
    }

    public DataFormat getParentFormat() {
        if (this.parentSection != null) {
            return this.parentSection.getParentFormat();
        }
        return null;
    }

    public DataFormat getRootFormat() {
        if (this.parentSection != null) {
            DataFormat dataFormat = this.parentSection.getRootFormat();
            if (dataFormat == null) {
                return this;
            }
            return dataFormat;
        }
        return this;
    }

    public boolean isOrphanedFormat() {
        if (this.parentSection != null) {
            DataFormat dataFormat = this.parentSection.getParentFormat();
            if (dataFormat == null) {
                return true;
            }
            return dataFormat.isOrphanedFormat();
        }
        return false;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        for (int i = 0; i < this.dataFields.size(); ++i) {
            DataField nf = (DataField)this.dataFields.get(i);
            nf.setParentFormat(this);
        }
    }

    public boolean isAncestor(DataFormat df) {
        if (this.parentSection != null) {
            DataFormat parentFormat = this.parentSection.getParentFormat();
            if (parentFormat == df) {
                return true;
            }
            if (parentFormat != null) {
                return parentFormat.isAncestor(df);
            }
        }
        return false;
    }

    public static boolean isFieldInHierarchy(DataField base, DataField accessed) {
        return DataFormat.isFieldInHierarchy(base == null ? null : base.getParentFormat(), accessed);
    }

    public static boolean isFieldInHierarchy(DataFormat base, DataField accessed) {
        DataFieldSection baseSection;
        DataFieldSection accessedSection = accessed.getParentFormat().getParentSection();
        DataFieldSection dataFieldSection = baseSection = base == null ? null : base.getParentSection();
        if (baseSection == accessedSection) {
            return true;
        }
        return DataFormat.isParent(accessedSection, baseSection);
    }

    public static boolean isSiblings(DataField field1, DataField field2) {
        return field1.getParentFormat() == field2.getParentFormat();
    }

    public static boolean isParent(DataFieldSection parent, DataFieldSection child) {
        if (child == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        DataFieldSection temp = child.getParentFormat().getParentSection();
        while (temp != null) {
            if (temp == parent) {
                return true;
            }
            temp = temp.getParentFormat().getParentSection();
        }
        return false;
    }

    public Iterator fieldIterator() {
        return this.dataFields.iterator();
    }

    public Iterator inOrderIterator() {
        return this.inOrderIterator(0);
    }

    public List getAllFields() {
        return DataFormat.getAllFields(this);
    }

    static List getAllFields(DataFormat df) {
        HashSet references = new HashSet();
        ArrayList allFields = new ArrayList();
        DataFormat.getAllFields(df, references, allFields, df.getDepth());
        return allFields;
    }

    public static DataFormat getReferenceFormat(DataFormat src) {
        DataFormat ref;
        for (ref = src; ref != null && ref.isReference(); ref = ref.getReferenceFormat()) {
        }
        return ref == null ? src : ref;
    }

    static void getAllFields(DataFormat df, Set references, List allFields) {
        int fieldCount = df.getFieldCountAvailable();
        DataFormat srcReference = null;
        if (df.isReference()) {
            srcReference = DataFormat.getReferenceFormat(df);
            if (references.contains(srcReference)) {
                log.warn("Ignoring recursive field " + srcReference.getQualifiedName());
                return;
            }
            fieldCount = df.getFieldCount();
            references.add(srcReference);
        }
        for (int i = 0; i < fieldCount; ++i) {
            DataField fld = df.getField(i);
            allFields.add(fld);
            if (!(fld instanceof DataFieldSection)) continue;
            DataFieldSection sec = (DataFieldSection)fld;
            DataFormat.getAllFields(sec.getSectionFormat(), references, allFields);
        }
        if (srcReference != null) {
            references.remove(srcReference);
        }
    }

    private static void getAllFields(DataFormat df, Set references, List allFields, int depth) {
        int fieldCount = df.getFieldCountAvailable();
        DataFormat srcReference = null;
        if ((depth < DEPTH_MAX || fieldCount > 0) && df.isReference()) {
            srcReference = DataFormat.getReferenceFormat(df);
            if (references.contains(srcReference)) {
                DEPTH_MAX = 6;
                return;
            }
            if (depth < DEPTH_MAX) {
                fieldCount = df.getFieldCount();
            }
            references.add(srcReference);
        }
        for (int i = 0; i < fieldCount; ++i) {
            DataField fld = df.getField(i);
            allFields.add(fld);
            if (!(fld instanceof DataFieldSection)) continue;
            DataFieldSection sec = (DataFieldSection)fld;
            DataFormat.getAllFields(sec.getSectionFormat(), references, allFields, depth + 1);
        }
        if (srcReference != null) {
            references.remove(srcReference);
        }
    }

    public List getAllFields(DataFieldFilter filter) {
        List allFields = this.getAllFields();
        Iterator iterator = allFields.iterator();
        while (iterator.hasNext()) {
            DataField dataField = (DataField)iterator.next();
            if (filter.isMatch(dataField)) continue;
            iterator.remove();
        }
        return allFields;
    }

    public Iterator inOrderIterator(int startIndex) {
        return new InOrderIterator(this, startIndex);
    }

    public List getFields() {
        return Collections.unmodifiableList(this.dataFields);
    }

    public List getFieldNames() {
        ArrayList<String> toRet = new ArrayList<String>();
        for (int i = 0; i < this.dataFields.size(); ++i) {
            DataField dataField = (DataField)this.dataFields.get(i);
            toRet.add(dataField.getName());
        }
        return toRet;
    }

    public DesignerType getDesignerType(String type) {
        DesignerType[] types = this.getTypes();
        return DataFormat.getDesignerType(types, type);
    }

    public static DesignerType getDesignerType(DesignerType[] types, String type) {
        type = DataTypeConstants.fixDesignerType(type);
        for (int i = 0; i < types.length; ++i) {
            DesignerType designerType = types[i];
            if (!designerType.getName().equals(type)) continue;
            return designerType;
        }
        if (DataTypeConstants.isSectionType(type)) {
            return DataTypeConstants.DESIGNER_SECTION_TYPE;
        }
        if (DataTypeConstants.DESIGNER_DATAOBJECT_TYPE.toString().equals(type)) {
            return DataTypeConstants.DESIGNER_DATAOBJECT_TYPE;
        }
        throw new IllegalArgumentException("Unrecognized designer type '" + type + "'");
    }

    public boolean isIdentical(DataFormat sectionFormat) {
        if (this == sectionFormat) {
            return true;
        }
        if (this.getFieldCount() != sectionFormat.getFieldCount()) {
            return false;
        }
        for (int i = 0; i < this.dataFields.size(); ++i) {
            DataField nf2;
            DataField nf1 = (DataField)this.dataFields.get(i);
            if (nf1.isIdentical(nf2 = (DataField)sectionFormat.dataFields.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isReference() {
        return false;
    }

    public DataFormat getReferenceFormat() {
        return null;
    }

    public void replaceField(DataField fld1, DataField fld2) {
        int index = this.getFieldIndex(fld1);
        if (index != -1) {
            fld2.setParentFormat(this);
            this.dataFields.set(index, fld2);
        }
    }

    public void resolveAllReferences() {
    }

    public boolean isDynamicFormat() {
        return false;
    }

    public boolean isSectionType() {
        return true;
    }

    public boolean isMessageType() {
        return false;
    }

    public boolean isListType() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isValidValue(String value, String format) {
        return false;
    }

    public boolean isValidFormat(String parsingFormat) throws IllegalArgumentException {
        return true;
    }

    public String getDefaultFormat() {
        throw new IllegalArgumentException("Not a date type " + this);
    }

    public String getCanonicalFormat() {
        return this.getDefaultFormat();
    }

    public boolean isNumeric() {
        return false;
    }

    public DesignerTypeCategory getTypeCategory() {
        return DesignerTypeCategory.MESSAGE;
    }

    public void write(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.dataFields);
        oos.writeObject(this.parentSection);
        oos.writeBoolean(this.supportsSection);
    }

    public void read(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.dataFields = (Vector)ois.readObject();
        this.parentSection = (DataFieldSection)ois.readObject();
        this.supportsSection = ois.readBoolean();
    }

    public String getFormatType() {
        if (this.formatType == null) {
            this.formatType = RECORD_DATA_FORMAT_TYPE;
        }
        return this.formatType;
    }

    public void setFormatType(String type) {
        this.formatType = type;
    }

    public void setSynthesizedFields(List synthesizedFields) {
        this.synthesizedFields = synthesizedFields;
    }

    public List getSynthesizedFields() {
        if (this.synthesizedFields == null) {
            this.synthesizedFields = new ArrayList();
        }
        return this.synthesizedFields;
    }

    public void addSynthesizeFields() {
        if (this.synthesizedFields != null) {
            for (int i = 0; i < this.synthesizedFields.size(); ++i) {
                DataField fld = (DataField)this.synthesizedFields.get(i);
                fld.setParentFormat(this);
                this.dataFields.add(fld);
            }
        }
    }

    public void removeSynthesizeFields() {
        if (this.synthesizedFields != null) {
            for (int i = 0; i < this.synthesizedFields.size(); ++i) {
                DataField fld = (DataField)this.synthesizedFields.get(i);
                this.dataFields.remove(fld);
            }
        }
    }

    public boolean hasChildSection() {
        for (int i = 0; i < this.getFieldCountAvailable(); ++i) {
            DataField fld = this.getField(i);
            if (!(fld instanceof DataFieldSection)) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            DataFormat fmt = (DataFormat)super.clone();
            fmt.dataFields = new Vector();
            for (int i = 0; i < this.dataFields.size(); ++i) {
                DataField fld = (DataField)this.dataFields.get(i);
                fmt.addField((DataField)fld.clone());
            }
            return fmt;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean isRootFormat() {
        return this.parentSection == null;
    }

    Map prepareAliasNameMap() {
        HashMap map = new HashMap();
        this.prepareAliasNameMap(map);
        return map;
    }

    void prepareAliasNameMap(Map nameMap) {
        DataField fld;
        int i;
        int count = this.getFieldCountAvailable();
        for (i = 0; i < count; ++i) {
            fld = (DataField)this.dataFields.get(i);
            String aliasName = fld.getAliasName();
            if (aliasName == null) continue;
            nameMap.put(aliasName, fld);
        }
        for (i = 0; i < count; ++i) {
            fld = (DataField)this.dataFields.get(i);
            if (!(fld instanceof DataFieldSection)) continue;
            DataFieldSection sec = (DataFieldSection)fld;
            sec.getSectionFormat().prepareAliasNameMap(nameMap);
        }
    }

    Map prepareNameMap() {
        MultiHashMap map = new MultiHashMap();
        this.prepareNameMap(map);
        return map;
    }

    void prepareNameMap(Map nameMap) {
        DataField fld;
        int i;
        int count = this.getFieldCount();
        for (i = 0; i < count; ++i) {
            fld = (DataField)this.dataFields.get(i);
            String name = fld.getName();
            if (name == null) continue;
            nameMap.put(name, fld);
        }
        for (i = 0; i < count; ++i) {
            fld = (DataField)this.dataFields.get(i);
            if (!(fld instanceof DataFieldSection)) continue;
            DataFieldSection sec = (DataFieldSection)fld;
            sec.getSectionFormat().prepareNameMap(nameMap);
        }
    }

    String getPreferredAliasName(DataField fld, Map nameMap, Map aliasNameMap) {
        String name = fld.getName();
        List sameNameFields = (List)nameMap.get(name);
        if (sameNameFields.size() == 1) {
            DataField assignedField = (DataField)aliasNameMap.get(name);
            if (!this.isAliasNameInUse(name, aliasNameMap, fld)) {
                return name;
            }
        }
        return null;
    }

    boolean isAliasNameInUse(String name, Map aliasNameMap, DataField fld) {
        DataField assignedField = (DataField)aliasNameMap.get(name);
        return assignedField != null && assignedField != fld;
    }

    public int findTrailingFieldIndex() {
        int trailingFieldIndex = -1;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            DataField fld = this.getField(i);
            if (fld.isRequired()) {
                trailingFieldIndex = -1;
                continue;
            }
            if (trailingFieldIndex != -1) continue;
            trailingFieldIndex = i;
        }
        return trailingFieldIndex;
    }

    public void find(DesignElementFindProperties findProperties, FindMessageListener listener) {
        int count = this.getFieldCountAvailable();
        for (int i = 0; i < count; ++i) {
            DataField fld = (DataField)this.dataFields.get(i);
            fld.find(findProperties, listener);
        }
    }

    public void diff(IDesignElement with, DiffMessageListener listener) {
        DataFormat other = (DataFormat)with;
        if (this.getFieldCountAvailable() > 0 || other.getFieldCountAvailable() > 0) {
            DataFormat.resolveFormat(this);
            DataFormat.resolveFormat(other);
        }
        ArrayList fields1 = new ArrayList(this.getFields());
        ArrayList fields2 = new ArrayList(other.getFields());
        new ListMatcher(new DataFieldComparator(listener)).match(fields1, fields2);
    }

    public static void resolveFormat(DataFormat df) {
        int fieldCount1 = df.getFieldCount();
        if (fieldCount1 > 0) {
            df.getField(0);
        }
    }

    public static void moveFields(DataFormat srcFormat, DataFormat destFormat, int destStartIndex) {
        DataFormat.moveFields(srcFormat, 0, srcFormat.getFieldCountAvailable(), destFormat, destStartIndex);
    }

    public static void moveFields(DataFormat srcFormat, int srcStartIndex, int srcEndIndex, DataFormat destFormat, int destStartIndex) {
        srcStartIndex = Math.max(0, srcStartIndex);
        srcEndIndex = Math.min(srcFormat.getFieldCountAvailable(), srcEndIndex);
        destStartIndex = Math.min(destFormat.getFieldCountAvailable(), destStartIndex);
        int i = srcStartIndex;
        int j = 0;
        while (i < srcEndIndex) {
            DataField fld = srcFormat.getField(i);
            destFormat.addField(fld, destStartIndex + j);
            ++i;
            ++j;
        }
        srcFormat.removeFields(srcStartIndex, srcEndIndex);
    }

    public void removeFields(int srcStartIndex, int srcEndIndex) {
        srcStartIndex = Math.max(0, srcStartIndex);
        srcEndIndex = Math.min(this.getFieldCount(), srcEndIndex);
        this.dataFields.subList(srcStartIndex, srcEndIndex).clear();
    }

    public DataFormat getOriginalFormat() {
        return this;
    }

    public static DataField getOriginalField(DataField fld) {
        DataFormat parentFormat;
        DataFormat originalFormat;
        if (fld != null && (originalFormat = (parentFormat = fld.getParentFormat()).getOriginalFormat()) != parentFormat) {
            DataField originalField = originalFormat.getField(fld.getName());
            return originalField;
        }
        return fld;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean canAssignFrom(DataFormat other) {
        if (other == null) {
            return false;
        }
        DataFormat otherFmt = other.getOriginalFormat();
        DataFormat thisFmt = this.getOriginalFormat();
        return thisFmt.equals(otherFmt) || thisFmt.isUndefinedMessage() || otherFmt.isUndefinedMessage();
    }

    boolean isUndefinedMessage() {
        return this.getName().equals(UNDEFINED_MESSAGE_NAME);
    }

    public boolean isAssignableFrom(DesignerType srcType) {
        if (srcType instanceof DataFormat) {
            return this.canAssignFrom((DataFormat)srcType);
        }
        return this.equals(srcType);
    }

    public Object getLocationFromString(String str) {
        DataField location = this.getQualifiedField(str, true);
        return location;
    }

    public String getStringFromLocation(Object location) {
        if (location instanceof DataField) {
            return ((DataField)location).getQualifiedName();
        }
        return null;
    }

    public QName getMessageXPathName() {
        DataFormat root = this;
        Object prefix = null;
        if (root instanceof MessageNormalizedFormat) {
            XMLPlatformSpecificFieldInfo platformSpecificInfo = (XMLPlatformSpecificFieldInfo)root.getRootSection().getOrCreatePlatformSpecificInfo("XML");
            return new QName(platformSpecificInfo.getResolvedNamespace(this), platformSpecificInfo.getXMLName());
        }
        IDesignElement designElement = root.getParent();
        if (designElement instanceof FieldsFormat) {
            FieldsFormat fieldsFormat = (FieldsFormat)designElement;
            MessageNormalizedFormat normalizedFormat = fieldsFormat.getNormalizedFormat();
            XMLPlatformSpecificFieldInfo platformSpecificInfo = (XMLPlatformSpecificFieldInfo)normalizedFormat.getRootSection().getOrCreatePlatformSpecificInfo("XML");
            return new QName(platformSpecificInfo.getResolvedNamespace(this), platformSpecificInfo.getXMLName());
        }
        return null;
    }

    public QName getMessageSubXPathName() {
        DataFormat root = this;
        Object prefix = null;
        if (root instanceof MessageNormalizedFormat) {
            return null;
        }
        IDesignElement designElement = root.getParent();
        if (designElement instanceof FieldsFormat) {
            XMLPlatformSpecificFieldInfo platformSpecificInfo = (XMLPlatformSpecificFieldInfo)root.getRootSection().getOrCreatePlatformSpecificInfo("XML");
            return new QName(platformSpecificInfo.getResolvedNamespace(this), platformSpecificInfo.getXMLName());
        }
        return null;
    }

    public DataField getQualifiedXPathField(String xPathQName) {
        QName mesSubName;
        int index;
        String[] strings = StringUtils.split(xPathQName, XPATH_NAME_SEPARATOR);
        QName mesName = this.getMessageXPathName();
        if (this.isNameMatch(mesName, strings[index = 0])) {
            ++index;
        }
        if ((mesSubName = this.getMessageSubXPathName()) != null && this.isNameMatch(mesName, strings[index])) {
            ++index;
        }
        DataField match = null;
        DataFormat current = this;
        for (int i = index; i < strings.length; ++i) {
            String string;
            if (match != null && match instanceof DataFieldSection) {
                DataFieldSection dataFieldSection = (DataFieldSection)match;
                current = dataFieldSection.getSectionFormat();
            }
            if ((match = current.findXPathChild(string = strings[i], null)) != null) continue;
            System.out.println("MIS:" + string + " in " + current.getName());
            break;
        }
        return match;
    }

    private boolean isNameMatch(QName mesName, String string) {
        return mesName.getLocalPart().equals(string);
    }

    public DataField findXPathChild(String xPathName, String xPathNamespace) {
        for (int i = 0; i < this.getFieldCount(); ++i) {
            DataFieldSection dataFieldSection;
            DataField child;
            DataField field = this.getField(i);
            XMLFieldType xmlNodeType = field.getXMLNodeType();
            if (xmlNodeType == XMLFieldType.GROUP && field instanceof DataFieldSection && (child = (dataFieldSection = (DataFieldSection)field).getSectionFormat().findXPathChild(xPathName, xPathNamespace)) != null) {
                return child;
            }
            if (!field.getXPathName().equals(xPathName) || xPathNamespace != null && field.getXPathNamespace() != null && !field.getXPathNamespace().equals(xPathNamespace)) continue;
            return field;
        }
        return null;
    }

    protected class DataFieldComparator
    extends AbstractElementComparator {
        private DiffMessageListener listener;

        public DataFieldComparator(DiffMessageListener listener) {
            this.listener = listener;
        }

        public int getSimilarityIndex(Object obj1, Object obj2) {
            DataField fld1 = (DataField)obj1;
            DataField fld2 = (DataField)obj2;
            if (fld1.getName().equals(fld2.getName())) {
                return 0;
            }
            if (fld1.getType().equals(fld2.getType())) {
                // empty if block
            }
            return -1;
        }

        public void applyMatch(ObjectMatch match) {
            DataField fld1 = (DataField)match.getElement1();
            DataField fld2 = (DataField)match.getElement2();
            this.listener.matchLocations(fld1, fld2);
            if (fld1 != null && fld2 != null) {
                fld1.diff(fld2, this.listener);
            } else if (fld1 == null) {
                this.listener.diffFound(DiffType.NEW, null, null, fld1, fld2, null);
            } else {
                this.listener.diffFound(DiffType.DELETED, null, null, fld1, fld2, null);
            }
        }
    }

    public class InOrderIterator
    implements Iterator {
        DataFormat rootFormat;
        DataFormat currentFormat;
        int currentIndex;
        Object nextElement;
        boolean descendSection = true;

        InOrderIterator(DataFormat rootFormat, int startIndex) {
            this.rootFormat = rootFormat;
            this.currentFormat = rootFormat;
            this.currentIndex = startIndex;
            this.nextElement = this.next0();
        }

        public boolean hasNext() {
            return this.nextElement != null;
        }

        public void setDescendSection(boolean bl) {
            this.descendSection = bl;
            if (!this.descendSection && this.nextElement instanceof DataFieldSection && this.currentFormat == ((DataFieldSection)this.nextElement).getSectionFormat()) {
                this.currentIndex = this.currentFormat.getFieldCountAvailable();
            }
        }

        public Object next() {
            Object toRet = this.nextElement;
            if (this.nextElement != null) {
                this.nextElement = this.next0();
            }
            return toRet;
        }

        public Object next0() {
            if (this.currentIndex < this.currentFormat.getFieldCountAvailable()) {
                DataField toRet = this.currentFormat.getField(this.currentIndex);
                ++this.currentIndex;
                if (toRet instanceof DataFieldSection && this.descendSection) {
                    DataFieldSection childSection = (DataFieldSection)toRet;
                    this.currentFormat = childSection.getSectionFormat();
                    this.currentIndex = 0;
                }
                return toRet;
            }
            DataFieldSection parentSection = this.currentFormat.getParentSection();
            if (parentSection != null) {
                this.currentFormat = parentSection.getParentFormat();
                this.currentIndex = this.currentFormat.getFieldIndex(parentSection) + 1;
                return this.next0();
            }
            return null;
        }

        public void remove() {
        }
    }
}

