/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DataTypeException;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.DesignerTypeImpl;
import com.tplus.transform.design.FormulaTypeWrapper;
import com.tplus.transform.design.formula.FormulaTypeConstants;
import com.tplus.transform.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public abstract class DataTypeConstants {
    public static final DesignerType DESIGNER_BIG_DECIMAL_TYPE = DesignerTypeImpl.DESIGNER_BIG_DECIMAL_TYPE;
    public static final DesignerType DESIGNER_BIG_INT_TYPE = DesignerTypeImpl.DESIGNER_BIG_INT_TYPE;
    public static final DesignerType DESIGNER_BINARY_TYPE = DesignerTypeImpl.DESIGNER_BINARY_TYPE;
    public static final DesignerType DESIGNER_BOOLEAN_TYPE = DesignerTypeImpl.DESIGNER_BOOLEAN_TYPE;
    public static final DesignerType DESIGNER_VOID_TYPE = DesignerTypeImpl.DESIGNER_VOID_TYPE;
    public static final DesignerType DESIGNER_CHAR_TYPE = DesignerTypeImpl.DESIGNER_CHAR_TYPE;
    public static final DesignerType DESIGNER_DATAOBJECT_TYPE = DesignerTypeImpl.DESIGNER_DATAOBJECT_TYPE;
    public static final DesignerType DESIGNER_SCALED_DECIMAL_TYPE = DesignerTypeImpl.DESIGNER_SCALED_DECIMAL_TYPE;
    public static final DesignerType DESIGNER_DATE_ONLY_TYPE = DesignerTypeImpl.DESIGNER_DATE_ONLY_TYPE;
    public static final DesignerType DESIGNER_DATE_TIME_TYPE = DesignerTypeImpl.DESIGNER_DATE_TIME_TYPE;
    public static final DesignerType DESIGNER_DOUBLE_TYPE = DesignerTypeImpl.DESIGNER_DOUBLE_TYPE;
    public static final DesignerType DESIGNER_FLOAT_TYPE = DesignerTypeImpl.DESIGNER_FLOAT_TYPE;
    public static final DesignerType DESIGNER_INT_TYPE = DesignerTypeImpl.DESIGNER_INT_TYPE;
    public static final DesignerType DESIGNER_ISO_DATE_TYPE = DesignerTypeImpl.DESIGNER_ISO_DATE_TYPE;
    public static final DesignerType DESIGNER_ISO_DATE_TIME_TYPE = DesignerTypeImpl.DESIGNER_ISO_DATE_TIME_TYPE;
    public static final DesignerType DESIGNER_ISO_TIME_TYPE = DesignerTypeImpl.DESIGNER_ISO_TIME_TYPE;
    public static final DesignerType DESIGNER_LONG_TYPE = DesignerTypeImpl.DESIGNER_LONG_TYPE;
    public static final DesignerType DESIGNER_SECTION_TYPE = DesignerTypeImpl.DESIGNER_SECTION_TYPE;
    public static final DesignerType DESIGNER_STRING_TYPE = DesignerTypeImpl.DESIGNER_STRING_TYPE;
    public static final DesignerType DESIGNER_TIME_ONLY_TYPE = DesignerTypeImpl.DESIGNER_TIME_ONLY_TYPE;
    public static final DesignerType DESIGNER_RAW_MESSAGE_TYPE = DesignerTypeImpl.DESIGNER_RAW_MESSAGE_TYPE;
    public static final DesignerType DESIGNER_OBJECT_TYPE = DesignerTypeImpl.DESIGNER_OBJECT_TYPE;
    public static final DesignerType DESIGNER_MAP_TYPE = DesignerTypeImpl.DESIGNER_MAP_TYPE;
    public static final DesignerType DESIGNER_BIG_DECIMAL_LIST_TYPE = DesignerTypeImpl.DESIGNER_BIG_DECIMAL_LIST_TYPE;
    public static final DesignerType DESIGNER_BIG_INT_LIST_TYPE = DesignerTypeImpl.DESIGNER_BIG_INT_LIST_TYPE;
    public static final DesignerType DESIGNER_BINARY_LIST_TYPE = DesignerTypeImpl.DESIGNER_BINARY_LIST_TYPE;
    public static final DesignerType DESIGNER_BOOLEAN_LIST_TYPE = DesignerTypeImpl.DESIGNER_BOOLEAN_LIST_TYPE;
    public static final DesignerType DESIGNER_CHAR_LIST_TYPE = DesignerTypeImpl.DESIGNER_CHAR_LIST_TYPE;
    public static final DesignerType DESIGNER_SCALED_DECIMAL_LIST_TYPE = DesignerTypeImpl.DESIGNER_SCALED_DECIMAL_LIST_TYPE;
    public static final DesignerType DESIGNER_DATE_ONLY_LIST_TYPE = DesignerTypeImpl.DESIGNER_DATE_ONLY_LIST_TYPE;
    public static final DesignerType DESIGNER_DATE_TIME_LIST_TYPE = DesignerTypeImpl.DESIGNER_DATE_TIME_LIST_TYPE;
    public static final DesignerType DESIGNER_DOUBLE_LIST_TYPE = DesignerTypeImpl.DESIGNER_DOUBLE_LIST_TYPE;
    public static final DesignerType DESIGNER_FLOAT_LIST_TYPE = DesignerTypeImpl.DESIGNER_FLOAT_LIST_TYPE;
    public static final DesignerType DESIGNER_INT_LIST_TYPE = DesignerTypeImpl.DESIGNER_INT_LIST_TYPE;
    public static final DesignerType DESIGNER_ISO_DATE_LIST_TYPE = DesignerTypeImpl.DESIGNER_ISO_DATE_LIST_TYPE;
    public static final DesignerType DESIGNER_ISO_DATE_TIME_LIST_TYPE = DesignerTypeImpl.DESIGNER_ISO_DATE_TIME_LIST_TYPE;
    public static final DesignerType DESIGNER_ISO_TIME_LIST_TYPE = DesignerTypeImpl.DESIGNER_ISO_TIME_LIST_TYPE;
    public static final DesignerType DESIGNER_LONG_LIST_TYPE = DesignerTypeImpl.DESIGNER_LONG_LIST_TYPE;
    public static final DesignerType DESIGNER_STRING_LIST_TYPE = DesignerTypeImpl.DESIGNER_STRING_LIST_TYPE;
    public static final DesignerType DESIGNER_TIME_ONLY_LIST_TYPE = DesignerTypeImpl.DESIGNER_TIME_ONLY_LIST_TYPE;
    public static final DesignerType DESIGNER_RAW_MESSAGE_LIST_TYPE = DesignerTypeImpl.DESIGNER_RAW_MESSAGE_LIST_TYPE;
    public static final DesignerType DESIGNER_OBJECT_LIST_TYPE = DesignerTypeImpl.DESIGNER_OBJECT_LIST_TYPE;
    public static final DesignerType DESIGNER_MAP_LIST_TYPE = DesignerTypeImpl.DESIGNER_MAP_LIST_TYPE;
    private static final DesignerType[] basicFieldDataTypes = new DesignerType[]{DESIGNER_BOOLEAN_TYPE, DESIGNER_CHAR_TYPE, DESIGNER_DATE_TIME_TYPE, DESIGNER_DOUBLE_TYPE, DESIGNER_FLOAT_TYPE, DESIGNER_INT_TYPE, DESIGNER_LONG_TYPE, DESIGNER_STRING_TYPE};
    private static final DesignerType[] fieldDataTypes = new DesignerType[]{DESIGNER_BIG_DECIMAL_TYPE, DESIGNER_BIG_INT_TYPE, DESIGNER_BINARY_TYPE, DESIGNER_BOOLEAN_TYPE, DESIGNER_CHAR_TYPE, DESIGNER_DATE_ONLY_TYPE, DESIGNER_DATE_TIME_TYPE, DESIGNER_DOUBLE_TYPE, DESIGNER_FLOAT_TYPE, DESIGNER_ISO_DATE_TYPE, DESIGNER_ISO_DATE_TIME_TYPE, DESIGNER_ISO_TIME_TYPE, DESIGNER_INT_TYPE, DESIGNER_LONG_TYPE, DESIGNER_STRING_TYPE, DESIGNER_TIME_ONLY_TYPE, DESIGNER_SCALED_DECIMAL_TYPE};
    private static final DesignerType[] listDataTypes = new DesignerType[]{DESIGNER_BIG_DECIMAL_LIST_TYPE, DESIGNER_BIG_INT_LIST_TYPE, DESIGNER_BINARY_LIST_TYPE, DESIGNER_BOOLEAN_LIST_TYPE, DESIGNER_CHAR_LIST_TYPE, DESIGNER_DATE_ONLY_LIST_TYPE, DESIGNER_DATE_TIME_LIST_TYPE, DESIGNER_DOUBLE_LIST_TYPE, DESIGNER_FLOAT_LIST_TYPE, DESIGNER_ISO_DATE_LIST_TYPE, DESIGNER_ISO_DATE_TIME_LIST_TYPE, DESIGNER_ISO_TIME_LIST_TYPE, DESIGNER_INT_LIST_TYPE, DESIGNER_LONG_LIST_TYPE, DESIGNER_STRING_LIST_TYPE, DESIGNER_TIME_ONLY_LIST_TYPE, DESIGNER_SCALED_DECIMAL_LIST_TYPE, DESIGNER_RAW_MESSAGE_LIST_TYPE, DESIGNER_OBJECT_LIST_TYPE};
    private static final DesignerType[] fieldDataTypesNoISODATE = new DesignerType[]{DESIGNER_BIG_DECIMAL_TYPE, DESIGNER_BIG_INT_TYPE, DESIGNER_BINARY_TYPE, DESIGNER_BOOLEAN_TYPE, DESIGNER_CHAR_TYPE, DESIGNER_DATE_ONLY_TYPE, DESIGNER_DATE_TIME_TYPE, DESIGNER_DOUBLE_TYPE, DESIGNER_FLOAT_TYPE, DESIGNER_INT_TYPE, DESIGNER_LONG_TYPE, DESIGNER_STRING_TYPE, DESIGNER_TIME_ONLY_TYPE, DESIGNER_SCALED_DECIMAL_TYPE};
    private static final DesignerType[] allDataTypes = new DesignerType[]{DESIGNER_BIG_DECIMAL_TYPE, DESIGNER_BIG_INT_TYPE, DESIGNER_BINARY_TYPE, DESIGNER_BOOLEAN_TYPE, DESIGNER_CHAR_TYPE, DESIGNER_DATE_ONLY_TYPE, DESIGNER_DATE_TIME_TYPE, DESIGNER_DOUBLE_TYPE, DESIGNER_FLOAT_TYPE, DESIGNER_ISO_DATE_TYPE, DESIGNER_ISO_DATE_TIME_TYPE, DESIGNER_ISO_TIME_TYPE, DESIGNER_INT_TYPE, DESIGNER_LONG_TYPE, DESIGNER_STRING_TYPE, DESIGNER_TIME_ONLY_TYPE, DESIGNER_SCALED_DECIMAL_TYPE, DESIGNER_VOID_TYPE, DESIGNER_SECTION_TYPE, DESIGNER_DATAOBJECT_TYPE, DESIGNER_RAW_MESSAGE_TYPE, DESIGNER_OBJECT_TYPE, DESIGNER_MAP_TYPE};
    public static final Object[] formulaTypes = new Object[]{FormulaTypeConstants.BIG_DECIMAL_TYPE, FormulaTypeConstants.BIG_INTEGER_TYPE, FormulaTypeConstants.BINARY_TYPE, FormulaTypeConstants.BOOLEAN_TYPE, FormulaTypeConstants.CHAR_TYPE, FormulaTypeConstants.DATE_TYPE, FormulaTypeConstants.DATE_TYPE, FormulaTypeConstants.DOUBLE_TYPE, FormulaTypeConstants.FLOAT_TYPE, FormulaTypeConstants.ISO_DATE_TYPE, FormulaTypeConstants.ISO_DATE_TYPE, FormulaTypeConstants.ISO_DATE_TYPE, FormulaTypeConstants.INT_TYPE, FormulaTypeConstants.LONG_TYPE, FormulaTypeConstants.STRING_TYPE, FormulaTypeConstants.DATE_TYPE, FormulaTypeConstants.SCALED_DECIMAL_TYPE, FormulaTypeConstants.VOID_TYPE, FormulaTypeConstants.SECTION_TYPE, FormulaTypeConstants.MESSAGE_TYPE, FormulaTypeConstants.RAW_MESSAGE_TYPE, FormulaTypeConstants.OBJECT_TYPE, FormulaTypeConstants.MAP_TYPE};
    public static final Object[] formulaListTypes = new Object[]{FormulaTypeConstants.BIG_DECIMAL_LIST, FormulaTypeConstants.BIG_INTEGER_LIST, FormulaTypeConstants.BINARY_LIST, FormulaTypeConstants.BOOLEAN_LIST, FormulaTypeConstants.CHAR_LIST, FormulaTypeConstants.DATE_LIST, FormulaTypeConstants.DATE_LIST, FormulaTypeConstants.DOUBLE_LIST, FormulaTypeConstants.FLOAT_LIST, FormulaTypeConstants.CALENDAR_LIST, FormulaTypeConstants.CALENDAR_LIST, FormulaTypeConstants.CALENDAR_LIST, FormulaTypeConstants.INT_LIST, FormulaTypeConstants.LONG_LIST, FormulaTypeConstants.STRING_LIST, FormulaTypeConstants.DATE_LIST, FormulaTypeConstants.SCALED_DECIMAL_LIST, FormulaTypeConstants.RAW_MESSAGE_LIST, FormulaTypeConstants.OBJECT_LIST, FormulaTypeConstants.MAP_TYPE_LIST};

    public static String fixDesignerType(String type) {
        if ("Date".equals(type)) {
            type = "DateTime";
        }
        if ("Message".equals(type)) {
            type = "DataObject";
        }
        return type;
    }

    public static boolean isSectionType(DesignerType type) {
        return DESIGNER_SECTION_TYPE.equals(type);
    }

    public static boolean isSectionType(String type) {
        return DESIGNER_SECTION_TYPE.toString().equals(type);
    }

    public static String getDefaultFormat(DesignerType type) {
        return type.getDefaultFormat();
    }

    public static final String getDefaultFormatOrNull(DesignerType type) {
        if (DataTypeConstants.isDateOrTimeType(type)) {
            return DataTypeConstants.getDefaultFormat(type);
        }
        return null;
    }

    public static final String getCanonicalFormatOrNull(DesignerType type) {
        if (DataTypeConstants.isDateOrTimeType(type)) {
            return DataTypeConstants.getCanonicalDateFormat(type);
        }
        return null;
    }

    public static String getDefaultDateFormat(DesignerType type) {
        return type.getDefaultFormat();
    }

    public static String getCanonicalDateFormat(DesignerType type) {
        return type.getCanonicalFormat();
    }

    public static boolean isDateOrTimeType(DesignerType type) {
        return DataTypeConstants.isSimpleDateOrTimeType(type) || DataTypeConstants.isISODateOrTimeType(type);
    }

    public static boolean isDecimalType(DesignerType type) {
        return type.equals(DESIGNER_FLOAT_TYPE) || type.equals(DESIGNER_DOUBLE_TYPE) || type.equals(DESIGNER_BIG_DECIMAL_TYPE) || type.equals(DESIGNER_SCALED_DECIMAL_TYPE);
    }

    public static boolean isIntegralType(DesignerType type) {
        return type.equals(DESIGNER_INT_TYPE) || type.equals(DESIGNER_LONG_TYPE) || type.equals(DESIGNER_BIG_INT_TYPE);
    }

    public static boolean isSimpleDateOrTimeType(DesignerType type) {
        return DESIGNER_DATE_TIME_TYPE.equals(type) || DESIGNER_DATE_ONLY_TYPE.equals(type) || DESIGNER_TIME_ONLY_TYPE.equals(type);
    }

    public static boolean isISODateOrTimeType(DesignerType type) {
        return DESIGNER_ISO_DATE_TIME_TYPE.equals(type) || DESIGNER_ISO_DATE_TYPE.equals(type) || DESIGNER_ISO_TIME_TYPE.equals(type);
    }

    public static boolean isStringType(DesignerType type) {
        return DESIGNER_STRING_TYPE.equals(type);
    }

    public static boolean isIntegerType(DesignerType type) {
        return DESIGNER_INT_TYPE.equals(type);
    }

    public static boolean isNumericType(DesignerType type) {
        return type.isNumeric();
    }

    public static boolean isAssignableType(DesignerType destinationType, DesignerType srcType) {
        return destinationType.isAssignableFrom(srcType);
    }

    public static String getDesignerDateFormat(String format) {
        return DesignerTypeImpl.DesignerDateType.getDesignerDateFormat(format);
    }

    public static String getDesignerDateFormatFixMillis(String arg, String pattern) {
        pattern = DataTypeConstants.getDesignerDateFormat(pattern);
        try {
            return DesignerTypeImpl.DesignerDateType.getPatternFixMillis(arg, pattern);
        }
        catch (ParseException e) {
            return pattern;
        }
    }

    public static Date getDateForValue(String arg, String pattern) throws ParseException {
        Date date;
        pattern = DesignerTypeImpl.DesignerDateType.getDesignerDateFormat(pattern);
        try {
            date = DataTypeConstants.parseDate(arg, pattern);
        }
        catch (ParseException e) {
            if (pattern.indexOf(".SSS") != -1) {
                StringUtils.replace(pattern, ".SSS", "");
            }
            date = DataTypeConstants.parseDate(arg, pattern);
        }
        return date;
    }

    public static String[] getDesignerDateFormats() {
        return DesignerTypeImpl.DesignerDateType.getDesignerDateFormats();
    }

    public static boolean isValidFormat(DesignerType type, String format) {
        return type.isValidFormat(format);
    }

    public static boolean isValidValue(DesignerType type, String value, String format) {
        return type.isValidValue(value, format);
    }

    public static Object toFormulaType(DesignerType designerType) {
        int i;
        for (i = 0; i < allDataTypes.length; ++i) {
            if (!allDataTypes[i].equals(designerType)) continue;
            return formulaTypes[i];
        }
        for (i = 0; i < listDataTypes.length; ++i) {
            if (!listDataTypes[i].equals(designerType)) continue;
            return formulaListTypes[i];
        }
        if (designerType instanceof FormulaTypeWrapper) {
            return ((FormulaTypeWrapper)designerType).getFormulaType();
        }
        throw new IllegalArgumentException("Not a designer type " + designerType);
    }

    public static boolean isDesignerType(DesignerType designerType) {
        int i;
        for (i = 0; i < allDataTypes.length; ++i) {
            if (!allDataTypes[i].equals(designerType)) continue;
            return true;
        }
        for (i = 0; i < listDataTypes.length; ++i) {
            if (!listDataTypes[i].equals(designerType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSectionFormulaType(Object formulaType) {
        return formulaType instanceof DataFieldSection;
    }

    public static boolean isPredefinedFormulaType(Object formulaType) {
        for (int i = 0; i < formulaTypes.length; ++i) {
            if (!formulaTypes[i].equals(formulaType)) continue;
            return true;
        }
        return false;
    }

    public static DesignerType designerTypetoListDesignerType(DesignerType designerType) throws DataTypeException {
        for (int i = 0; i < allDataTypes.length; ++i) {
            if (!allDataTypes[i].equals(designerType)) continue;
            return listDataTypes[i];
        }
        throw new DataTypeException("No matching designer type '" + designerType + "'");
    }

    public static DesignerType listDesignerTypetoDesignerType(DesignerType designerType) throws DataTypeException {
        if (designerType instanceof DesignerTypeImpl.DesignerListType) {
            DesignerTypeImpl.DesignerListType designerListType = (DesignerTypeImpl.DesignerListType)designerType;
            return designerListType.getComponentType();
        }
        throw new DataTypeException("Not a list designer type '" + designerType + "'");
    }

    public static DesignerType toDesignerType(Object formulaType) throws DataTypeException {
        int i;
        for (i = 0; i < formulaTypes.length; ++i) {
            if (!formulaTypes[i].equals(formulaType) || i >= allDataTypes.length) continue;
            return allDataTypes[i];
        }
        for (i = 0; i < formulaListTypes.length; ++i) {
            if (!formulaListTypes[i].equals(formulaType) || i >= listDataTypes.length) continue;
            return listDataTypes[i];
        }
        if (formulaType instanceof DataFieldSection) {
            return DESIGNER_SECTION_TYPE;
        }
        if (formulaType instanceof DataFormat) {
            return DESIGNER_DATAOBJECT_TYPE;
        }
        throw new DataTypeException("No matching designer type for '" + formulaType + "'");
    }

    public static boolean isVoidFormulaType(Object formulaType) {
        return FormulaTypeConstants.VOID_TYPE.equals(formulaType);
    }

    public static DesignerType getDesignerType(String type) {
        try {
            type = DataTypeConstants.fixDesignerType(type);
            return DesignerTypeImpl.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            return DesignerTypeImpl.DESIGNER_STRING_TYPE;
        }
    }

    public static boolean isDesignerType(String type) {
        try {
            type = DataTypeConstants.fixDesignerType(type);
            DesignerTypeImpl.valueOf(type);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Date parseDate(String arg, String pattern) throws ParseException {
        return DesignerTypeImpl.DesignerDateType.parseDateFixMillis(arg, pattern);
    }

    public static String formatDate(Date date, String pattern) {
        return DesignerTypeImpl.DesignerDateType.formatDate(date, pattern);
    }

    public static String formatISODate(Calendar date, String pattern) {
        return DesignerTypeImpl.DesignerDateType.formatDate(date, pattern);
    }

    public static DesignerType[] getBasicFieldDataTypes() {
        return basicFieldDataTypes;
    }

    public static DesignerType[] getFieldDataTypes() {
        return fieldDataTypes;
    }

    public static DesignerType[] getListDataTypes() {
        return listDataTypes;
    }

    public static DesignerType[] getFieldDataTypesNoISODATE() {
        return fieldDataTypesNoISODATE;
    }

    public static DesignerType[] getAllDataTypes() {
        return allDataTypes;
    }

    public static DesignerType[] getAllTypes(boolean voidType, boolean rawMessageType, boolean listType) {
        ArrayList<DesignerType> paramTypeList = new ArrayList<DesignerType>(Arrays.asList(DataTypeConstants.getAllDataTypes()));
        if (!voidType) {
            paramTypeList.remove(DESIGNER_VOID_TYPE);
        }
        if (!rawMessageType) {
            paramTypeList.remove(DESIGNER_RAW_MESSAGE_TYPE);
        }
        if (listType) {
            paramTypeList.addAll(Arrays.asList(DataTypeConstants.getListDataTypes()));
        }
        DesignerType[] dataTypes = paramTypeList.toArray(new DesignerType[paramTypeList.size()]);
        return dataTypes;
    }

    public static DesignerType[] getFieldTypes(boolean rawMessageType, boolean listType) {
        ArrayList<DesignerType> paramTypeList = new ArrayList<DesignerType>(Arrays.asList(DataTypeConstants.getFieldDataTypes()));
        if (rawMessageType) {
            paramTypeList.add(DESIGNER_RAW_MESSAGE_TYPE);
            paramTypeList.add(DESIGNER_OBJECT_TYPE);
            paramTypeList.add(DESIGNER_MAP_TYPE);
        }
        if (listType) {
            paramTypeList.addAll(Arrays.asList(DataTypeConstants.getListDataTypes()));
        }
        DesignerType[] dataTypes = paramTypeList.toArray(new DesignerType[paramTypeList.size()]);
        return dataTypes;
    }
}

