/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DesignElementChangeListener;
import com.tplus.transform.design.DesignElementEvent;
import com.tplus.transform.design.DesignElementFindProperties;
import com.tplus.transform.design.DiffHelper;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.ElementContent;
import com.tplus.transform.design.FindMessageListener;
import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.ILocation;
import com.tplus.transform.design.PropertyInfos;
import com.tplus.transform.design.ReadWriteEnum;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.UUID;
import com.tplus.transform.util.diff.ElementComparator;
import com.tplus.transform.util.diff.ListMatcher;
import com.tplus.transform.util.diff.MatchProcessor;
import com.tplus.transform.util.diff.ObjectMatch;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class DesignElement
implements Serializable,
IDesignElement {
    protected static Log log = LogFactory.getLog(DesignElement.class);
    private static final char PATH_SEPARATOR_CHAR = '/';
    public static final String PATH_SEPARATOR = Character.toString('/');
    private transient List designElementChangeListeners = new ArrayList();
    private static final String SAVED_STATE = "SAVED_STATE";
    private transient boolean modified = true;
    private String name;
    private ReadWriteEnum readWriteState = ReadWriteEnum.INHERITED;
    private UUID id;
    private Map properties;
    private transient IDesignElement parent;
    private transient Map tempProperties;
    private static final long serialVersionUID = -7754924792442204614L;

    protected static void logassert(boolean bl, String message) {
        if (!bl) {
            log.error("Assertion failed. " + message);
        }
    }

    public DesignElement(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getContentName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List children() {
        int childCount = this.getChildCount();
        ArrayList<IDesignElement> toRet = new ArrayList<IDesignElement>(childCount);
        for (int i = 0; i < childCount; ++i) {
            IDesignElement childElm = this.getChild(i);
            toRet.add(childElm);
        }
        return toRet;
    }

    public String getPathName() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public final UUID getDesignElementID() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public final void setDesignElementID(UUID id) {
        DesignElement.logassert(this.id != null, "Id already set for " + this);
        this.id = id;
    }

    public IDesignElement findByID(UUID id, boolean recurse) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            IDesignElement found;
            IDesignElement elm = this.getChild(i);
            if (elm.getDesignElementID().equals(id)) {
                return elm;
            }
            if (!recurse || (found = elm.findByID(id, recurse)) == null) continue;
            return found;
        }
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public IDesignElement getChild(int index) {
        throw new IllegalArgumentException("Invalid child index");
    }

    public boolean shouldExpandOnDemand() {
        return false;
    }

    public boolean isNodeModified() {
        return this.modified;
    }

    public final boolean isNodeModifiedIgnoreChild() {
        return this.modified;
    }

    public boolean isModified() {
        if (this.isNodeModified()) {
            return true;
        }
        return this.isChildModified();
    }

    protected boolean isChildModified() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            IDesignElement child = this.getChild(i);
            if (!child.isModified()) continue;
            return true;
        }
        return false;
    }

    public void clearModified(boolean includeChildren) {
        this.setNodeModified(false);
        if (includeChildren) {
            this.clearChildrenModified(includeChildren);
        }
    }

    protected void clearChildrenModified(boolean includeChildren) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            IDesignElement child = this.getChild(i);
            if (child.isRoot()) {
                child.setNodeModified(false);
                continue;
            }
            child.clearModified(includeChildren);
        }
    }

    public ReadWriteEnum getReadWriteState() {
        return this.readWriteState;
    }

    public void setReadWriteState(ReadWriteEnum readWriteState) {
        this.readWriteState = readWriteState;
    }

    public boolean isReadOnly() {
        if (this.readWriteState == ReadWriteEnum.READ) {
            return true;
        }
        if (this.readWriteState == ReadWriteEnum.INHERITED) {
            IDesignElement parent = this.getParent();
            if (parent != null) {
                return parent.isReadOnly();
            }
            log.error("Root element " + this.getClass().getName() + " has inherit attribute set", new Exception());
        }
        return false;
    }

    public boolean delete(IDesignElement elm) {
        return false;
    }

    public boolean canDelete(IDesignElement elm) {
        return false;
    }

    public void setNodeModified(boolean modified) {
        this.modified = modified;
        if (!modified) {
            this.setSavedState(null);
        }
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new SequencedHashMap();
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.getProperties().remove(name);
        } else {
            this.getProperties().put(name, value);
        }
    }

    public Map getTransientProperties() {
        if (this.tempProperties == null) {
            this.tempProperties = new Hashtable();
        }
        return this.tempProperties;
    }

    public Object getTransientProperty(String name) {
        if (this.tempProperties == null) {
            return null;
        }
        return this.tempProperties.get(name);
    }

    public void setTransientProperty(String name, Object value) {
        if (value == null) {
            this.getTransientProperties().remove(name);
        } else {
            this.getTransientProperties().put(name, value);
        }
    }

    public void fireDesignElementChanged(DesignElementEvent e) {
        List listeners = this.getDesignElementChangeListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            DesignElementChangeListener listener = (DesignElementChangeListener)listeners.get(i);
            listener.designElementChanged(e);
        }
    }

    public void addDesignElementChangeListener(DesignElementChangeListener listener) {
        this.getDesignElementChangeListeners().add(listener);
    }

    public void removeDesignElementChangeListener(DesignElementChangeListener listener) {
        this.getDesignElementChangeListeners().remove(listener);
    }

    private List getDesignElementChangeListeners() {
        if (this.designElementChangeListeners == null) {
            this.designElementChangeListeners = new ArrayList();
        }
        return this.designElementChangeListeners;
    }

    public abstract void validate(ValidationMessageListener var1);

    public void validateAll(ValidationMessageListener listener) {
        long start = System.currentTimeMillis();
        listener.setCurrentElement(this);
        this.validate(listener);
        this.validateChildren(listener);
        listener.unsetCurrentElement(this);
        long end = System.currentTimeMillis();
    }

    public void validateChildren(ValidationMessageListener listener) {
        DesignElement.validateChildren(this, listener);
    }

    public static void validateChildren(IDesignElement currentElm, ValidationMessageListener listener) {
        HashSet validatedElements = new HashSet();
        DesignElement.validateChildrenImpl(currentElm, listener, validatedElements);
    }

    public static void validateChildrenImpl(IDesignElement currentElm, ValidationMessageListener listener, Set validatedElements) {
        if (currentElm.isExcluded()) {
            return;
        }
        int count = currentElm.getChildCount();
        for (int i = 0; i < count; ++i) {
            IDesignElement elm = currentElm.getChild(i);
            if (elm.isExcluded() || validatedElements.contains(elm)) continue;
            validatedElements.add(elm);
            listener.setCurrentElement(elm);
            elm.validate(listener);
            DesignElement.validateChildrenImpl(elm, listener, validatedElements);
            listener.unsetCurrentElement(elm);
        }
    }

    public void visitAll(IDesignElement.IDesignElementVisitor visitor) {
        if (visitor.notify(this)) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                IDesignElement elm = this.getChild(i);
                elm.visitAll(visitor);
            }
        }
    }

    public void setParent(IDesignElement parent) {
        this.parent = parent;
    }

    public IDesignElement getParent() {
        return this.parent;
    }

    public void setSavedState(IDesignElement elm) {
        this.setTransientProperty(SAVED_STATE, elm);
    }

    public IDesignElement getSavedState() {
        return (IDesignElement)this.getTransientProperty(SAVED_STATE);
    }

    public void findAll(DesignElementFindProperties findProperties, FindMessageListener listener) {
        this.find(findProperties, listener);
        DesignElement.findInChildren(this, findProperties, listener);
    }

    public void find(DesignElementFindProperties findProperties, FindMessageListener listener) {
    }

    private static void findInChildren(IDesignElement currentElm, DesignElementFindProperties findProperties, FindMessageListener listener) {
        for (int i = 0; i < currentElm.getChildCount(); ++i) {
            IDesignElement elm = currentElm.getChild(i);
            listener.setCurrentElement(elm);
            elm.findAll(findProperties, listener);
            listener.unsetCurrentElement(elm);
        }
    }

    public void diff(IDesignElement with, DiffMessageListener listener) {
    }

    public void diffAll(IDesignElement with, DiffMessageListener listener) {
        if (this.isExcluded() || with.isExcluded()) {
            DiffHelper.diffBoolean(this.isExcluded(), with.isExcluded(), this, with, "Excluded", listener);
            return;
        }
        this.diff(with, listener);
        DesignElement.diffInChildren(this, with, listener);
    }

    private static List getChildElements(IDesignElement elm) {
        ArrayList<IDesignElement> children = new ArrayList<IDesignElement>();
        if (elm != null) {
            for (int i = 0; i < elm.getChildCount(); ++i) {
                children.add(elm.getChild(i));
            }
        }
        return children;
    }

    private static void diffInChildren(IDesignElement currentElm1, IDesignElement currentElm2, DiffMessageListener listener) {
        List children1 = DesignElement.getChildElements(currentElm1);
        List children2 = DesignElement.getChildElements(currentElm2);
        new ListMatcher(new DesignElementComparator(listener)).match(children1, children2);
    }

    private static void setChildrenMatchAsNull(IDesignElement currentElm1, IDesignElement currentElm2, DiffMessageListener listener) {
        int i;
        List children1 = DesignElement.getChildElements(currentElm1);
        List children2 = DesignElement.getChildElements(currentElm2);
        for (i = 0; i < children1.size(); ++i) {
            IDesignElement elm1 = (IDesignElement)children1.get(i);
            listener.matchElements(elm1, null);
            DesignElement.setChildrenMatchAsNull(elm1, null, listener);
        }
        for (i = 0; i < children2.size(); ++i) {
            IDesignElement elm2 = (IDesignElement)children2.get(i);
            listener.matchElements(null, elm2);
            DesignElement.setChildrenMatchAsNull(null, elm2, listener);
        }
    }

    public boolean isRoot() {
        return false;
    }

    public void assignParent() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            IDesignElement child = this.getChild(i);
            if (child.isRoot()) continue;
            this.assignParent(child);
        }
    }

    public void assignParent(IDesignElement child) {
        child.setParent(this);
        child.assignParent();
    }

    public List getAllElements() {
        ArrayList<DesignElement> allElements = new ArrayList<DesignElement>();
        allElements.add(this);
        DesignElement.getAllElements(this, allElements);
        return allElements;
    }

    private static void getAllElements(IDesignElement elm, List allElements) {
        for (int i = 0; i < elm.getChildCount(); ++i) {
            IDesignElement child = elm.getChild(i);
            allElements.add(child);
            DesignElement.getAllElements(child, allElements);
        }
    }

    public String getPath() {
        return DesignElement.getPath(this);
    }

    public Object getLocationFromString(String str) {
        return null;
    }

    public String getStringFromLocation(Object location) {
        if (location instanceof ILocation) {
            return ((ILocation)location).getLocationName();
        }
        return null;
    }

    public ElementContent getLocationContent(Object location) {
        return null;
    }

    public static String getPath(IDesignElement elm) {
        IDesignElement parent = elm.getParent();
        if (parent != null) {
            String pathName = DesignElement.getCanonicalPathName(elm);
            return DesignElement.getPath(parent) + PATH_SEPARATOR + pathName;
        }
        return elm.getName();
    }

    public static String getPathFromRoot(IDesignElement elm) {
        IDesignElement parent = elm.getParent();
        if (elm.isRoot() || parent == null) {
            return DesignElement.getCanonicalPathName(elm);
        }
        String pathName = DesignElement.getCanonicalPathName(elm);
        return DesignElement.getPathFromRoot(parent) + PATH_SEPARATOR + pathName;
    }

    public boolean isPathName(String name) {
        return DesignElement.getCanonicalPathName(this).equals(name);
    }

    private static String getCanonicalPathName(IDesignElement elm) {
        String pathName = elm.getPathName();
        pathName = StringUtils.fixNull(pathName);
        pathName = pathName.replace('/', '_');
        return pathName;
    }

    public IDesignElement findChildElement(String path, boolean includeThis) {
        if (includeThis) {
            String root = StringUtils.leftStr(path, PATH_SEPARATOR);
            if (!this.isPathName(root)) {
                return null;
            }
            if (!root.equals(path)) {
                path = StringUtils.rightStr(path, PATH_SEPARATOR);
            } else {
                return this;
            }
        }
        return this.findChildElement(path);
    }

    public boolean canImport(String type) {
        return true;
    }

    public boolean canExport(String type) {
        return true;
    }

    public boolean isExcluded() {
        return false;
    }

    public IDesignElement findChildElement(String path) {
        if (path == null) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(path, PATH_SEPARATOR);
        IDesignElement currentElement = this;
        block0: while (stk.hasMoreTokens() && currentElement != null) {
            String token = stk.nextToken();
            for (int i = 0; i < currentElement.getChildCount(); ++i) {
                IDesignElement child = currentElement.getChild(i);
                if (!child.isPathName(token)) continue;
                currentElement = child;
                continue block0;
            }
            currentElement = null;
        }
        return currentElement;
    }

    public IDesignElement getRootElement() {
        if (this.getParent() == null) {
            return this;
        }
        return this.getParent().getRootElement();
    }

    public IDesignElement getRootAncestor() {
        if (this.isRoot()) {
            return this;
        }
        if (this.getParent() == null) {
            log.error("Element with out root ancestor " + this.getClass().getName() + ":" + this.getName(), new Exception());
            return null;
        }
        return this.getParent().getRootAncestor();
    }

    public IDesignElement getAncestorElement(Class cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getAncestorElement(cls);
    }

    public boolean isChild(IDesignElement elm) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            IDesignElement child = this.getChild(i);
            if (child == elm) {
                return true;
            }
            if (!child.isChild(elm)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(IDesignElement parent, IDesignElement child) {
        return parent != null && (parent == child || parent.isChild(child));
    }

    public List getChildElements(Class cls) {
        ArrayList list = new ArrayList();
        this.getChildElements(this, cls, list);
        return list;
    }

    private void getChildElements(IDesignElement elm, final Class cls, final List list) {
        elm.visitAll(new IDesignElement.UniqueElementVisitor(new IDesignElement.IDesignElementVisitor(){

            public boolean notify(IDesignElement elm) {
                if (cls.isInstance(elm)) {
                    list.add(elm);
                }
                return true;
            }
        }));
    }

    public void set(String name, Object value) {
        throw new IllegalArgumentException("Property '" + name + "' not supported");
    }

    public Object get(String name) {
        throw new IllegalArgumentException("Property '" + name + "' not supported");
    }

    public static String fixNull(String name) {
        return name == null ? "" : name;
    }

    public PropertyInfos getPropertyInfos() {
        return new PropertyInfos();
    }

    public boolean isEntryPoint() {
        return false;
    }

    public String getServiceProperty(String name) {
        return null;
    }

    public static boolean isAncestor(IDesignElement designElement, IDesignElement ancestor) {
        while (designElement != null) {
            if (designElement == ancestor) {
                return true;
            }
            designElement = designElement.getParent();
        }
        return false;
    }

    public static class DesignElementComparator
    implements ElementComparator,
    MatchProcessor {
        private DiffMessageListener listener;

        public DesignElementComparator(DiffMessageListener listener) {
            this.listener = listener;
        }

        public int getSimilarityIndex(Object obj1, Object obj2) {
            IDesignElement elm1 = (IDesignElement)obj1;
            IDesignElement elm2 = (IDesignElement)obj2;
            return elm1.getClass() == elm2.getClass() && elm1.getName().equals(elm2.getName()) ? 0 : -1;
        }

        public void applyMatch(ObjectMatch match) {
            IDesignElement elm1 = (IDesignElement)match.getElement1();
            IDesignElement elm2 = (IDesignElement)match.getElement2();
            this.listener.setCurrentElement(elm1, elm2);
            if (elm1 != null && elm2 != null) {
                elm1.diffAll(elm2, this.listener);
            } else {
                DesignElement.setChildrenMatchAsNull(elm1, elm2, this.listener);
            }
            this.listener.unsetCurrentElement(elm1, elm2);
        }
    }
}

