/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DesignElementEntity;
import com.tplus.transform.design.DesignElementFindProperties;
import com.tplus.transform.design.FindMessageListener;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.util.Location;
import com.tplus.transform.util.Text;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DesignElementFindHelper
extends DesignElementEntity {
    private String searchText = null;
    private boolean matchCase = false;
    private boolean shouldSearchName = false;
    private boolean shouldSearchComment = false;
    private boolean shouldSearchAliasName = false;
    private boolean shouldSearchDetailName = false;
    private boolean shouldSearchDesc = false;
    private boolean exact = false;
    private boolean ignoreOptionalFields = false;
    private boolean ignoreDisabledFields = false;
    private boolean shouldSearchFormula = false;
    private boolean shouldSearchDefaultValue = false;
    private boolean shouldSearchOthers = false;
    private boolean regularExpression = false;
    private static final String REG_EXP_MATCH_LINE_BEGINNING = "^";
    private static final String REG_EXP_MATCH_LINE_END = "$";
    protected static Log log = LogFactory.getLog("com.tplus.transform.design");
    DesignElementFindProperties findProperties;

    public DesignElementFindHelper(DesignElementFindProperties findProperties) {
        this.findProperties = findProperties;
        this.searchText = findProperties.getProperty("Search.Text");
        this.exact = findProperties.getBooleanProperty("Search.Criteria.MatchWord", false);
        this.matchCase = findProperties.getBooleanProperty("Search.Criteria.MatchCase", false);
        this.shouldSearchName = findProperties.getBooleanProperty("Search.Name", true);
        this.shouldSearchAliasName = findProperties.getBooleanProperty("Search.AliasName", false);
        this.shouldSearchDetailName = findProperties.getBooleanProperty("Search.DetailName", false);
        this.shouldSearchDesc = findProperties.getBooleanProperty("Search.Description", false);
        this.ignoreOptionalFields = findProperties.getBooleanProperty("Search.Ignore.Optional", false);
        this.ignoreDisabledFields = findProperties.getBooleanProperty("Search.Ignore.Disabled", false);
        this.shouldSearchFormula = findProperties.getBooleanProperty("Search.Formula", false);
        this.shouldSearchDefaultValue = findProperties.getBooleanProperty("Search.DefaultValue", false);
        this.regularExpression = findProperties.getBooleanProperty("Search.Criteria.RegularExpression", false);
        this.shouldSearchOthers = findProperties.getBooleanProperty("Search.Others", false);
        this.shouldSearchComment = findProperties.getBooleanProperty("Search.Comment", false);
    }

    public boolean isShouldSearchFormula() {
        return this.shouldSearchFormula;
    }

    public boolean isShouldSearchName() {
        return this.shouldSearchName;
    }

    public boolean isMatch(Object findIn) {
        if (findIn != null) {
            return this.isMatch0(findIn.toString(), this.searchText);
        }
        return false;
    }

    public Location getMatch(String findIn) {
        return this.getMatch(findIn, this.searchText);
    }

    public boolean isMatch(String findIn) {
        return this.isMatch0(findIn, this.searchText);
    }

    public boolean shouldIgnore(DataField fld) {
        if (fld == null) {
            return false;
        }
        if (this.ignoreOptionalFields && (fld instanceof DataFieldSection ? fld.isOptional() : fld.isNullable())) {
            return true;
        }
        return this.ignoreDisabledFields && !fld.isEnabled();
    }

    public void matchName(String name, FindMessageListener listener) {
        this.matchName(name, null, listener);
    }

    public void matchDescription(String name, FindMessageListener listener) {
        this.matchDescription(name, null, listener);
    }

    public void matchName(String name, Object location, FindMessageListener listener) {
        if (this.shouldSearchName && this.isMatch(name)) {
            listener.matchFound(name, location, "Name");
        }
    }

    public void matchDescription(String desc, Object location, FindMessageListener listener) {
        if (this.shouldSearchDesc && this.isMatch(desc)) {
            listener.matchFound(desc, location, "Description");
        }
    }

    public boolean isShouldSearchAliasName() {
        return this.shouldSearchAliasName;
    }

    public boolean isShouldSearchDetailName() {
        return this.shouldSearchDetailName;
    }

    public boolean isShouldSearchDefaultValue() {
        return this.shouldSearchDefaultValue;
    }

    public boolean isShouldSearchOthers() {
        return this.shouldSearchOthers;
    }

    private boolean isMatch0(String findIn, String search) {
        return this.getMatch(findIn, search) != null;
    }

    private Location getMatch(String findIn, String search) {
        if (findIn == null) {
            return null;
        }
        if (!this.regularExpression) {
            if (!this.matchCase) {
                findIn = findIn.toLowerCase();
                search = search.toLowerCase();
            }
            if (this.exact) {
                if (findIn.equals(search)) {
                    return new Location(1, 1);
                }
                return null;
            }
            int matchLocation = findIn.indexOf(search);
            if (matchLocation != -1 || search.length() == 0) {
                return this.toLocation(findIn, matchLocation);
            }
            return null;
        }
        try {
            Pattern pattern;
            Matcher m;
            boolean b;
            if (this.exact) {
                search = REG_EXP_MATCH_LINE_BEGINNING + search + REG_EXP_MATCH_LINE_END;
            }
            int flag = 0;
            if (!this.matchCase) {
                flag = 2;
            }
            if (b = (m = (pattern = DesignElementFindHelper.getRegEx(search, flag)).matcher(findIn)).find()) {
                int matchLocation = m.start();
                return this.toLocation(findIn, matchLocation);
            }
            return null;
        }
        catch (PatternSyntaxException e) {
            log.debug("Regular Expression Error : " + e.getMessage(), e);
            throw new IllegalArgumentException("Invalid regular expression. " + e.getMessage());
        }
    }

    private Location toLocation(String findIn, int matchLocation) {
        return Text.getLocation(findIn, matchLocation);
    }

    private static Pattern getRegEx(String regex, int flag) {
        try {
            Pattern p = Pattern.compile(regex, flag);
            return p;
        }
        catch (PatternSyntaxException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT572", regex);
            tre.setDetail(e);
            throw tre;
        }
    }

    public boolean isShouldSearchComment() {
        return this.shouldSearchComment;
    }
}

