/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DesignElement;
import com.tplus.transform.design.FileElement;
import com.tplus.transform.design.IDesignElement;

public class DesignerElementReference {
    String rootName;
    String relativePath;
    Class elementClass;
    Object elementObject;

    public DesignerElementReference(String rootName, String relativePath) {
        this.rootName = rootName;
        this.relativePath = relativePath;
    }

    public DesignerElementReference(IDesignElement elm) {
        if (elm != null) {
            this.relativePath = DesignElement.getPathFromRoot(elm);
            IDesignElement rootAncestor = elm.getRootAncestor();
            this.rootName = rootAncestor instanceof FileElement ? ((FileElement)rootAncestor).getFileName() : "";
            this.elementClass = elm.getClass();
        }
    }

    public String getRootName() {
        return this.rootName;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Object getElementObject() {
        return this.elementObject;
    }

    public void setElementClass(Class elementClass) {
        this.elementClass = elementClass;
    }

    public void setElementObject(Object elementObject) {
        this.elementObject = elementObject;
    }

    public boolean equals(IDesignElement elm) {
        return this.equals(new DesignerElementReference(elm));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesignerElementReference that = (DesignerElementReference)o;
        if (this.relativePath != null ? !this.relativePath.equals(that.relativePath) : that.relativePath != null) {
            return false;
        }
        return !(this.rootName != null ? !this.rootName.equals(that.rootName) : that.rootName != null);
    }

    public int hashCode() {
        int result = this.rootName != null ? this.rootName.hashCode() : 0;
        result = 31 * result + (this.relativePath != null ? this.relativePath.hashCode() : 0);
        return result;
    }
}

