/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DesignerElementReference;
import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.ILocation;
import com.tplus.transform.util.StringUtils;
import java.io.File;

public class DesignerMessage {
    private final DesignerElementReference elmRef;
    private String subLocation;
    private String message;
    private String node;
    private String location;
    private String property;
    private String iconResource;

    public DesignerMessage(IDesignElement elm, String message, String node, Object location, String property) {
        if (elm == null) {
            // empty if block
        }
        this.elmRef = new DesignerElementReference(elm);
        this.message = message;
        if (node == null && elm != null) {
            node = this.elmRef.getRelativePath().replace('/', '.');
        }
        this.node = node;
        this.location = DesignerMessage.locationToString(location);
        this.property = property;
    }

    public DesignerMessage(DesignerElementReference elm, String message, String node, String location, String property) {
        this.elmRef = elm;
        this.message = message;
        if (node == null) {
            node = this.elmRef.getRelativePath().replace('/', '.');
        }
        this.node = node;
        this.location = DesignerMessage.locationToString(location);
        this.property = property;
    }

    public DesignerMessage(IDesignElement elm, String message) {
        if (elm == null) {
            // empty if block
        }
        this.elmRef = new DesignerElementReference(elm);
        this.message = message;
    }

    public static String locationToString(Object location) {
        if (location != null) {
            if (location instanceof String) {
                return (String)location;
            }
            if (location instanceof ILocation) {
                return ((ILocation)location).getLocationName();
            }
        }
        return null;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getNode() {
        return this.node;
    }

    public Object getLocation() {
        return this.location;
    }

    public String getLocationString() {
        return this.location;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isLocation(Object location) {
        return DesignerMessage.isLocationEquals(this.location, location);
    }

    public static boolean isLocationEquals(Object location1, Object location2) {
        if (location1 == location2 || location1 != null && location1.equals(location2)) {
            return true;
        }
        return (location1 = DesignerMessage.toLocationString(location1)) == (location2 = DesignerMessage.toLocationString(location2)) || location1 != null && location1.equals(location2);
    }

    private static Object toLocationString(Object location1) {
        if (location1 instanceof ILocation) {
            location1 = ((ILocation)location1).getLocationName();
        }
        return location1;
    }

    public String getNodeName() {
        String relativePath;
        if (this.elmRef != null && (relativePath = this.elmRef.getRelativePath()) != null) {
            return StringUtils.lastRightStr(relativePath, "/");
        }
        return null;
    }

    public String getEntityName() {
        if (this.elmRef != null) {
            String root = this.elmRef.getRootName();
            if (root != null) {
                root = StringUtils.lastRightStr(root, File.separator);
            }
            return root;
        }
        return null;
    }

    public DesignerElementReference getDesignElementReference() {
        return this.elmRef;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toMessage() {
        String name = this.node;
        StringBuffer toPrint = new StringBuffer();
        toPrint.append("[").append(this.getEntityName()).append("]");
        toPrint.append(name);
        toPrint.append(": ");
        toPrint.append(this.message);
        return toPrint.toString();
    }

    public static String getQualifiedElementName(IDesignElement elm) {
        String name = null;
        for (IDesignElement currentElm = elm; currentElm != null; currentElm = currentElm.getParent()) {
            name = currentElm.getName() + (name == null ? "" : "." + name);
        }
        return name;
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void setIconResource(String iconResource) {
        this.iconResource = iconResource;
    }

    public String getSubLocation() {
        return this.subLocation;
    }

    public void setSubLocation(String subLocation) {
        this.subLocation = subLocation;
    }
}

