/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.util.EnumObject;
import java.util.ArrayList;
import java.util.List;

public class DesignerTypeCategory
extends EnumObject {
    private static final EnumObject.EnumClassObjectInfo objInfo = new EnumObject.EnumClassObjectInfo(DesignerTypeCategory.class);
    public static final DesignerTypeCategory DECIMAL = new DesignerTypeCategory("Decimal");
    public static final DesignerTypeCategory INTEGRAL = new DesignerTypeCategory("Integral");
    public static final DesignerTypeCategory DATE = new DesignerTypeCategory("Date");
    public static final DesignerTypeCategory TEXT = new DesignerTypeCategory("Text");
    public static final DesignerTypeCategory RAW = new DesignerTypeCategory("Raw");
    public static final DesignerTypeCategory BOOLEAN = new DesignerTypeCategory("Boolean");
    public static final DesignerTypeCategory VOID = new DesignerTypeCategory("Void");
    public static final DesignerTypeCategory MESSAGE = new DesignerTypeCategory("Message");
    public static final DesignerTypeCategory ANY = new DesignerTypeCategory("Unknown");
    public static final DesignerTypeCategory LIST = new DesignerTypeCategory("List");
    public static final DesignerTypeCategory MAP = new DesignerTypeCategory("Map");

    private DesignerTypeCategory(String name, int ordinal) {
        super(name, ordinal);
    }

    private DesignerTypeCategory(String name) {
        super(name);
    }

    public static DesignerTypeCategory[] values() {
        return (DesignerTypeCategory[])objInfo.values();
    }

    public static String[] names() {
        return objInfo.names();
    }

    public static DesignerTypeCategory valueOf(String name) {
        return (DesignerTypeCategory)objInfo.valueOf(name);
    }

    public static DesignerTypeCategory valueOf(int ordinal) {
        return (DesignerTypeCategory)objInfo.valueOf(ordinal);
    }

    protected EnumObject.EnumClassObjectInfo getEnumClassObjectInfo() {
        return objInfo;
    }

    public static DesignerType[] sortTypesByCategory(DesignerType[] designerTypes) {
        ArrayList<DesignerType> types = new ArrayList<DesignerType>(20);
        for (int i = 0; i < designerTypes.length; ++i) {
            DesignerType designerType = designerTypes[i];
            if (!DesignerTypeCategory.isCommonType(designerType)) continue;
            types.add(designerType);
        }
        DesignerTypeCategory.addTypeByCategory(INTEGRAL, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(DECIMAL, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(DATE, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(RAW, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(TEXT, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(MESSAGE, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(VOID, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(ANY, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(LIST, designerTypes, types);
        DesignerTypeCategory.addTypeByCategory(MAP, designerTypes, types);
        return types.toArray(new DesignerType[types.size()]);
    }

    private static void addTypeByCategory(DesignerTypeCategory category, DesignerType[] designerTypes, List types) {
        for (int i = 0; i < designerTypes.length; ++i) {
            DesignerType designerType = designerTypes[i];
            if (designerType.getTypeCategory() != category) continue;
            types.add(designerType);
        }
    }

    public static boolean isCommonType(DesignerType designerType) {
        return designerType == DataTypeConstants.DESIGNER_STRING_TYPE || designerType == DataTypeConstants.DESIGNER_CHAR_TYPE || designerType == DataTypeConstants.DESIGNER_INT_TYPE || designerType == DataTypeConstants.DESIGNER_DOUBLE_TYPE || designerType == DataTypeConstants.DESIGNER_BOOLEAN_TYPE || designerType == DataTypeConstants.DESIGNER_DATE_TIME_TYPE;
    }
}

